package org.injac.oai.util;

import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.InputStream;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;



public class XSLTransformer implements URIResolver  {
	static Logger logger = Logger.getLogger("INJAC_OAI");
	private String basePath = "";
	protected Transformer transformer = null;

	public Transformer getTransformer() {
		return transformer;
	}
	
	public XSLTransformer(String xslFilename) {
		init(xslFilename);
		
		
		
	}
	public void setParameter(String name, Object value){
		transformer.setParameter(name, value);
	}
	public void clearParameters(){
		transformer.clearParameters();
	}
	/**
	 * init transformer with xsl file
	 * 
	 */
	public void init(String xslFilename) {
		basePath = xslFilename.substring(0, xslFilename.lastIndexOf(java.io.File.separator)+1);
		try {
			String xsltName = xslFilename;
			if (xsltName != null) {
				StreamSource xslSource = new StreamSource(new FileInputStream(
						xsltName));
				TransformerFactory tFactory = TransformerFactory.newInstance();
				transformer = tFactory.newTransformer(xslSource);
				transformer.setURIResolver(this);
				transformer.setOutputProperty(
						OutputKeys.OMIT_XML_DECLARATION, "yes");
				transformer.setOutputProperty(
					OutputKeys.ENCODING, "UTF-8");
				transformer.setOutputProperty(OutputKeys.STANDALONE, "no");
				transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}

	public String transform(Document xmlDoc) {
		try {
			if (transformer != null) {
				StringReader stringReader = new StringReader(xmlDoc.toString());
				StreamSource streamSource = new StreamSource(stringReader);
				StringWriter stringWriter = new StringWriter();
				synchronized (transformer) {
					transformer.transform(streamSource, new StreamResult(
							stringWriter));
				}
				
				return stringWriter.toString();
			} else {
				return xmlDoc.toString();
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
			return "<h2>" + e.getMessage() + "</h2>";
		}
	}

	public String transform(String xml) {
		try {
			if (transformer != null) {
				StringReader stringReader = new StringReader(xml);
				StreamSource streamSource = new StreamSource(stringReader);
				StringWriter stringWriter = new StringWriter();
				synchronized (transformer) {
					transformer.transform(streamSource, new StreamResult(
							stringWriter));
				}
				return stringWriter.toString();
			} else {
				return xml;
			}
		} catch (Exception e) {
			logger.error(e.getMessage());
			return "<h2>" + e.getMessage() + "</h2>";
		}
	}
	
	public String transform(InputStream is) {
		try {
			
			if (transformer != null) {
					
				StreamSource streamSource = new StreamSource(is);
				StringWriter stringWriter = new StringWriter();
				synchronized (transformer) {
					transformer.transform(streamSource, new StreamResult(
							stringWriter));
				}
				
				return stringWriter.toString();
			} else {
				return "transformer null";
			}
			
		} catch (Exception e) {
			logger.error(e.getMessage());
			return "<h2>" + e.getMessage() + "</h2>";
		}
	}

	public Source resolve(String href, String base) throws TransformerException {
		InputStream is = null;
		Source src = null;
		try{
			XMLStreamParser parser = new XMLStreamParser();
			is = parser.getStreamFromURL(basePath+href);
			src = new StreamSource(is);
		}catch(Exception e){
			logger.error(e.toString()+ "href="+href);
		}
		return src;
	}

}
