
/**
*Copyright (c) 2000-2002 OCLC Online Computer Library Center,
*Inc. and other contributors. All rights reserved.  The contents of this file, as updated
*from time to time by the OCLC Office of Research, are subject to OCLC Research
*Public License Version 2.0 (the "License"); you may not use this file except in
*compliance with the License. You may obtain a current copy of the License at
*http://purl.oclc.org/oclc/research/ORPL/.  Software distributed under the License is
*distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
*or implied. See the License for the specific language governing rights and limitations
*under the License.  This software consists of voluntary contributions made by many
*individuals on behalf of OCLC Research. For more information on OCLC Research,
*please see http://www.oclc.org/oclc/research/.
*
*The Original Code is JDBC2oai_dc.java.
*The Initial Developer of the Original Code is Jeff Young.
*Portions created by ______________________ are
*Copyright (C) _____ _______________________. All Rights Reserved.
*Contributor(s):______________________________________.
*/


package org.oclc.oai.server.crosswalk;

import java.util.HashMap;
import java.util.Properties;

import org.oclc.oai.server.verb.CannotDisseminateFormatException;
import org.oclc.oai.util.OAIUtil;


/**
 * Convert native "item" to oai_dc. In this case, the native "item"
 * is assumed to already be formatted as an OAI <record> element,
 * with the possible exception that multiple metadataFormats may
 * be present in the <metadata> element. The "crosswalk", merely
 * involves pulling out the one that is requested.
 */
public class JDBC2oai_dc extends Crosswalk {
    private String dcTitleLabel = null;
    private String dcCreatorLabel = null;
    private String dcSubjectLabel = null;
    private String dcDescriptionLabel = null;
    private String dcPublisherLabel = null;
    private String dcContributorLabel = null;
    private String dcDateLabel = null;
    private String dcTypeLabel = null;
    private String dcFormatLabel = null;
    private String dcIdentifierLabel = null;
    private String dcSourceLabel = null;
    private String dcLanguageLabel = null;
    private String dcRelationLabel = null;
    private String dcCoverageLabel = null;
    private String dcRightsLabel = null;
    
    /**
     * The constructor assigns the schemaLocation associated with this crosswalk. Since
     * the crosswalk is trivial in this case, no properties are utilized.
     *
     * @param properties properties that are needed to configure the crosswalk.
     */
    public JDBC2oai_dc(Properties properties) {
	super("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
	dcTitleLabel = (String)properties.get("JDBC2oai_dc.dcTitleLabel");
	dcCreatorLabel = (String)properties.get("JDBC2oai_dc.dcCreatorLabel");
	dcSubjectLabel = (String)properties.get("JDBC2oai_dc.dcSubjectLabel");
	dcDescriptionLabel = (String)properties.get("JDBC2oai_dc.dcDescriptionLabel");
	dcPublisherLabel = (String)properties.get("JDBC2oai_dc.dcPublisherLabel");
	dcContributorLabel = (String)properties.get("JDBC2oai_dc.dcContributorLabel");
	dcDateLabel = (String)properties.get("JDBC2oai_dc.dcDateLabel");
	dcTypeLabel = (String)properties.get("JDBC2oai_dc.dcTypeLabel");
	dcFormatLabel = (String)properties.get("JDBC2oai_dc.dcFormatLabel");
	dcIdentifierLabel = (String)properties.get("JDBC2oai_dc.dcIdentifierLabel");
	dcSourceLabel = (String)properties.get("JDBC2oai_dc.dcSourceLabel");
	dcLanguageLabel = (String)properties.get("JDBC2oai_dc.dcLanguageLabel");
	dcRelationLabel = (String)properties.get("JDBC2oai_dc.dcRelationLabel");
	dcCoverageLabel = (String)properties.get("JDBC2oai_dc.dcCoverageLabel");
	dcRightsLabel = (String)properties.get("JDBC2oai_dc.dcRightsLabel");
    }

    /**
     * Can this nativeItem be represented in DC format?
     * @param nativeItem a record in native format
     * @return true if DC format is possible, false otherwise.
     */
    public boolean isAvailableFor(Object nativeItem) {
	return true; // all records must support oai_dc according to the OAI spec.
    }

    /**
     * Perform the actual crosswalk.
     *
     * @param nativeItem the native "item". In this case, it is
     * already formatted as an OAI <record> element, with the
     * possible exception that multiple metadataFormats are
     * present in the <metadata> element.
     * @return a String containing the XML to be stored within the <metadata> element.
     * @exception CannotDisseminateFormatException nativeItem doesn't support this format.
     */
    public String createMetadata(Object nativeItem)
	throws CannotDisseminateFormatException {
	Object dcTitle = null;
	Object dcCreator = null;
	Object dcSubject = null;
	Object dcDescription = null;
	Object dcPublisher = null;
	Object dcContributor = null;
	Object dcDate = null;
	Object dcType = null;
	Object dcFormat = null;
	Object dcIdentifier = null;
	Object dcSource = null;
	Object dcLanguage = null;
	Object dcRelation = null;
	Object dcCoverage = null;
	Object dcRights = null;
	HashMap table = (HashMap)nativeItem;
	StringBuffer sb = new StringBuffer();
	sb.append("<oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\""
		  + getSchemaLocation()
		  + "\">");


	if (dcTitleLabel != null
	    && (dcTitle = table.get(dcTitleLabel)) != null
	    && dcTitle.toString().length() > 0) {
	    sb.append("<dc:title>");
	    sb.append(OAIUtil.xmlEncode(dcTitle.toString()));
	    sb.append("</dc:title>");
	}
	
	if (dcCreatorLabel != null
	    && (dcCreator = table.get(dcCreatorLabel)) != null
	    && dcCreator.toString().length() > 0) {
	    sb.append("<dc:creator>");
	    sb.append(OAIUtil.xmlEncode(dcCreator.toString()));
	    sb.append("</dc:creator>");
	}
	
	if (dcSubjectLabel != null
	    && (dcSubject = table.get(dcSubjectLabel)) != null
	    && dcSubject.toString().length() > 0) {
	    sb.append("<dc:subject>");
	    sb.append(OAIUtil.xmlEncode(dcSubject.toString()));
	    sb.append("</dc:subject>");
	}
	
	if (dcDescriptionLabel != null
	    && (dcDescription = table.get(dcDescriptionLabel)) != null
	    && dcDescription.toString().length() > 0) {
	    sb.append("<dc:description>");
	    sb.append(OAIUtil.xmlEncode(dcDescription.toString()));
	    sb.append("</dc:description>");
	}
	
	if (dcPublisherLabel != null
	    && (dcPublisher = table.get(dcPublisherLabel)) != null
	    && dcPublisher.toString().length() > 0) {
	    sb.append("<dc:publisher>");
	    sb.append(OAIUtil.xmlEncode(dcPublisher.toString()));
	    sb.append("</dc:publisher>");
	}
	
	if (dcContributorLabel != null
	    && (dcContributor = table.get(dcContributorLabel)) != null
	    && dcContributor.toString().length() > 0) {
	    sb.append("<dc:contributor>");
	    sb.append(OAIUtil.xmlEncode(dcContributor.toString()));
	    sb.append("</dc:contributor>");
	}
	
	if (dcDateLabel != null
	    && (dcDate = table.get(dcDateLabel)) != null
	    && dcDate.toString().length() > 0) {
	    sb.append("<dc:date>");
	    sb.append(OAIUtil.xmlEncode(dcDate.toString()));
	    sb.append("</dc:date>");
	}
	
	if (dcTypeLabel != null
	    && (dcType = table.get(dcTypeLabel)) != null
	    && dcType.toString().length() > 0) {
	    sb.append("<dc:type>");
	    sb.append(OAIUtil.xmlEncode(dcType.toString()));
	    sb.append("</dc:type>");
	}
	
	if (dcFormatLabel != null
	    && (dcFormat = table.get(dcFormatLabel)) != null
	    && dcFormat.toString().length() > 0) {
	    sb.append("<dc:format>");
	    sb.append(OAIUtil.xmlEncode(dcFormat.toString()));
	    sb.append("</dc:format>");
	}
	
	if (dcIdentifierLabel != null
	    && (dcIdentifier = table.get(dcIdentifierLabel)) != null
	    && dcIdentifier.toString().length() > 0) {
	    sb.append("<dc:identifier>");
	    sb.append(OAIUtil.xmlEncode(dcIdentifier.toString()));
	    sb.append("</dc:identifier>");
	}
	
	if (dcSourceLabel != null
	    && (dcSource = table.get(dcSourceLabel)) != null
	    && dcSource.toString().length() > 0) {
	    sb.append("<dc:source>");
	    sb.append(OAIUtil.xmlEncode(dcSource.toString()));
	    sb.append("</dc:source>");
	}
	
	if (dcLanguageLabel != null
	    && (dcLanguage = table.get(dcLanguageLabel)) != null
	    && dcLanguage.toString().length() > 0) {
	    sb.append("<dc:language>");
	    sb.append(OAIUtil.xmlEncode(dcLanguage.toString()));
	    sb.append("</dc:language>");
	}
	
	if (dcRelationLabel != null
	    && (dcRelation = table.get(dcRelationLabel)) != null
	    && dcRelation.toString().length() > 0) {
	    sb.append("<dc:relation>");
	    sb.append(OAIUtil.xmlEncode(dcRelation.toString()));
	    sb.append("</dc:relation>");
	}
	
	if (dcCoverageLabel != null
	    && (dcCoverage = table.get(dcCoverageLabel)) != null
	    && dcCoverage.toString().length() > 0) {
	    sb.append("<dc:coverage>");
	    sb.append(OAIUtil.xmlEncode(dcCoverage.toString()));
	    sb.append("</dc:coverage>");
	}
	
	if (dcRightsLabel != null
	    && (dcRights = table.get(dcRightsLabel)) != null
	    && dcRights.toString().length() > 0) {
	    sb.append("<dc:rights>");
	    sb.append(OAIUtil.xmlEncode(dcRights.toString()));
	    sb.append("</dc:rights>");
	}
	
	sb.append("</oai_dc:dc>");
	return sb.toString();
    }
}
