<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:dc="http://purl.org/dc/elements/1.1/">
	<xsl:output method="html" version="4.0" />
	<xsl:include href="common_templates.xsl"/>
	<!-- IHM DC transformations -->
	<xsl:template match="oai_dc:dc">
		<table width="100%" border="0" cellspacing="4"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>

	

	<xsl:template match="dc:identifier">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="." />
					</xsl:attribute>
					<xsl:value-of select="." />
				</a>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="dc:*">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:value-of select="." />
			</td>
		</tr>
	</xsl:template>

	 <xsl:template match="dc:source">
    <tr valign="top">
      <td><strong><xsl:value-of select="name()"/></strong></td>
      <td>
		
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
		
	  </td>
    </tr>
    </xsl:template>	

	<!-- IHM DC END -->
</xsl:stylesheet>