<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:oai_etdms="http://www.ndltd.org/standards/metadata/etdms/1.0/">
	<xsl:output method="html" version="4.0" />
	<xsl:include href="common_templates.xsl"/>
	<!-- IHM ETDMS transformations -->
	<xsl:template match="oai_etdms:thesis">
		<table width="100%" border="0" cellspacing="4"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>
	<xsl:template match="oai_etdms:*">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<xsl:if test="@resource">
				<td>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="@resource" />
						</xsl:attribute>
						<xsl:value-of select="." />
					</a>
				</td>
			</xsl:if>
			<xsl:if test="not(@resource)">
				<td>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
	 <xsl:template match="oai_etdms:source">
    <tr valign="top">
      <td><strong><xsl:value-of select="name()"/></strong></td>
      <td>
		
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
		
	  </td>
    </tr>
  </xsl:template>	
	<!-- IHM ETDMS END -->
</xsl:stylesheet>