<?xml version="1.0" encoding="UTF-8"?>
<!-- Edited with emacs -->
<!-- New Namespace -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:oai_id="http://www.openarchives.org/OAI/2.0/oai-identifier"
	xmlns:oai_branding="http://www.openarchives.org/OAI/2.0/branding/"
	xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:oai_etdms="http://www.ndltd.org/standards/metadata/etdms/1.0/"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
	xmlns:toolkit="http://oai.dlib.vt.edu/OAI/metadata/toolkit">
<!-- 	xmlns:lom="http://injac.esup.org/lomfr"  --> 
	
	<xsl:output method="html" version="4.0" />
	
	<xsl:param name="intdocs"
		select="'xml html htm txt jpg png gif XML HTML HTM TXT JPG PNG GIF'" />

	<xsl:param name="rendererURI" select="''" />
	<xsl:param name="upnode" select="'injacRoot'"/>
	<xsl:param name="context" select="'injac-oai'" />
	<xsl:param name="index" select="'5'" />
	<xsl:param name="metadataPrefix" select="''" />
	<xsl:param name="set" select="''" />
	<xsl:param name="identifier" select="''" />
	<xsl:param name="from" select="''" />
	<xsl:param name="until" select="''" />
	<xsl:template match="/oai:OAI-PMH">
		<table width="100%" border="0" cellpadding="0"
			cellspacing="20">
			<tr valign="top">
				<td id="response">
					<table width="100%" border="0" cellpadding="4"
						cellspacing="0">
						<xsl:apply-templates
							select="oai:responseDate|oai:request" />
					</table>
				</td>
			</tr>
			<tr valign="top">
				<td>
					<xsl:apply-templates
						select="oai:Identify|oai:GetRecord|oai:ListIdentifiers|oai:ListMetadataFormats|oai:ListRecords|oai:ListSets|oai:error" />
				</td>
			</tr>
			<tr valign="top">
				<td bgcolor="#F9DD50" height="10"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="oai:Identify|oai:GetRecord">
		<h2>
			<xsl:value-of select="name()" />
		</h2>
		<table width="100%" border="0" cellspacing="2"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="oai:ListMetadataFormats">
		<h2>
			<xsl:value-of select="name()" />
		</h2>
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="oai:ListSets">
		<h2>
			<xsl:value-of select="name()" />
		</h2>
		<table width="100%" border="0" cellspacing="0"
			cellpadding="4">
			<tr valign="top">
				<td width="150">
					<strong>setSpec</strong>
				</td>
				<td>
					<strong>setName</strong>
				</td>
			</tr>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="oai:ListRecords">
		<h2>
			<xsl:value-of select="name()" />
			(
			<xsl:value-of
				select="/oai:OAI-PMH/oai:request/@metadataPrefix" />
			)
		</h2>
		<xsl:apply-templates />
	</xsl:template>

	<xsl:template match="oai:ListIdentifiers">
		<h2>
			<xsl:value-of select="name()" />
		</h2>
		<table width="100%" border="0" cellspacing="2"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="oai:error">
		<h2>
			<font color="red">
				<xsl:value-of select="name()" />
			</font>
		</h2>
		<table width="100%" border="0" cellspacing="2"
			cellpadding="0">
			<tr valign="top">
				<td width="200">
					<strong>
						<xsl:value-of select="@code" />
					</strong>
				</td>
				<td>
					<xsl:value-of select="." />
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="oai:record">
		<tr valign="top">
			<td>
				<table width="100%" border="0" cellspacing="2"
					cellpadding="0">
					<xsl:apply-templates />
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:header">
		<tr valign="top">
			<td class="identifier">
				<table width="100%" border="0" cellspacing="4"
					cellpadding="0">
					<xsl:apply-templates />
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:metadata">
		<tr valign="top">
			<td>
				<xsl:apply-templates />
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:set">
		<tr valign="top">
			<xsl:apply-templates />
		</tr>
	</xsl:template>

	<xsl:template match="oai:setSpec">
		<td width="150">
			<strong>
				<a>
					<xsl:attribute name="href">/<xsl:value-of select="$context" />?index=<xsl:value-of select="$index" />&amp;verb=ListRecords&amp;metadataPrefix=oai_dc&amp;set=<xsl:value-of select="." /></xsl:attribute>
					<xsl:value-of select="." />
				</a>
			</strong>
		</td>
	</xsl:template>

	<xsl:template match="oai:setName">
		<td>
			<xsl:value-of select="." />
		</td>
	</xsl:template>

	<xsl:template match="oai:responseDate">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:value-of select="." />
			</td>
		</tr>
	</xsl:template>


	<xsl:template match="oai:request">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:value-of select="." />
				?verb=
				<xsl:value-of select="@verb" />
			</td>
		</tr>
		<xsl:if test="$metadataPrefix !=''">
			<tr valign="top">
				<td width="150">
					<div class="list">metadatPrefix :</div>
				</td>
				<td>
					<xsl:value-of select="$metadataPrefix" />
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="$set !=''">
			<tr valign="top">
				<td width="150">
					<div class="list">set</div>
				</td>
				<td>
					<xsl:value-of select="$set" />
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="$from !=''">
			<tr valign="top">
				<td width="150">
					<div class="list">from :</div>
				</td>
				<td>
					<xsl:value-of select="$from" />
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="$until !=''">
			<tr valign="top">
				<td width="150">
					<div class="list">until :</div>
				</td>
				<td>
					<xsl:value-of select="$until" />
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="$identifier !=''">
			<tr valign="top">
				<td width="150">
					<div class="list">identifier :</div>
				</td>
				<td>
					<xsl:value-of select="$identifier" />
				</td>
			</tr>
		</xsl:if>


	</xsl:template>

	<xsl:template match="oai:*">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:value-of select="." />
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:adminEmail">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<cite>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="." />
						</xsl:attribute>
						<xsl:value-of select="." />
					</a>
				</cite>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:resumptionToken">
		<xsl:if test=". != ''">
			<tr valign="top">
				<td>
					Suite de la liste:
					<a>
						<xsl:attribute name="href">/<xsl:value-of select="$context" />?index=<xsl:value-of select="$index" />&amp;verb=<xsl:value-of select="//oai:OAI-PMH/oai:request/@verb" />&amp;resumptionToken=<xsl:value-of select="." /></xsl:attribute>
						Suivant
					</a>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="oai:identifier">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">/<xsl:value-of select="$context" />?index=5&amp;verb=GetRecord&amp;metadataPrefix=<xsl:choose><xsl:when test="/oai:OAI-PMH/oai:request/@metadataPrefix"><xsl:value-of select="/oai:OAI-PMH/oai:request/@metadataPrefix" /></xsl:when><xsl:otherwise>oai_dc</xsl:otherwise></xsl:choose>&amp;identifier=<xsl:value-of select="." /></xsl:attribute>
					<xsl:value-of select="." />
				</a>
			</td>
		</tr>
	</xsl:template>

	<!--
		<xsl:template name="apply-templates-copy-all">
		<xsl:copy>
		<xsl:call-template name="apply-templates-copy-all"/>
		</xsl:copy>
		</xsl:template>
	-->

	<xsl:template match="oai:description">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:apply-templates />
			</td>
		</tr>
	</xsl:template>

	

	<xsl:template match="oai_id:oai-identifier">
		<table width="100%" border="0" cellspacing="0"
			cellpadding="0">
			<tr valign="top">
				<td>
					<strong>
						<xsl:value-of select="name()" />
						:
					</strong>
				</td>
			</tr>
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="oai_id:*">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:apply-templates />
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai_branding:branding">
		<table width="100%" border="0" cellspacing="0"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>

	<xsl:template match="oai_branding:metadataRendering">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="." />
					</xsl:attribute>
					<xsl:attribute name="type">
						<xsl:value-of select="@mimeType" />
					</xsl:attribute>
					<xsl:value-of select="@metadataNamespace" />
				</a>
			</td>
		</tr>
	</xsl:template>

	<!--
		<xsl:template match="oai_branding:metadataRendering>
		<tr valign="top">
		<td><strong><xsl:value-of select="name()"/></strong></td>
		</tr>
		</xsl:template>
	-->

	<xsl:template match="oai_branding:collectionIcon">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<!--
					<a href="/{$context}/index.html"><img src="/{$context}/oaicat_icon.gif" alt="Testing"/></a>
				-->
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="oai_branding:link" />
					</xsl:attribute>
					<img>
						<xsl:attribute name="width">
							<xsl:value-of select="oai_branding:width" />
						</xsl:attribute>
						<xsl:attribute name="height">
							<xsl:value-of select="oai_branding:height" />
						</xsl:attribute>
						<xsl:attribute name="src">
							<xsl:value-of select="oai_branding:url" />
						</xsl:attribute>
						<xsl:attribute name="alt">
							<xsl:value-of select="oai_branding:title" />
						</xsl:attribute>
					</img>
				</a>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai_branding:*">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:apply-templates />
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="oai:metadataFormat">
		<table width="100%" border="0" cellspacing="0"
			cellpadding="4">
			<tr valign="top">
				<td width="150">
					<strong>metadataPrefix</strong>
				</td>
				<td>
					<a>
						<xsl:attribute name="href">/<xsl:value-of select="$context" />?index=5&amp;verb=ListRecords&amp;metadataPrefix=<xsl:value-of select="oai:metadataPrefix" /></xsl:attribute>
						<xsl:value-of select="oai:metadataPrefix" />
					</a>
				</td>
			</tr>
			<tr valign="top">
				<td width="150">
					<strong>schema</strong>
				</td>
				<td>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="oai:schema" />
						</xsl:attribute>
						<xsl:value-of select="oai:schema" />
					</a>
				</td>
			</tr>
			<tr valign="top">
				<td width="150">
					<strong>metadataNamespace</strong>
				</td>
				<td>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of
								select="oai:metadataNamespace" />
						</xsl:attribute>
						<xsl:value-of select="oai:metadataNamespace" />
					</a>
				</td>
			</tr>
		</table>
		<hr />
	</xsl:template>

	
	<xsl:template match="toolkit:toolkit">
		<table width="100%" border="0" cellspacing="0"
			cellpadding="0">
			<tr valign="top">
				<td width="150">
					<strong>
						<xsl:value-of select="name()" />
					</strong>
				</td>
				<td>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="toolkit:URL" />
						</xsl:attribute>
						<img border="0" cellspacing="0"
							cellpadding="0">
							<xsl:attribute name="alt">
								<xsl:value-of select="toolkit:title" />
							</xsl:attribute>
							<xsl:attribute name="src">
								<xsl:value-of
									select="toolkit:toolkitIcon" />
							</xsl:attribute>
						</img>
					</a>
					(version
					<xsl:value-of select="toolkit:version" />
					)
				</td>
			</tr>
		</table>
	</xsl:template>
<!-- IHM DC transformations -->
	<xsl:template match="oai_dc:dc">
		<table width="100%" border="0" cellspacing="4"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>

	

	<xsl:template match="dc:identifier">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="." />
					</xsl:attribute>
					<xsl:value-of select="." />
				</a>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="dc:*">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:value-of select="." />
			</td>
		</tr>
	</xsl:template>

	 <xsl:template match="dc:source">
    <tr valign="top">
      <td><strong><xsl:value-of select="name()"/></strong></td>
      <td>
		
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
		
	  </td>
    </tr>
    </xsl:template>	

	<!-- IHM DC END -->
<!-- IHM ETDMS transformations -->
	<xsl:template match="oai_etdms:thesis">
		<table width="100%" border="0" cellspacing="4"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>
	<xsl:template match="oai_etdms:*">
		<tr valign="top">
			<td width="150">
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<xsl:if test="@resource">
				<td>
					<a>
						<xsl:attribute name="href">
							<xsl:value-of select="@resource" />
						</xsl:attribute>
						<xsl:value-of select="." />
					</a>
				</td>
			</xsl:if>
			<xsl:if test="not(@resource)">
				<td>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</tr>
	</xsl:template>
	 <xsl:template match="oai_etdms:source">
    <tr valign="top">
      <td><strong><xsl:value-of select="name()"/></strong></td>
      <td>
		
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
		
	  </td>
    </tr>
  </xsl:template>	
	<!-- IHM ETDMS END -->
	<!-- IHM LOM transformations -->
	<xsl:template match="lom:lom">
		<ul class="mainel">
			<xsl:apply-templates />
		</ul>
	</xsl:template>


	<xsl:template
		match="lom:general|lom:lifeCycle|lom:technical|lom:educational|lom:classification|lom:metaMetadata">
		<li >
				<strong>
					<xsl:value-of select="name()" />&#160;:&#160;
				</strong>
				<xsl:call-template name="lom-tableize-it">
						<xsl:with-param name="metanode" select="./*" />
				</xsl:call-template>
		</li>	
		
	</xsl:template>
	<!-- sous-template recursif pour elements imbriqués LOM -->
	<xsl:template name="lom-tableize-it">
		<xsl:param name="metanode" />
			<xsl:if test="count($metanode) &gt; 0">
				<ul class="subel">
				
					<xsl:for-each
						select="*[name() != 'lom:location']">
						<li>
								<strong>
									<xsl:value-of select="name()" />&#160;:&#160;
								</strong>
								<xsl:value-of select="./text()" />
						</li>
							
						
						<xsl:call-template name="lom-tableize-it">
								<xsl:with-param name="metanode" select="." />
						</xsl:call-template>
					</xsl:for-each>
					<xsl:apply-templates select="lom:location" />
				</ul>
			</xsl:if>
	</xsl:template>

	<xsl:template match="lom:location">
		
			<li>
				<strong>
					<xsl:value-of select="name()" />&#160;:&#160;
				</strong>
			
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
			</li>
		
	</xsl:template>
	<!-- LOM END -->
		<xsl:template name="makeUri">
		<xsl:param name="uri" />
		<xsl:variable name="injac-file">
			<xsl:call-template name="last-rep">
				<xsl:with-param name="last-rep-uri" select="$uri" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="injac-path"
			select="substring-before(substring-after($uri, $upnode), concat('/',$injac-file))" />
		
			<a class="file"
				href="{$uri}">
				<xsl:value-of select="$uri" />
			</a>
			<xsl:if test="$rendererURI != ''">
				<!-- Test des types de document au rendu externe -->
				<xsl:choose>
					<!-- extern rendering link-->
					<xsl:when
						test="not(contains($intdocs, substring-after($injac-file, '.')))">
						<a class="file"
							href="{$rendererURI}/ext/{$injac-path}/{$injac-file}&amp;file={$injac-file}">
							<xsl:value-of select="' (rendu inJac)'" />
						</a>
					</xsl:when>
					<xsl:otherwise>
						<a class="file"
							href="{$rendererURI}/nav{$injac-path}/{$injac-file}">
							<xsl:value-of select="' (rendu inJac)'" />
						</a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
	</xsl:template>
	
	
	<!-- sous-template recursif simulant la fonction lastOf() -->
	<xsl:template name="last-rep">
		<xsl:param name="last-rep-uri" />
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
				<xsl:call-template name="last-rep">
					<xsl:with-param name="last-rep-uri"
						select="substring-after($last-rep-uri, '/')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$last-rep-uri" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>