<?xml version="1.0" encoding="utf-8"?>
<!-- Edited with emacs -->
<!-- New Namespace -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:oai_id="http://www.openarchives.org/OAI/2.0/oai-identifier"
	xmlns:oai_branding="http://www.openarchives.org/OAI/2.0/branding/"
	xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:oai_etdms="http://www.ndltd.org/standards/metadata/etdms/1.0/"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:toolkit="http://oai.dlib.vt.edu/OAI/metadata/toolkit"
	exclude-result-prefixes="oai oai_id  oai_branding oai_dc oai_etdms dc toolkit">
	<xsl:output method="html" version="4.0" encoding="utf-8"/>
	<xsl:param name="context" select="'injac-oai'" />
	<xsl:param name="set" select="''" />
	<xsl:param name="metadataPrefix" select="''" />
	<xsl:param name="index" select="''" />
	<!-- default prefix value for set menu -->
	<xsl:param name="set-prefix" select="'oai_dc'" />
	<!-- selected verb for set menu -->
	<xsl:param name="listVerb" select="'ListIdentifiers'" />
	<xsl:template match="/oai:OAI-PMH">
		<xsl:apply-templates
			select="oai:ListMetadataFormats|oai:ListSets|oai:error" />
	</xsl:template>


	<xsl:template match="oai:ListMetadataFormats">
		<h2>Enregistrements par formats</h2>
		<ul class="idocs">
			<xsl:apply-templates />
		</ul>
	</xsl:template>

	<xsl:template match="oai:ListSets">
		<h2>Enregistrements par ensembles</h2>
		<form name="verbchoice">
			<input onchange="toggleListMode(identifiers, records)" type="radio" name="records" value="ListRecords" >Enregistrements</input>
			<input onchange="toggleListMode(records, identifiers)" type="radio" name="identifiers" value="ListIdentifiers">Entêtes</input>
		</form>	
		<script language="JavaScript">
			var verb = '<xsl:value-of select="$listVerb"/>';
			if(verb=='ListRecords')
				window.document.verbchoice.records.checked='checked';
			else
				window.document.verbchoice.identifiers.checked='checked';
				
			function toggleListMode(input, selinput){
				input.checked=false;
				verb= selinput.value;
				
				
			}
			function appendVerb(obj){
				obj = obj+"&amp;verb="+verb;
				return obj;
			}
		</script>
		
		<ul class="idocs">
			<xsl:variable name="class">
				<xsl:choose>
					<xsl:when
						test="$index = '3' and $set = ''">
						seldoc
					</xsl:when>
					<xsl:otherwise>idoc</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<li class="{$class}">
				<a onclick ="href=appendVerb(href)" title="Tous les enregistrements"
					href=".?index=3&amp;metadataPrefix={$set-prefix}">Tous</a>
			</li>

			<xsl:apply-templates />
		</ul>

	</xsl:template>

	<xsl:template match="oai:metadataFormat">
		<xsl:variable name="class">
			<xsl:choose>
				<xsl:when
					test="$index = '4' and $metadataPrefix = oai:metadataPrefix">
					seldoc
				</xsl:when>
				<xsl:otherwise>idoc</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li class="{$class}">
			<a title="{oai:metadataNamespace}"
				href=".?index=4&amp;verb=ListRecords&amp;metadataPrefix={oai:metadataPrefix}">
				<xsl:value-of select="oai:metadataPrefix" />
			</a>
		</li>
	</xsl:template>

	<xsl:template match="oai:set">
		<xsl:variable name="class">
			<xsl:choose>
				<xsl:when
					test="$index = '3' and $set = oai:setSpec">
					seldoc
				</xsl:when>
				<xsl:otherwise>idoc</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<li class="{$class}">
			<a title="{oai:setDescription}"
				href=".?index=3&amp;verb={$listVerb}&amp;metadataPrefix={$set-prefix}&amp;set={oai:setSpec}">
				<xsl:value-of select="oai:setName" />
			</a>
		</li>
	</xsl:template>


	<xsl:template match="oai:error">
		<h2>
			<font color="red">
				<xsl:value-of select="name()" />
			</font>
		</h2>
		<table width="100%" border="0" cellspacing="2"
			cellpadding="0">
			<tr valign="top">
				<td width="200">
					<strong>
						<xsl:value-of select="@code" />
					</strong>
				</td>
				<td>
					<xsl:value-of select="." />
				</td>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>