<?xml version="1.0" encoding="UTF-8"?>
<!-- Edited with emacs -->
<!-- New Namespace -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/"
	xmlns:oai_id="http://www.openarchives.org/OAI/2.0/oai-identifier"
	xmlns:oai_branding="http://www.openarchives.org/OAI/2.0/branding/"
	xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:oai_etdms="http://www.ndltd.org/standards/metadata/etdms/1.0/"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:toolkit="http://oai.dlib.vt.edu/OAI/metadata/toolkit"
	exclude-result-prefixes="oai oai_id  oai_branding oai_dc oai_etdms dc toolkit">
	<xsl:output method="html" version="4.0" />
	<xsl:param name="context" select="'injac-oai'" />
	<xsl:param name="set" select="''" />
	<xsl:param name="metadataPrefix" select="'oai_dc'" />
	<xsl:param name="identifier" select="''" />
	<xsl:param name="from" select="''" />
	<xsl:param name="until" select="''" />
	<xsl:param name="index" select="''" />
	<xsl:template match="merge">
		<table>
			<form action=".">
				<input type="hidden" name="index" value="5" />
				<xsl:apply-templates select="verbs" />
				<xsl:apply-templates select="ListSets" />
				<xsl:apply-templates select="ListMetadataFormats" />
				<xsl:apply-templates select="FromUntil" />
				<xsl:apply-templates select="Identifier" />
				<tr>
					<td>
						<input type="submit" value=" Envoyer " />
					</td>
					<td>
						<input type="reset" value=" Annuler" />
					</td>
				</tr>
			</form>
		</table>
	</xsl:template>
	<xsl:template match="FromUntil">
		<tr>
			<td>
				<div class="desc">Depuis :</div>
			</td>
			<td>
				<input type="text" name="from" value="{$from}" />
			</td>
		</tr>
		<tr>
			<td>
				<div class="desc">Jusqu'au :</div>
			</td>
			<td>
				<input type="text" name="until" value="{$until}" />
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="Identifier">
		<tr>
			<td>
				<div class="desc">Identifiant :</div>
			</td>
			<td>
				<input type="text" name="identifier" value="{$identifier}" />
			</td>
		</tr>
	</xsl:template>


	<xsl:template match="verbs">
		<tr>
			<td>
				<div class="desc">Verbe :</div>
			</td>
			<td>
				<select name="verb"
					onchange="window.location='.?index=6&amp;verb='+this.value">
					<xsl:for-each select="verb">
						<xsl:choose>
							<xsl:when test="../@value = .">
								<option selected="selected"
									value="{.}">
									<xsl:value-of select="." />
								</option>
							</xsl:when>
							<xsl:otherwise>
								<option value="{.}">
									<xsl:value-of select="." />
								</option>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="ListSets">
		<tr>
			<td>
				<div class="desc">Ensemble :</div>
			</td>
			<td>
				<select name="set">
					
					<xsl:choose>
							<xsl:when test="$set = ''">
								<option selected="selected" value=""></option>
							</xsl:when>
							<xsl:otherwise>
								<option value=""></option>
							</xsl:otherwise>
					</xsl:choose>
					<xsl:for-each select="set">
						<xsl:choose>
							<xsl:when test="$set = setSpec">
								<option selected="selected"
									value="{setSpec}">
									<xsl:value-of select="setName" />
								</option>
							</xsl:when>
							<xsl:otherwise>
								<option value="{setSpec}">
									<xsl:value-of select="setName" />
								</option>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="ListMetadataFormats">
		<tr>
			<td>
				<div class="desc">Format :</div>
			</td>
			<td>
				<select name="metadataPrefix">
					<xsl:for-each select="metadataFormat">
						<xsl:choose>
							<xsl:when test="$metadataPrefix = metadataPrefix">
								<option selected="selected" value="{metadataPrefix}">
									<xsl:value-of select="metadataPrefix" />
								</option>
							</xsl:when>
							<xsl:otherwise>
								<option value="{metadataPrefix}">
									<xsl:value-of select="metadataPrefix" />
								</option>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</select>
			</td>
		</tr>
	</xsl:template>


</xsl:stylesheet>