/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.portal.utils.injac.tools;

import java.io.IOException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.properties.AclProperty;

public class ACLManager {
    private WebdavResource webDavResource;
    private String namespace;

    public ACLManager(String serverUrl, String userLogin, String userPassword) throws HttpException, IOException {
        this(serverUrl, userLogin, userPassword, "DAV:");
    }

    public ACLManager(String serverUrl, String userLogin, String userPassword, String namespace) throws HttpException, IOException {
        HttpURL httpUrl = new HttpURL(serverUrl);
        httpUrl.setUserinfo(userLogin, userPassword);
        this.webDavResource = new WebdavResource(httpUrl);
        this.namespace = namespace;
    }

    public ACLManager(WebdavResource webDavResource) {
        this(webDavResource, "DAV:");
    }

    public ACLManager(WebdavResource webDavResource, String namespace) {
        this.webDavResource = webDavResource;
    }

    private boolean changeACL(String path, String principal, String permissionType, boolean negative) throws HttpException, IOException {
        Ace ace;
        AclProperty acl;
        if (!this.revoke(path, principal, permissionType)) {
            System.err.println("Error: Can't revoke acl!");
        }
        if ((acl = this.webDavResource.aclfindMethod(path)) == null) {
            System.err.println("Error: PropFind didn't return an AclProperty!");
            return false;
        }
        Ace[] aces = acl.getAces();
        if (aces == null) {
            aces = new Ace[]{};
        }
        Ace[] oldAces = aces;
        aces = new Ace[oldAces.length + 1];
        System.arraycopy(oldAces, 0, aces, 0, oldAces.length);
        aces[oldAces.length] = ace = new Ace(principal, negative, false, false, null);
        Privilege privilege = new Privilege(this.namespace, permissionType, null);
        ace.addPrivilege(privilege);
        boolean success = this.webDavResource.aclMethod(path, aces);
        return success;
    }

    public boolean grant(String path, String principal, String permissionType) throws HttpException, IOException {
        return this.changeACL(path, principal, permissionType, false);
    }

    public boolean deny(String path, String principal, String permissionType) throws HttpException, IOException {
        return this.changeACL(path, principal, permissionType, true);
    }

    public boolean revoke(String path, String principal, String permissionType) throws HttpException, IOException {
        AclProperty acl = this.webDavResource.aclfindMethod(path);
        Ace[] aces = null;
        if (acl == null) {
            return false;
        }
        aces = acl.getAces();
        Privilege privilege = new Privilege(this.namespace, permissionType, null);
        boolean found = false;
        int i = 0;
        while (aces != null && i < aces.length) {
            boolean removed;
            if (!aces[i].isProtected() && !aces[i].isInherited() && aces[i].getPrincipal().equals(principal) && (removed = aces[i].removePrivilege(privilege))) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            System.out.println("Privilege not found");
        }
        boolean success = false;
        if (aces != null) {
            success = this.webDavResource.aclMethod(path, aces);
        }
        return success;
    }

    public static void main(String[] args) {
        System.out.println("\n\n\n\n************* MAIN *************\n");
        try {
            String uri = "http://chene.univ-rennes1.fr:8080/slide/";
            String login = "bidon";
            String password = "xpcwd";
            ACLManager acl = new ACLManager(uri, login, password);
            acl.revoke("/slide/files/esup/storage/users/n/no/bidon", "/roles/user", "read");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

