/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1SetOf;
import com.novell.ldap.rfc2251.RfcAddRequest;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeList;
import com.novell.ldap.rfc2251.RfcAttributeTypeAndValues;
import com.novell.ldap.rfc2251.RfcAttributeValue;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import java.util.Enumeration;
import java.util.Iterator;

public class LDAPAddRequest
extends LDAPMessage {
    public LDAPAddRequest(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(8, new RfcAddRequest(new RfcLDAPDN(lDAPEntry.getDN()), LDAPAddRequest.makeRfcAttrList(lDAPEntry)), lDAPControlArray);
    }

    public LDAPEntry getEntry() {
        RfcAddRequest rfcAddRequest = (RfcAddRequest)this.getASN1Object().getRequest();
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        ASN1Object[] aSN1ObjectArray = rfcAddRequest.getAttributes().toArray();
        int n = 0;
        while (n < aSN1ObjectArray.length) {
            RfcAttributeTypeAndValues rfcAttributeTypeAndValues = (RfcAttributeTypeAndValues)aSN1ObjectArray[n];
            LDAPAttribute lDAPAttribute = new LDAPAttribute(((ASN1OctetString)rfcAttributeTypeAndValues.get(0)).stringValue());
            ASN1SetOf aSN1SetOf = (ASN1SetOf)rfcAttributeTypeAndValues.get(1);
            ASN1Object[] aSN1ObjectArray2 = aSN1SetOf.toArray();
            int n2 = 0;
            while (n2 < aSN1ObjectArray2.length) {
                lDAPAttribute.addValue(((ASN1OctetString)aSN1ObjectArray2[n2]).byteValue());
                ++n2;
            }
            lDAPAttributeSet.add(lDAPAttribute);
            ++n;
        }
        return new LDAPEntry(this.getASN1Object().getRequestDN(), lDAPAttributeSet);
    }

    private static final RfcAttributeList makeRfcAttrList(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        RfcAttributeList rfcAttributeList = new RfcAttributeList(lDAPAttributeSet.size());
        Iterator iterator = lDAPAttributeSet.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            ASN1SetOf aSN1SetOf = new ASN1SetOf(lDAPAttribute.size());
            Enumeration enumeration = lDAPAttribute.getByteValues();
            while (enumeration.hasMoreElements()) {
                aSN1SetOf.add(new RfcAttributeValue((byte[])enumeration.nextElement()));
            }
            rfcAttributeList.add(new RfcAttributeTypeAndValues(new RfcAttributeDescription(lDAPAttribute.getName()), aSN1SetOf));
        }
        return rfcAttributeList;
    }

    public String toString() {
        return this.getASN1Object().toString();
    }
}

