/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LDAPAttributeSet
extends AbstractSet
implements Cloneable,
Set,
Serializable {
    private HashMap map = new HashMap();

    public Object clone() {
        try {
            Object object = super.clone();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ((LDAPAttributeSet)object).add(((LDAPAttribute)iterator.next()).clone());
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public LDAPAttribute getAttribute(String string) {
        return (LDAPAttribute)this.map.get(string.toUpperCase());
    }

    public LDAPAttribute getAttribute(String string, String string2) {
        String string3 = string + ";" + string2;
        return (LDAPAttribute)this.map.get(string3.toUpperCase());
    }

    public LDAPAttributeSet getSubset(String string) {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            if (!lDAPAttribute.hasSubtype(string)) continue;
            lDAPAttributeSet.add(lDAPAttribute.clone());
        }
        return lDAPAttributeSet;
    }

    public Iterator iterator() {
        return this.map.values().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object object) {
        LDAPAttribute lDAPAttribute = (LDAPAttribute)object;
        return this.map.containsKey(lDAPAttribute.getName().toUpperCase());
    }

    public boolean add(Object object) {
        LDAPAttribute lDAPAttribute = (LDAPAttribute)object;
        String string = lDAPAttribute.getName().toUpperCase();
        if (this.map.containsKey(string)) {
            return false;
        }
        this.map.put(string, lDAPAttribute);
        return true;
    }

    public boolean remove(Object object) {
        String string = object instanceof String ? (String)object : ((LDAPAttribute)object).getName();
        if (string == null) {
            return false;
        }
        return this.map.remove(string.toUpperCase()) != null;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPAttributeSet: ");
        Iterator iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(" ");
            }
            bl = false;
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            stringBuffer.append(lDAPAttribute.toString());
        }
        return stringBuffer.toString();
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
    }

    private void writeAttribute(LDAPAttribute lDAPAttribute, Writer writer) throws IOException {
        this.newLine(1, writer);
        writer.write("<attr name=\"");
        writer.write(lDAPAttribute.getName());
        writer.write("\">");
        String[] stringArray = lDAPAttribute.getStringValueArray();
        byte[][] byArray = lDAPAttribute.getByteValueArray();
        int n = 0;
        while (n < stringArray.length) {
            this.newLine(2, writer);
            if (Base64.isValidUTF8(byArray[n], false)) {
                writer.write("<value>");
                writer.write(stringArray[n]);
                writer.write("</value>");
            } else {
                writer.write("<value xsi:type=\"xsd:base64Binary\">");
                writer.write(Base64.encode(byArray[n]));
                writer.write("</value>");
            }
            ++n;
        }
        this.newLine(1, writer);
        writer.write("</attr>");
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPAttributeSet>");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            this.writeAttribute((LDAPAttribute)iterator.next(), outputStreamWriter);
        }
        this.newLine(0, outputStreamWriter);
        outputStreamWriter.write("</LDAPAttributeSet>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPAttributeSet.getXMLHandler("LDAPAttributeSet", null));
        return (LDAPAttributeSet)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPAttribute.getXMLHandler("attr", this));
            }

            protected void endElement() {
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.addAll((Collection)this.valuelist);
                this.setObject(lDAPAttributeSet);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

