/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.RespControlVector;
import com.novell.ldap.rfc2251.RfcControl;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPControl
implements Cloneable,
Serializable {
    private static RespControlVector registeredControls = new RespControlVector(5, 5);
    private RfcControl control;

    public LDAPControl(String string, boolean bl, byte[] byArray) {
        if (string == null) {
            throw new IllegalArgumentException("An OID must be specified");
        }
        this.control = byArray == null ? new RfcControl(new RfcLDAPOID(string), new ASN1Boolean(bl)) : new RfcControl(new RfcLDAPOID(string), new ASN1Boolean(bl), new ASN1OctetString(byArray));
    }

    protected LDAPControl(RfcControl rfcControl) {
        this.control = rfcControl;
    }

    public Object clone() {
        LDAPControl lDAPControl;
        try {
            lDAPControl = (LDAPControl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
        byte[] byArray = this.getValue();
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                byArray2[n] = byArray[n];
                ++n;
            }
            lDAPControl.control = new RfcControl(new RfcLDAPOID(this.getID()), new ASN1Boolean(this.isCritical()), new ASN1OctetString(byArray2));
        }
        return lDAPControl;
    }

    public String getID() {
        return new String(this.control.getControlType().stringValue());
    }

    public byte[] getValue() {
        byte[] byArray = null;
        ASN1OctetString aSN1OctetString = this.control.getControlValue();
        if (aSN1OctetString != null) {
            byArray = aSN1OctetString.byteValue();
        }
        return byArray;
    }

    protected void setValue(byte[] byArray) {
        this.control.setControlValue(new ASN1OctetString(byArray));
    }

    public boolean isCritical() {
        return this.control.getCriticality().booleanValue();
    }

    public static void register(String string, Class clazz) {
        registeredControls.registerResponseControl(string, clazz);
    }

    static RespControlVector getRegisteredControls() {
        return registeredControls;
    }

    final RfcControl getASN1Object() {
        return this.control;
    }

    void newLine(int n, Writer writer) throws IOException {
        String string = "    ";
        writer.write("\n");
        int n2 = 0;
        while (n2 < n) {
            writer.write(string);
            ++n2;
        }
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        int n = 0;
        this.newLine(n, outputStreamWriter);
        outputStreamWriter.write("<control type=\"");
        outputStreamWriter.write(this.getID());
        outputStreamWriter.write("\" criticality=\"" + this.isCritical() + "\"");
        byte[] byArray = this.getValue();
        if (byArray == null) {
            outputStreamWriter.write(" / >");
        } else {
            outputStreamWriter.write(">");
            this.newLine(n + 1, outputStreamWriter);
            outputStreamWriter.write("<controlValue xsi:type=\"xsd:base64Binary\">");
            outputStreamWriter.write(Base64.encode(byArray));
            outputStreamWriter.write("</controlValue>");
            this.newLine(n, outputStreamWriter);
            outputStreamWriter.write("</control>");
        }
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPControl.getXMLHandler("control", null));
        return (LDAPControl)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String oid;
            boolean critical;
            byte[] controlvalue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("controlValue", this));
            }

            protected void endElement() {
                LDAPControl lDAPControl = new LDAPControl(this.oid, this.critical, this.controlvalue);
                this.setObject(lDAPControl);
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.controlvalue = (byte[])object;
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.oid = attributes.getValue("type");
                if (this.oid == null) {
                    throw new SAXException("type is mandatory for a Control");
                }
                this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPControl: ");
        stringBuffer.append("((oid=" + this.getID() + "");
        stringBuffer.append(",critical=" + this.isCritical() + ")");
        stringBuffer.append("(value=" + this.getValue() + "))");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

