/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    private String[] auxiliary = new String[]{""};
    private String[] required = new String[]{""};
    private String[] optional = new String[]{""};
    private String[] precluded = new String[]{""};

    public LDAPDITContentRuleSchema(String[] stringArray, String string, String string2, boolean bl, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.auxiliary = stringArray2;
        this.required = stringArray3;
        this.optional = stringArray4;
        this.precluded = stringArray5;
        super.setValue(this.formatString());
    }

    public LDAPDITContentRuleSchema(String string) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.obsolete = false;
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getAuxiliary() != null) {
                this.auxiliary = (String[])schemaParser.getAuxiliary().clone();
            }
            if (schemaParser.getRequired() != null) {
                this.required = (String[])schemaParser.getRequired().clone();
            }
            if (schemaParser.getOptional() != null) {
                this.optional = (String[])schemaParser.getOptional().clone();
            }
            if (schemaParser.getPrecluded() != null) {
                this.precluded = (String[])schemaParser.getPrecluded().clone();
            }
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {}
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliary;
    }

    public String[] getRequiredAttributes() {
        return this.required;
    }

    public String[] getOptionalAttributes() {
        return this.optional;
    }

    public String[] getPrecludedAttributes() {
        return this.precluded;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getAuxiliaryClasses()) != null) {
            stringBuffer.append(" AUX ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getRequiredAttributes()) != null) {
            stringBuffer.append(" MUST ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getOptionalAttributes()) != null) {
            stringBuffer.append(" MAY ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getPrecludedAttributes()) != null) {
            stringBuffer.append(" NOT ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (n2 > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[n2] + "'");
                    ++n2;
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

