/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPObjectClassSchema
extends LDAPSchemaElement {
    String[] superiors;
    String[] required;
    String[] optional;
    int type = -1;
    public static final int ABSTRACT = 0;
    public static final int STRUCTURAL = 1;
    public static final int AUXILIARY = 2;

    public LDAPObjectClassSchema(String[] stringArray, String string, String[] stringArray2, String string2, String[] stringArray3, String[] stringArray4, int n, boolean bl) {
        super(LDAPSchema.schemaTypeNames[1]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.type = n;
        this.obsolete = bl;
        if (stringArray2 != null) {
            this.superiors = (String[])stringArray2.clone();
        }
        if (stringArray3 != null) {
            this.required = (String[])stringArray3.clone();
        }
        if (stringArray4 != null) {
            this.optional = (String[])stringArray4.clone();
        }
        super.setValue(this.formatString());
    }

    public LDAPObjectClassSchema(String string) {
        super(LDAPSchema.schemaTypeNames[1]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            this.obsolete = schemaParser.getObsolete();
            if (schemaParser.getRequired() != null) {
                this.required = (String[])schemaParser.getRequired().clone();
            }
            if (schemaParser.getOptional() != null) {
                this.optional = (String[])schemaParser.getOptional().clone();
            }
            if (schemaParser.getSuperiors() != null) {
                this.superiors = (String[])schemaParser.getSuperiors().clone();
            }
            this.type = schemaParser.getType();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {}
    }

    public String[] getSuperiors() {
        return this.superiors;
    }

    public String[] getRequiredAttributes() {
        return this.required;
    }

    public String[] getOptionalAttributes() {
        return this.optional;
    }

    public int getType() {
        return this.type;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                    ++n;
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getSuperiors()) != null) {
            stringBuffer.append(" SUP ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if (this.getType() != -1) {
            if (this.getType() == 0) {
                stringBuffer.append(" ABSTRACT");
            } else if (this.getType() == 2) {
                stringBuffer.append(" AUXILIARY");
            } else if (this.getType() == 1) {
                stringBuffer.append(" STRUCTURAL");
            }
        }
        if ((stringArray = this.getRequiredAttributes()) != null) {
            stringBuffer.append(" MUST ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getOptionalAttributes()) != null) {
            stringBuffer.append(" MAY ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (n2 > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[n2] + "'");
                    ++n2;
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

