/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class ListReplicasResponse
extends LDAPExtendedResponse {
    private String[] replicaList;

    public ListReplicasResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        if (this.getResultCode() != 0) {
            this.replicaList = new String[0];
        } else {
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("No returned value");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
            if (aSN1Sequence == null) {
                throw new IOException("Decoding error");
            }
            int n = aSN1Sequence.size();
            this.replicaList = new String[n];
            int n2 = 0;
            while (n2 < n) {
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence.get(n2);
                if (aSN1OctetString == null) {
                    throw new IOException("Decoding error");
                }
                this.replicaList[n2] = aSN1OctetString.stringValue();
                if (this.replicaList[n2] == null) {
                    throw new IOException("Decoding error");
                }
                ++n2;
            }
        }
    }

    public String[] getReplicaList() {
        return this.replicaList;
    }
}

