/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap.controls;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1SequenceOf;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBEREncoder;
import org.ietf.ldap.LDAPControl;
import org.ietf.ldap.controls.LDAPSortKey;

public class LDAPSortControl
extends LDAPControl {
    private static int ORDERING_RULE = 0;
    private static int REVERSE_ORDER = 1;
    private static String requestOID = "1.2.840.113556.1.4.473";
    private static String responseOID = "1.2.840.113556.1.4.474";

    public LDAPSortControl(LDAPSortKey lDAPSortKey, boolean bl) {
        this(new LDAPSortKey[]{lDAPSortKey}, bl);
    }

    public LDAPSortControl(LDAPSortKey[] lDAPSortKeyArray, boolean bl) {
        super(requestOID, bl, null);
        ASN1SequenceOf aSN1SequenceOf = new ASN1SequenceOf();
        int n = 0;
        while (n < lDAPSortKeyArray.length) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.add(new ASN1OctetString(lDAPSortKeyArray[n].getKey()));
            if (lDAPSortKeyArray[n].getMatchRule() != null) {
                aSN1Sequence.add(new ASN1Tagged(new ASN1Identifier(2, false, ORDERING_RULE), new ASN1OctetString(lDAPSortKeyArray[n].getMatchRule()), false));
            }
            if (lDAPSortKeyArray[n].getReverse()) {
                aSN1Sequence.add(new ASN1Tagged(new ASN1Identifier(2, false, REVERSE_ORDER), new ASN1Boolean(true), false));
            }
            aSN1SequenceOf.add(aSN1Sequence);
            ++n;
        }
        this.setValue(aSN1SequenceOf.getEncoding(new LBEREncoder()));
    }

    static {
        try {
            LDAPControl.register(responseOID, Class.forName("org.ietf.ldap.controls.LDAPSortResponse"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

