/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelFactory;
import org.jasig.portal.ChannelRendererFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.InternalPortalException;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.channels.CError;
import org.jasig.portal.channels.CSecureInfo;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.StatsRecorder;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SetCheckInSemaphore;
import org.jasig.portal.utils.SoftHashMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tyrex.naming.MemoryContext;

public class ChannelManager
implements LayoutEventListener {
    private IUserPreferencesManager upm;
    private PortalControlStructures pcs;
    private Hashtable channelTable;
    private Hashtable rendererTable;
    private Map channelCacheTable;
    private String channelTarget;
    private Hashtable targetParams;
    private BrowserInfo binfo;
    private LocaleManager lm;
    private Context portalContext;
    private Context channelContext;
    private HashMap iccTalkers;
    private HashMap iccListeners;
    private Set pendingChannels;
    private boolean groupedRendering = false;
    private IAuthorizationPrincipal ap;
    private static final IChannelRendererFactory cChannelRendererFactory = ChannelRendererFactory.newInstance((class$org$jasig$portal$ChannelManager == null ? (class$org$jasig$portal$ChannelManager = ChannelManager.class$("org.jasig.portal.ChannelManager")) : class$org$jasig$portal$ChannelManager).getName());
    public UPFileSpec uPElement;
    public static final int SYSTEM_CHANNEL_CACHE_MIN_SIZE = 50;
    public static final SoftHashMap systemCache = new SoftHashMap(50);
    public static final String channelAddressingPathElement = "channel";
    private Set repeatRenderings = new HashSet();
    private boolean ccaching = false;
    static /* synthetic */ Class class$org$jasig$portal$ChannelManager;

    public ChannelManager() {
        this.channelTable = new Hashtable();
        this.rendererTable = new Hashtable();
        this.iccTalkers = new HashMap();
        this.iccListeners = new HashMap();
        this.channelCacheTable = Collections.synchronizedMap(new WeakHashMap());
    }

    public ChannelManager(HttpServletRequest request, HttpServletResponse response, IUserPreferencesManager manager, UPFileSpec uPElement) {
        this();
        this.upm = manager;
        this.pcs = new PortalControlStructures();
        this.pcs.setUserPreferencesManager(this.upm);
        this.pcs.setChannelManager(this);
        this.startRenderingCycle(request, response, uPElement);
    }

    public ChannelManager(IUserPreferencesManager manager) {
        this();
        this.upm = manager;
        this.pcs = new PortalControlStructures();
        this.pcs.setUserPreferencesManager(manager);
        this.pcs.setChannelManager(this);
    }

    public void setChannelInstance(String channelSubscribeId, IChannel channelInstance) {
        if (this.channelTable.get(channelSubscribeId) != null) {
            this.channelTable.remove(channelSubscribeId);
        }
        this.channelTable.put(channelSubscribeId, channelInstance);
    }

    public void commitToRenderingChannelSet() {
        if (this.groupedRendering) {
            IChannelRenderer cr;
            String channelSubscribeId;
            HashSet<String> s0 = new HashSet<String>();
            s0.add(this.channelTarget);
            this.pendingChannels.remove(this.channelTarget);
            HashSet children = this.getListeningChannels(this.channelTarget);
            if (children != null && !children.isEmpty()) {
                children.retainAll(this.pendingChannels);
                while (!children.isEmpty()) {
                    HashSet newChildren = new HashSet();
                    Iterator ci = children.iterator();
                    while (ci.hasNext()) {
                        String childId = (String)ci.next();
                        s0.add(childId);
                        this.pendingChannels.remove(childId);
                        Set currentChildren = this.getListeningChannels(childId);
                        if (currentChildren == null) continue;
                        newChildren.addAll(currentChildren);
                    }
                    newChildren.retainAll(this.pendingChannels);
                    children = newChildren;
                }
            }
            SetCheckInSemaphore s0semaphore = new SetCheckInSemaphore(new HashSet(s0));
            Iterator gi = s0.iterator();
            while (gi.hasNext()) {
                channelSubscribeId = (String)gi.next();
                cr = (IChannelRenderer)this.rendererTable.get(channelSubscribeId);
                cr.startRendering(s0semaphore, channelSubscribeId);
            }
            Iterator oi = this.pendingChannels.iterator();
            while (oi.hasNext()) {
                channelSubscribeId = (String)oi.next();
                cr = (IChannelRenderer)this.rendererTable.get(channelSubscribeId);
                cr.startRendering();
            }
        }
    }

    public void finishedRenderingCycle() {
        this.rendererTable.clear();
        this.clearRepeatedRenderings();
        this.targetParams = null;
        this.pendingChannels = new HashSet();
        this.groupedRendering = false;
    }

    public void finishedSession() {
        this.finishedRenderingCycle();
        PortalEvent ev = new PortalEvent(1);
        Enumeration enumeration = this.channelTable.elements();
        while (enumeration.hasMoreElements()) {
            IChannel ch = (IChannel)enumeration.nextElement();
            if (ch == null) continue;
            try {
                ch.receiveEvent(ev);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outputChannel(String channelSubscribeId, ContentHandler ch) {
        IChannelRenderer cr = (IChannelRenderer)this.rendererTable.get(channelSubscribeId);
        if (cr == null) {
            try {
                cr = this.startChannelRendering(channelSubscribeId);
            }
            catch (PortalException pe) {
                LogService.log(LogService.ERROR, "ChannelManager::outputChannel() : Encountered a portal exception while trying to start channel rendering! :" + pe);
            }
        }
        int renderingStatus = -1;
        try {
            renderingStatus = cr.completeRendering();
        }
        catch (Throwable t) {
            this.handleRenderingError(channelSubscribeId, ch, t, renderingStatus, "encountered problem while trying to complete rendering", "IChannelRenderer.completeRendering() threw", false);
            return;
        }
        if (renderingStatus != 0) {
            this.handleRenderingError(channelSubscribeId, ch, null, renderingStatus, "unsuccessfull rendering", "unsuccessfull rendering", false);
            return;
        }
        if (ch instanceof CachingSerializer && this.isCharacterCaching()) {
            CachingSerializer cs = (CachingSerializer)((Object)ch);
            String characterContent = cr.getCharacters();
            if (characterContent == null) {
                SAX2BufferImpl bufferedContent = cr.getBuffer();
                if (bufferedContent == null) {
                    this.handleRenderingError(channelSubscribeId, ch, null, renderingStatus, "unable to obtain channel rendering", "IChannelRenderer.getBuffer() returned null", false);
                    return;
                }
                try {
                    if (!cs.startCaching()) {
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannel() : unable to restart character cache while compiling character cache for channel \"" + channelSubscribeId + "\" !");
                    }
                    bufferedContent.outputBuffer(ch);
                    if (!cs.stopCaching()) {
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannel() : unable to reset cache state while compiling character cache for channel \"" + channelSubscribeId + "\" ! Serializer was not caching when it should've been ! Partial output possible!");
                        return;
                    }
                    try {
                        characterContent = cs.getCache();
                        if (characterContent != null) {
                            cr.setCharacterCache(characterContent);
                        }
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannel() : character caching serializer returned NULL character cache for channel \"" + channelSubscribeId + "\" !");
                    }
                    catch (UnsupportedEncodingException e) {
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannel() :unable to compile character cache for channel \"" + channelSubscribeId + "\"! Invalid encoding specified.", e);
                    }
                    catch (IOException ioe) {
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannel() :IO exception occurred while compiling character cache for channel \"" + channelSubscribeId + "\" !", ioe);
                    }
                }
                catch (IOException ioe) {
                    this.handleRenderingError(channelSubscribeId, ch, ioe, renderingStatus, "encountered a problem compiling channel character content", "Encountered IO exception while trying to output channel content SAX to the character caching serializer", true);
                    return;
                }
                catch (SAXException se) {
                    this.handleRenderingError(channelSubscribeId, ch, se, renderingStatus, "encountered a problem compiling channel character content", "Encountered SAX exception while trying to output channel content SAX to the character caching serializer", true);
                    return;
                }
            } else {
                try {
                    cs.printRawCharacters(characterContent);
                }
                catch (IOException ioe) {
                    LogService.log(LogService.DEBUG, "ChannelManager::outputChannel() : exception thrown while trying to output character cache for channelSubscribeId=\"" + channelSubscribeId + "\". Message: " + ioe.getMessage());
                }
            }
        } else {
            SAX2BufferImpl bufferedContent = cr.getBuffer();
            if (bufferedContent == null) {
                this.handleRenderingError(channelSubscribeId, ch, null, renderingStatus, "unable to obtain channel rendering", "IChannelRenderer.getBuffer() returned null", false);
                return;
            }
            try {
                ChannelSAXStreamFilter custodian = new ChannelSAXStreamFilter(ch);
                bufferedContent.outputBuffer(custodian);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, "ChannelManager::outputChannel() : encountered an exception while trying to output SAX2 content of channel \"" + channelSubscribeId + "\" to a regular serializer. Partial output possible !", e);
                return;
            }
        }
        IUserLayoutChannelDescription channelDesc = null;
        try {
            channelDesc = (IUserLayoutChannelDescription)this.upm.getUserLayoutManager().getNode(channelSubscribeId);
        }
        catch (PortalException pe) {
            // empty catch block
        }
        StatsRecorder.recordChannelRendered(this.upm.getPerson(), this.upm.getCurrentProfile(), channelDesc);
    }

    private boolean isRepeatedRenderingAttempt(String channelSubscribeId) {
        return this.repeatRenderings.contains(channelSubscribeId);
    }

    private void setRepeatedRenderingAttempt(String channelSubscribeId) {
        this.repeatRenderings.add(channelSubscribeId);
    }

    private void clearRepeatedRenderings() {
        this.repeatRenderings.clear();
    }

    private void handleRenderingError(String channelSubscribeId, ContentHandler ch, Throwable t, int renderingStatus, String commonMessage, String technicalMessage, boolean partialOutput) {
        if (this.isRepeatedRenderingAttempt(channelSubscribeId)) {
            String message = "ChannelManager::handleRenderingError() : Unable to handle a rendering error through error channel.";
            if (t != null) {
                if (t instanceof InternalPortalException) {
                    InternalPortalException ipe = (InternalPortalException)t;
                    Throwable e = ipe.getException();
                    message = message + " Error channel (channelSubscribeId=\"" + channelSubscribeId + "\") has thrown the following exception: " + e.toString() + " Partial output possible !";
                    System.out.println("CError produced the following exception. Please fix CError immediately!");
                    e.printStackTrace();
                } else {
                    message = message + " An following exception encountered while trying to render the error channel for channelSubscribeId=\"" + channelSubscribeId + "\": " + t.toString();
                    System.out.println("CError produced the following exception. Please fix CError immediately!");
                    t.printStackTrace();
                }
            } else {
                message = message + " channelRenderingStatus=";
                switch (renderingStatus) {
                    case 0: {
                        message = message + "successful";
                        break;
                    }
                    case 1: {
                        message = message + "failed";
                        break;
                    }
                    case 2: {
                        message = message + "timed out";
                        break;
                    }
                    default: {
                        message = message + "UNKNOWN CODE: " + renderingStatus;
                    }
                }
            }
            message = message + " " + technicalMessage;
            LogService.log(LogService.ERROR, message);
        } else {
            if (t != null) {
                if (t instanceof InternalPortalException) {
                    InternalPortalException ipe = (InternalPortalException)t;
                    Throwable channelException = ipe.getException();
                    this.replaceWithErrorChannel(channelSubscribeId, 1, channelException, technicalMessage, true);
                } else {
                    this.replaceWithErrorChannel(channelSubscribeId, 1, t, technicalMessage, true);
                }
            } else if (renderingStatus == 2) {
                this.replaceWithErrorChannel(channelSubscribeId, 4, t, technicalMessage, true);
            } else {
                this.replaceWithErrorChannel(channelSubscribeId, 0, t, technicalMessage, true);
            }
            this.rendererTable.remove(channelSubscribeId);
            if (!partialOutput) {
                this.setRepeatedRenderingAttempt(channelSubscribeId);
                this.outputChannel(channelSubscribeId, ch);
            }
        }
    }

    private IChannel replaceWithErrorChannel(String channelSubscribeId, int errorCode, Throwable t, String message, boolean setRuntimeData) {
        IChannel oldInstance = (IChannel)this.channelTable.get(channelSubscribeId);
        this.channelTable.remove(channelSubscribeId);
        this.rendererTable.remove(channelSubscribeId);
        CError errorChannel = new CError(errorCode, t, channelSubscribeId, oldInstance, message);
        if (setRuntimeData) {
            ChannelRuntimeData rd = new ChannelRuntimeData();
            rd.setBrowserInfo(this.binfo);
            if (this.lm != null) {
                rd.setLocales(this.lm.getLocales());
            }
            rd.setHttpRequestMethod(this.pcs.getHttpServletRequest().getMethod());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
            try {
                errorChannel.setRuntimeData(rd);
                errorChannel.setPortalControlStructures(this.pcs);
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                LogService.log(LogService.ERROR, "Encountered an exception while trying to set runtime data or portal control structures on the error channel!" + sw.toString());
            }
        }
        this.channelTable.put(channelSubscribeId, errorChannel);
        return errorChannel;
    }

    private IChannel replaceWithSecureInfoChannel(String channelSubscribeId, boolean setRuntimeData) {
        IChannel oldInstance = (IChannel)this.channelTable.get(channelSubscribeId);
        this.channelTable.remove(channelSubscribeId);
        this.rendererTable.remove(channelSubscribeId);
        CSecureInfo secureInfoChannel = new CSecureInfo(channelSubscribeId, oldInstance);
        if (setRuntimeData) {
            ChannelRuntimeData rd = new ChannelRuntimeData();
            rd.setBrowserInfo(this.binfo);
            if (this.lm != null) {
                rd.setLocales(this.lm.getLocales());
            }
            rd.setHttpRequestMethod(this.pcs.getHttpServletRequest().getMethod());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
            try {
                secureInfoChannel.setRuntimeData(rd);
                secureInfoChannel.setPortalControlStructures(this.pcs);
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                LogService.log(LogService.ERROR, "Encountered an exception while trying to set runtime data or portal control structures on the secure info channel!" + sw.toString());
            }
        }
        this.channelTable.put(channelSubscribeId, secureInfoChannel);
        return secureInfoChannel;
    }

    private static Context getChannelJndiContext(Context portalContext, String sessionId, String userId, String layoutId) throws NamingException {
        MemoryContext cic = new MemoryContext(new Hashtable());
        Context servicesContext = (Context)portalContext.lookup("services");
        Context channel_idsContext = (Context)portalContext.lookup("users/" + userId + "/layouts/" + layoutId + "/channel-ids");
        Context channel_objContext = (Context)portalContext.lookup("users/" + userId + "/sessions/" + sessionId + "/channel-obj");
        cic.bind("services", (Object)servicesContext);
        cic.bind("channel-ids", (Object)channel_idsContext);
        cic.bind("channel-obj", (Object)channel_objContext);
        return cic;
    }

    private static Context getPortalContext() throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>(5);
        environment.put("java.naming.factory.initial", "org.jasig.portal.jndi.PortalInitialContextFactory");
        InitialContext ctx = new InitialContext(environment);
        return ctx;
    }

    public IChannel instantiateChannel(String channelSubscribeId) throws PortalException {
        IUserLayoutChannelDescription channel;
        if (this.channelTable.get(channelSubscribeId) != null) {
            this.channelTable.remove(channelSubscribeId);
        }
        if ((channel = (IUserLayoutChannelDescription)this.upm.getUserLayoutManager().getNode(channelSubscribeId)) != null) {
            return this.instantiateChannel(channel);
        }
        return null;
    }

    private IChannel instantiateChannel(IUserLayoutChannelDescription cd) throws PortalException {
        IChannel ch = null;
        String channelSubscribeId = cd.getChannelSubscribeId();
        String channelPublishId = cd.getChannelPublishId();
        if (this.ap == null) {
            EntityIdentifier ei = this.pcs.getUserPreferencesManager().getPerson().getEntityIdentifier();
            this.ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        }
        if (this.ap.canRender(Integer.parseInt(channelPublishId))) {
            ch = ChannelFactory.instantiateLayoutChannel(cd, this.pcs.getHttpServletRequest().getSession(false).getId());
            StatsRecorder.recordChannelInstantiated(this.upm.getPerson(), this.upm.getCurrentProfile(), cd);
            ChannelStaticData sd = new ChannelStaticData();
            sd.setChannelSubscribeId(channelSubscribeId);
            sd.setTimeout(cd.getTimeout());
            sd.setParameters(cd.getParameterMap());
            sd.setPerson(this.upm.getPerson());
            sd.setJNDIContext(this.channelContext);
            sd.setICCRegistry(new ICCRegistry(this, channelSubscribeId));
            sd.setChannelPublishId(cd.getChannelPublishId());
            ch.setStaticData(sd);
        } else {
            ch = new CError(6, "You don't have authorization to render this channel.", channelSubscribeId, null);
        }
        this.channelTable.put(channelSubscribeId, ch);
        return ch;
    }

    public void passPortalEvent(String channelSubscribeId, PortalEvent le) {
        IChannel ch = (IChannel)this.channelTable.get(channelSubscribeId);
        if (ch != null) {
            try {
                ch.receiveEvent(le);
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
        } else {
            LogService.log(LogService.ERROR, "ChannelManager::passPortalEvent() : trying to pass an event to a channel that is not in cache. (cahnel=\"" + channelSubscribeId + "\")");
        }
    }

    private void processRequestChannelParameters(HttpServletRequest req) {
        this.channelTarget = null;
        this.targetParams = new Hashtable();
        String fname = req.getParameter("uP_fname");
        if (fname != null) {
            TransientUserLayoutManagerWrapper iulm = (TransientUserLayoutManagerWrapper)this.upm.getUserLayoutManager();
            try {
                this.channelTarget = iulm.getSubscribeId(fname);
            }
            catch (PortalException pe) {
                LogService.log(LogService.ERROR, "ChannelManager::processRequestChannelParameters(): Unable to get subscribe ID for fname=" + fname);
            }
        }
        if (this.channelTarget == null) {
            this.channelTarget = req.getParameter("uP_channelTarget");
        }
        if (this.channelTarget == null) {
            UPFileSpec upfs = new UPFileSpec(req);
            this.channelTarget = upfs.getTargetNodeId();
            LogService.log(LogService.DEBUG, "ChannelManager::processRequestChannelParameters() : channelTarget=\"" + this.channelTarget + "\".");
        }
        if (this.channelTarget != null) {
            IChannel chObj;
            IUserLayoutChannelDescription channelDesc = null;
            try {
                channelDesc = (IUserLayoutChannelDescription)this.upm.getUserLayoutManager().getNode(this.channelTarget);
            }
            catch (PortalException pe) {
                // empty catch block
            }
            StatsRecorder.recordChannelTargeted(this.upm.getPerson(), this.upm.getCurrentProfile(), channelDesc);
            Enumeration en = req.getParameterNames();
            if (en != null) {
                if (en.hasMoreElements()) {
                    this.groupedRendering = this.hasListeningChannels(this.channelTarget);
                }
                while (en.hasMoreElements()) {
                    String pName = (String)en.nextElement();
                    if (pName.equals("uP_channelTarget")) continue;
                    Object[] val = req.getParameterValues(pName);
                    if (val == null) {
                        val = ((PortalSessionManager.RequestParamWrapper)req).getObjectParameterValues(pName);
                    }
                    this.targetParams.put(pName, val);
                }
            }
            if ((chObj = (IChannel)this.channelTable.get(this.channelTarget)) == null) {
                try {
                    chObj = this.instantiateChannel(this.channelTarget);
                }
                catch (Throwable e) {
                    LogService.log(LogService.ERROR, "ChannelManager::processRequestChannelParameters() : unable to pass find/create an instance of a channel. Bogus Id ? ! (id=\"" + this.channelTarget + "\").");
                    LogService.log(LogService.ERROR, e);
                    chObj = this.replaceWithErrorChannel(this.channelTarget, 2, e, null, false);
                }
            }
            if (chObj != null && chObj instanceof IPrivileged) {
                IPrivileged isc = (IPrivileged)((Object)chObj);
                try {
                    isc.setPortalControlStructures(this.pcs);
                }
                catch (Exception e) {
                    chObj = this.replaceWithErrorChannel(this.channelTarget, 5, e, null, false);
                    isc = (IPrivileged)((Object)chObj);
                    try {
                        isc.setPortalControlStructures(this.pcs);
                    }
                    catch (Exception e2) {
                        StringWriter sw = new StringWriter();
                        e2.printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannels : Error channel threw ! " + sw.toString());
                    }
                }
                ChannelRuntimeData rd = new ChannelRuntimeData();
                rd.setParameters(this.targetParams);
                String qs = this.pcs.getHttpServletRequest().getQueryString();
                if (qs != null && qs.indexOf("=") == -1) {
                    rd.setKeywords(qs);
                }
                rd.setBrowserInfo(this.binfo);
                if (this.lm != null) {
                    rd.setLocales(this.lm.getLocales());
                }
                rd.setHttpRequestMethod(this.pcs.getHttpServletRequest().getMethod());
                UPFileSpec up = new UPFileSpec(this.uPElement);
                up.setTargetNodeId(this.channelTarget);
                rd.setUPFile(up);
                String userLayoutRoot = this.upm.getUserPreferences().getStructureStylesheetUserPreferences().getParameterValue("userLayoutRoot");
                if (userLayoutRoot != null && !userLayoutRoot.equals("root")) {
                    rd.setRenderingAsRoot(true);
                }
                try {
                    chObj.setRuntimeData(rd);
                }
                catch (Exception e) {
                    chObj = this.replaceWithErrorChannel(this.channelTarget, 3, e, null, false);
                }
            }
        }
    }

    public IChannel getChannelInstance(String channelSubscribeId) {
        IChannel ch = (IChannel)this.channelTable.get(channelSubscribeId);
        if (ch == null) {
            try {
                ch = this.instantiateChannel(channelSubscribeId);
            }
            catch (Throwable e) {
                return null;
            }
        }
        return ch;
    }

    public void removeChannel(String channelSubscribeId) {
        IChannel ch = (IChannel)this.channelTable.get(channelSubscribeId);
        if (ch != null) {
            this.channelCacheTable.remove(ch);
            try {
                ch.receiveEvent(new PortalEvent(2));
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            this.channelTable.remove(ch);
            LogService.log(LogService.DEBUG, "ChannelManager::removeChannel(): removed channel with subscribe id=" + channelSubscribeId);
        }
    }

    public void startRenderingCycle(HttpServletRequest request, HttpServletResponse response, UPFileSpec uPElement) {
        this.pcs.setHttpServletRequest(request);
        this.pcs.setHttpServletResponse(response);
        this.binfo = new BrowserInfo(request);
        this.uPElement = uPElement;
        this.rendererTable.clear();
        this.processRequestChannelParameters(request);
        if (this.portalContext == null) {
            try {
                this.portalContext = ChannelManager.getPortalContext();
            }
            catch (NamingException ne) {
                LogService.log(LogService.ERROR, "ChannelManager::setReqNRes(): exception raised when trying to obtain initial JNDI context : " + ne);
            }
        }
        if (this.channelContext == null) {
            try {
                this.channelContext = ChannelManager.getChannelJndiContext(this.portalContext, request.getSession(false).getId(), Integer.toString(this.pcs.getUserPreferencesManager().getPerson().getID()), Integer.toString(this.pcs.getUserPreferencesManager().getCurrentProfile().getLayoutId()));
            }
            catch (NamingException ne) {
                LogService.log(LogService.ERROR, "ChannelManager::setReqNRes(): exception raised when trying to obtain channel JNDI context : " + ne);
            }
        }
    }

    public boolean isCharacterCaching() {
        return this.ccaching;
    }

    public void setCharacterCaching(boolean setting) {
        this.ccaching = setting;
    }

    public void setUPElement(UPFileSpec uPElement) {
        this.uPElement = uPElement;
    }

    public void setUserPreferencesManager(IUserPreferencesManager m) {
        this.upm = m;
    }

    public IChannelRenderer startChannelRendering(String channelSubscribeId) throws PortalException {
        return this.startChannelRendering(channelSubscribeId, false);
    }

    private IChannelRenderer startChannelRendering(String channelSubscribeId, boolean noTimeout) throws PortalException {
        long timeOut = 0L;
        IUserLayoutNodeDescription node = this.upm.getUserLayoutManager().getNode(channelSubscribeId);
        if (!(node instanceof IUserLayoutChannelDescription)) {
            throw new PortalException("\"" + channelSubscribeId + "\" is not a channel node !");
        }
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)node;
        timeOut = channel.getTimeout();
        IChannel ch = (IChannel)this.channelTable.get(channelSubscribeId);
        if (!this.pcs.getHttpServletRequest().isSecure() && channel.isSecure()) {
            if (ch == null || !(ch instanceof CSecureInfo)) {
                ch = this.replaceWithSecureInfoChannel(channelSubscribeId, false);
            }
        } else if (ch == null || ch instanceof CSecureInfo) {
            try {
                ch = this.instantiateChannel(channel);
            }
            catch (Throwable e) {
                ch = this.replaceWithErrorChannel(channelSubscribeId, 2, e, null, false);
            }
        }
        ChannelRuntimeData rd = null;
        if (!channelSubscribeId.equals(this.channelTarget)) {
            if (ch instanceof IPrivileged) {
                try {
                    ((IPrivileged)((Object)ch)).setPortalControlStructures(this.pcs);
                }
                catch (Exception e) {
                    ch = this.replaceWithErrorChannel(this.channelTarget, 5, e, null, false);
                    this.channelTable.remove(ch);
                    try {
                        ((IPrivileged)((Object)ch)).setPortalControlStructures(this.pcs);
                    }
                    catch (Exception e2) {
                        StringWriter sw = new StringWriter();
                        e2.printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        LogService.log(LogService.ERROR, "ChannelManager::outputChannels : Error channel threw ! " + sw.toString());
                    }
                }
            }
            rd = new ChannelRuntimeData();
            rd.setBrowserInfo(this.binfo);
            if (this.lm != null) {
                rd.setLocales(this.lm.getLocales());
            }
            rd.setHttpRequestMethod(this.pcs.getHttpServletRequest().getMethod());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
        } else if (!(ch instanceof IPrivileged)) {
            rd = new ChannelRuntimeData();
            rd.setParameters(this.targetParams);
            String qs = this.pcs.getHttpServletRequest().getQueryString();
            if (qs != null && qs.indexOf("=") == -1) {
                rd.setKeywords(qs);
            }
            rd.setBrowserInfo(this.binfo);
            if (this.lm != null) {
                rd.setLocales(this.lm.getLocales());
            }
            rd.setHttpRequestMethod(this.pcs.getHttpServletRequest().getMethod());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
        }
        String userLayoutRoot = this.upm.getUserPreferences().getStructureStylesheetUserPreferences().getParameterValue("userLayoutRoot");
        if (rd != null && userLayoutRoot != null && !userLayoutRoot.equals("root")) {
            rd.setRenderingAsRoot(true);
        }
        IChannelRenderer cr = cChannelRendererFactory.newInstance(ch, rd);
        cr.setCharacterCacheable(this.isCharacterCaching());
        if (ch instanceof ICacheable) {
            cr.setCacheTables(this.channelCacheTable);
        }
        if (noTimeout) {
            cr.setTimeout(0L);
        } else {
            cr.setTimeout(timeOut);
        }
        if (this.groupedRendering && (this.isListeningToChannels(channelSubscribeId) || channelSubscribeId.equals(this.channelTarget))) {
            this.pendingChannels.add(channelSubscribeId);
        } else {
            cr.startRendering();
        }
        this.rendererTable.put(channelSubscribeId, cr);
        return cr;
    }

    synchronized void registerChannelDependency(String listenerChannelSubscribeId, String talkerChannelSubscribeId) {
        HashSet<String> talkers = (HashSet<String>)this.iccListeners.get(listenerChannelSubscribeId);
        if (talkers == null) {
            talkers = new HashSet<String>();
            this.iccListeners.put(listenerChannelSubscribeId, talkers);
        }
        talkers.add(talkerChannelSubscribeId);
        HashSet<String> listeners = (HashSet<String>)this.iccTalkers.get(talkerChannelSubscribeId);
        if (listeners == null) {
            listeners = new HashSet<String>();
            this.iccTalkers.put(talkerChannelSubscribeId, listeners);
        }
        listeners.add(listenerChannelSubscribeId);
    }

    private Set getListeningChannels(String talkerChannelSubscribeId) {
        return (Set)this.iccTalkers.get(talkerChannelSubscribeId);
    }

    private boolean isListeningToChannels(String listenerChannelSubscribeId) {
        return this.iccListeners.get(listenerChannelSubscribeId) != null;
    }

    private boolean hasListeningChannels(String talkerChannelSubscribeId) {
        return this.iccTalkers.get(talkerChannelSubscribeId) != null;
    }

    synchronized void removeChannelDependency(String listenerChannelSubscribeId, String talkerChannelSubscribeId) {
        Set listeners;
        Set talkers = (Set)this.iccListeners.get(listenerChannelSubscribeId);
        if (talkers != null) {
            talkers.remove(talkerChannelSubscribeId);
            if (talkers.isEmpty()) {
                this.iccListeners.remove(listenerChannelSubscribeId);
            }
        }
        if ((listeners = (Set)this.iccTalkers.get(talkerChannelSubscribeId)) != null) {
            listeners.remove(listenerChannelSubscribeId);
            if (listeners.isEmpty()) {
                this.iccTalkers.remove(talkerChannelSubscribeId);
            }
        }
    }

    public void channelAdded(LayoutEvent ev) {
    }

    public void channelUpdated(LayoutEvent ev) {
    }

    public void channelMoved(LayoutMoveEvent ev) {
    }

    public void channelDeleted(LayoutMoveEvent ev) {
        this.removeChannel(ev.getNodeDescription().getId());
    }

    public void folderAdded(LayoutEvent ev) {
    }

    public void folderUpdated(LayoutEvent ev) {
    }

    public void folderMoved(LayoutMoveEvent ev) {
    }

    public void folderDeleted(LayoutMoveEvent ev) {
    }

    public void layoutLoaded() {
    }

    public void layoutSaved() {
    }

    public void setLocaleManager(LocaleManager lm) {
        this.lm = lm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

