/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.jasig.portal.ChannelCategory;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelParameter;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.ChannelType;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.StatsRecorder;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SmartCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ChannelRegistryManager {
    protected static final IChannelRegistryStore crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
    protected static final int registryCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.channel_registry_cache_timeout");
    protected static final int chanTypesCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.channel_types_cache_timeout");
    protected static final int cpdCacheTimeout = PropertiesManager.getPropertyAsInt("org.jasig.portal.ChannelRegistryManager.cpd_cache_timeout");
    protected static final boolean localeAware = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.i18n.LocaleManager.locale_aware");
    protected static final SmartCache channelRegistryCache = new SmartCache(registryCacheTimeout);
    protected static final SmartCache channelTypesCache = new SmartCache(chanTypesCacheTimeout);
    protected static final SmartCache cpdCache = new SmartCache(cpdCacheTimeout);
    private static final String CHANNEL_REGISTRY_CACHE_KEY = "channelRegistryCacheKey";
    private static final String CHANNEL_TYPES_CACHE_KEY = "channelTypesCacheKey";
    private static final String CPD_CACHE_KEY = "cpdCacheKey";
    private static final String FRAMEWORK_OWNER = "UP_FRAMEWORK";
    private static final String SUBSCRIBER_ACTIVITY = "SUBSCRIBE";
    private static final String GRANT_PERMISSION_TYPE = "GRANT";
    static /* synthetic */ Class class$org$jasig$portal$ChannelDefinition;
    static /* synthetic */ Class class$org$jasig$portal$ChannelRegistryManager;

    public static Document getChannelRegistry() throws PortalException {
        Document channelRegistry = (Document)channelRegistryCache.get(CHANNEL_REGISTRY_CACHE_KEY);
        if (channelRegistry == null) {
            try {
                channelRegistry = ChannelRegistryManager.getChannelRegistryXML();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            if (channelRegistry != null) {
                channelRegistryCache.put(CHANNEL_REGISTRY_CACHE_KEY, channelRegistry);
                LogService.log(LogService.INFO, "Caching channel registry.");
            }
        }
        return (Document)channelRegistry.cloneNode(true);
    }

    public static Document getChannelRegistry(IPerson person) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry();
        EntityIdentifier ei = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        NodeList nl = channelRegistry.getElementsByTagName("channel");
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Element channel = (Element)nl.item(i);
            String channelPublishId = channel.getAttribute("chanID");
            String string = channelPublishId = channelPublishId.startsWith("chan") ? channelPublishId.substring(4) : channelPublishId;
            if (ap.canSubscribe(Integer.parseInt(channelPublishId))) continue;
            channel.getParentNode().removeChild(channel);
        }
        return channelRegistry;
    }

    public static Document getChannelRegistryXML() throws Exception {
        Document doc = DocumentFactory.getNewDocument();
        Element registry = doc.createElement("registry");
        doc.appendChild(registry);
        IEntityGroup channelCategoriesGroup = GroupService.getDistinguishedGroup("org.jasig.portal.ChannelDefinition");
        ChannelRegistryManager.processGroupsRecursively(channelCategoriesGroup, doc, registry);
        return doc;
    }

    private static void processGroupsRecursively(IEntityGroup group, Document owner, Element parentGroup) throws Exception {
        Date now = new Date();
        Iterator iter = group.getMembers();
        while (iter.hasNext()) {
            Date approvalDate;
            ChannelDefinition channelDef;
            IGroupMember member = (IGroupMember)iter.next();
            if (member.isGroup()) {
                IEntityGroup memberGroup = (IEntityGroup)member;
                String key = memberGroup.getKey();
                String name = memberGroup.getName();
                String description = memberGroup.getDescription();
                Element categoryE = owner.createElement("category");
                categoryE.setAttribute("ID", "cat" + key);
                categoryE.setAttribute("name", name);
                categoryE.setAttribute("description", description);
                parentGroup.appendChild(categoryE);
                ChannelRegistryManager.processGroupsRecursively(memberGroup, owner, categoryE);
                continue;
            }
            IEntity channelDefMember = (IEntity)member;
            int channelPublishId = CommonUtils.parseInt(channelDefMember.getKey());
            if (channelPublishId <= 0 || (channelDef = crs.getChannelDefinition(channelPublishId)) == null || (approvalDate = channelDef.getApprovalDate()) == null || !approvalDate.before(now)) continue;
            Element channelDefE = channelDef.getDocument(owner, "chan" + channelPublishId);
            channelDefE = (Element)owner.importNode(channelDefE, true);
            parentGroup.appendChild(channelDefE);
        }
    }

    public static Element getChannel(String channelPublishId) throws PortalException {
        Document channelRegistry = ChannelRegistryManager.getChannelRegistry();
        Element channelE = null;
        try {
            channelE = (Element)XPathAPI.selectSingleNode((Node)channelRegistry, (String)("(//channel[@ID = '" + channelPublishId + "'])[1]"));
        }
        catch (TransformerException te) {
            throw new GeneralRenderingException("Not able to find channel " + channelPublishId + " within channel registry: " + te.getMessageAndLocation());
        }
        return channelE;
    }

    public static Element getChannelXML(String subscribeId, ChannelDefinition channelDef) {
        Document doc = DocumentFactory.getNewDocument();
        Element channelE = doc.createElement("channel");
        channelE.setAttribute("ID", subscribeId);
        channelE.setAttribute("chanID", String.valueOf(channelDef.getId()));
        channelE.setAttribute("timeout", String.valueOf(channelDef.getTimeout()));
        if (localeAware) {
            String locale = channelDef.getLocale();
            channelE.setAttribute("name", channelDef.getName(locale));
            channelE.setAttribute("title", channelDef.getTitle(locale));
            channelE.setAttribute("locale", locale);
            LogService.log(LogService.DEBUG, "ChannelRegistryManager::getChannelXML: locale=" + locale);
        } else {
            channelE.setAttribute("name", channelDef.getName());
            channelE.setAttribute("title", channelDef.getTitle());
        }
        channelE.setAttribute("fname", channelDef.getFName());
        channelE.setAttribute("class", channelDef.getJavaClass());
        channelE.setAttribute("typeID", String.valueOf(channelDef.getTypeId()));
        channelE.setAttribute("editable", channelDef.isEditable() ? "true" : "false");
        channelE.setAttribute("hasHelp", channelDef.hasHelp() ? "true" : "false");
        channelE.setAttribute("hasAbout", channelDef.hasAbout() ? "true" : "false");
        channelE.setAttribute("secure", channelDef.isSecure() ? "true" : "false");
        ChannelParameter[] parameters = channelDef.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            ChannelParameter cp = parameters[i];
            Element parameterE = doc.createElement("parameter");
            parameterE.setAttribute("name", cp.getName());
            parameterE.setAttribute("value", cp.getValue());
            if (cp.getOverride()) {
                parameterE.setAttribute("override", "yes");
            }
            channelE.appendChild(parameterE);
        }
        return channelE;
    }

    public static void setChannelXML(Element channelE, ChannelDefinition channelDef) {
        String secure;
        channelDef.setFName(channelE.getAttribute("fname"));
        channelDef.setName(channelE.getAttribute("name"));
        channelDef.setDescription(channelE.getAttribute("description"));
        channelDef.setTitle(channelE.getAttribute("title"));
        channelDef.setJavaClass(channelE.getAttribute("class"));
        String timeout = channelE.getAttribute("timeout");
        if (timeout != null && timeout.trim().length() != 0) {
            channelDef.setTimeout(Integer.parseInt(timeout));
        }
        channelDef.setIsSecure((secure = channelE.getAttribute("secure")) != null && secure.equals("true"));
        channelDef.setTypeId(Integer.parseInt(channelE.getAttribute("typeID")));
        String chanEditable = channelE.getAttribute("editable");
        String chanHasHelp = channelE.getAttribute("hasHelp");
        String chanHasAbout = channelE.getAttribute("hasAbout");
        channelDef.setEditable(chanEditable != null && chanEditable.equals("true"));
        channelDef.setHasHelp(chanHasHelp != null && chanHasHelp.equals("true"));
        channelDef.setHasAbout(chanHasAbout != null && chanHasAbout.equals("true"));
        if (localeAware) {
            channelDef.setLocale(channelE.getAttribute("locale"));
        }
        channelDef.clearParameters();
        NodeList channelChildren = channelE.getChildNodes();
        if (channelChildren != null) {
            for (int i = 0; i < channelChildren.getLength(); ++i) {
                if (!channelChildren.item(i).getNodeName().equals("parameter")) continue;
                Element parameterE = (Element)channelChildren.item(i);
                NamedNodeMap parameterAtts = parameterE.getAttributes();
                String paramName = null;
                String paramValue = null;
                String paramOverride = "NULL";
                for (int j = 0; j < parameterAtts.getLength(); ++j) {
                    Node parameterAtt = parameterAtts.item(j);
                    String parameterAttName = parameterAtt.getNodeName();
                    String parameterAttValue = parameterAtt.getNodeValue();
                    if (parameterAttName.equals("name")) {
                        paramName = parameterAttValue;
                        continue;
                    }
                    if (parameterAttName.equals("value")) {
                        paramValue = parameterAttValue;
                        continue;
                    }
                    if (!parameterAttName.equals("override") || !parameterAttValue.equals("yes")) continue;
                    paramOverride = "Y";
                }
                if (paramName == null && paramValue == null) {
                    throw new RuntimeException("Invalid parameter node");
                }
                channelDef.addParameter(paramName, paramValue, paramOverride);
            }
        }
    }

    public static Document getChannelTypesXML() throws Exception {
        Document doc = DocumentFactory.getNewDocument();
        Element channelTypesE = doc.createElement("channelTypes");
        ChannelType[] channelTypes = crs.getChannelTypes();
        for (int i = 0; i < channelTypes.length; ++i) {
            int channelTypeId = channelTypes[i].getId();
            String javaClass = channelTypes[i].getJavaClass();
            String name = channelTypes[i].getName();
            String descr = channelTypes[i].getDescription();
            String cpdUri = channelTypes[i].getCpdUri();
            Element channelTypeE = doc.createElement("channelType");
            channelTypeE.setAttribute("ID", String.valueOf(channelTypeId));
            Element classE = doc.createElement("class");
            classE.appendChild(doc.createTextNode(javaClass));
            channelTypeE.appendChild(classE);
            Element nameE = doc.createElement("name");
            nameE.appendChild(doc.createTextNode(name));
            channelTypeE.appendChild(nameE);
            Element descriptionE = doc.createElement("description");
            descriptionE.appendChild(doc.createTextNode(descr));
            channelTypeE.appendChild(descriptionE);
            Element cpdUriE = doc.createElement("cpd-uri");
            cpdUriE.appendChild(doc.createTextNode(cpdUri));
            channelTypeE.appendChild(cpdUriE);
            channelTypesE.appendChild(channelTypeE);
        }
        doc.appendChild(channelTypesE);
        return doc;
    }

    public static NodeList getCategories(String channelPublishId) throws PortalException {
        Document channelRegistry = (Document)channelRegistryCache.get(CHANNEL_REGISTRY_CACHE_KEY);
        NodeList categories = null;
        try {
            categories = XPathAPI.selectNodeList((Node)channelRegistry, (String)("//category[channel/@ID = '" + channelPublishId + "']"));
        }
        catch (TransformerException te) {
            throw new GeneralRenderingException("Not able to find channel " + channelPublishId + " within channel registry: " + te.getMessageAndLocation());
        }
        return categories;
    }

    public static void publishChannel(Element channel, String[] categoryIDs, IGroupMember[] groupMembers, IPerson publisher) throws Exception {
        channelRegistryCache.remove(CHANNEL_REGISTRY_CACHE_KEY);
        ChannelDefinition channelDef = null;
        boolean newChannel = true;
        int ID2 = 0;
        String channelPublishId = channel.getAttribute("ID");
        if (channelPublishId != null && channelPublishId.trim().length() > 0) {
            newChannel = false;
            ID2 = Integer.parseInt(channelPublishId.startsWith("chan") ? channelPublishId.substring(4) : channelPublishId);
            channelDef = crs.getChannelDefinition(ID2);
            LogService.log(LogService.DEBUG, "Attempting to modify channel " + ID2 + "...");
        } else {
            channelDef = crs.newChannelDefinition();
            ID2 = channelDef.getId();
            LogService.log(LogService.DEBUG, "Attempting to publish new channel " + ID2 + "...");
        }
        ChannelRegistryManager.setChannelXML(channel, channelDef);
        Date now = new Date();
        channelDef.setPublisherId(publisher.getID());
        channelDef.setPublishDate(now);
        channelDef.setApproverId(publisher.getID());
        channelDef.setApprovalDate(now);
        crs.saveChannelDefinition(channelDef);
        String channelDefEntityKey = String.valueOf(channelDef.getId());
        IEntity channelDefEntity = GroupService.getEntity(channelDefEntityKey, class$org$jasig$portal$ChannelDefinition == null ? (class$org$jasig$portal$ChannelDefinition = ChannelRegistryManager.class$("org.jasig.portal.ChannelDefinition")) : class$org$jasig$portal$ChannelDefinition);
        IEntityGroup topLevelCategory = GroupService.getDistinguishedGroup("org.jasig.portal.ChannelDefinition");
        Iterator iter = topLevelCategory.getAllMembers();
        while (iter.hasNext()) {
            IGroupMember groupMember = (IGroupMember)iter.next();
            if (!groupMember.isGroup()) continue;
            IEntityGroup group = (IEntityGroup)groupMember;
            group.removeMember(channelDefEntity);
            group.updateMembers();
        }
        for (int i = 0; i < categoryIDs.length; ++i) {
            categoryIDs[i] = categoryIDs[i].startsWith("cat") ? categoryIDs[i].substring(3) : categoryIDs[i];
            String iCatID = categoryIDs[i];
            ChannelCategory category = crs.getChannelCategory(iCatID);
            crs.addChannelToCategory(channelDef, category);
        }
        AuthorizationService authService = AuthorizationService.instance();
        String target = "CHAN_ID." + ID2;
        IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager(FRAMEWORK_OWNER);
        IPermission[] permissions = new IPermission[groupMembers.length];
        for (int i = 0; i < groupMembers.length; ++i) {
            IAuthorizationPrincipal authPrincipal = authService.newPrincipal(groupMembers[i]);
            permissions[i] = upm.newPermission(authPrincipal);
            permissions[i].setType(GRANT_PERMISSION_TYPE);
            permissions[i].setActivity(SUBSCRIBER_ACTIVITY);
            permissions[i].setTarget(target);
        }
        if (!newChannel) {
            IPermission[] oldPermissions = upm.getPermissions(SUBSCRIBER_ACTIVITY, target);
            upm.removePermissions(oldPermissions);
        }
        upm.addPermissions(permissions);
        LogService.log(LogService.INFO, "Channel " + ID2 + " has been " + (newChannel ? "published" : "modified") + ".");
        if (newChannel) {
            StatsRecorder.recordChannelDefinitionPublished(publisher, channelDef);
        } else {
            StatsRecorder.recordChannelDefinitionModified(publisher, channelDef);
        }
    }

    public static void removeChannel(String channelID, IPerson person) throws Exception {
        channelRegistryCache.remove(CHANNEL_REGISTRY_CACHE_KEY);
        String sChannelPublishId = channelID.startsWith("chan") ? channelID.substring(4) : channelID;
        int channelPublishId = Integer.parseInt(sChannelPublishId);
        ChannelDefinition channelDef = crs.getChannelDefinition(channelPublishId);
        crs.disapproveChannelDefinition(channelDef);
        StatsRecorder.recordChannelDefinitionRemoved(person, channelDef);
    }

    public static Document getChannelTypes() throws PortalException {
        Document channelTypes = (Document)channelTypesCache.get(CHANNEL_TYPES_CACHE_KEY);
        if (channelTypes == null) {
            try {
                channelTypes = ChannelRegistryManager.getChannelTypesXML();
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
            if (channelTypes != null) {
                channelTypesCache.put(CHANNEL_TYPES_CACHE_KEY, channelTypes);
                LogService.log(LogService.INFO, "Caching channel types.");
            }
        }
        return (Document)channelTypes.cloneNode(true);
    }

    public static Document getCPD(String chanTypeID) throws PortalException {
        if (chanTypeID == null || chanTypeID.equals("-1")) {
            return null;
        }
        Document cpd = (Document)cpdCache.get(CPD_CACHE_KEY + chanTypeID);
        if (cpd == null) {
            Element channelTypes = ChannelRegistryManager.getChannelTypes().getDocumentElement();
            Node chanType = null;
            for (Node n = channelTypes.getFirstChild(); !(n == null || n.getNodeType() == 1 && n.getNodeName().equals("channelType") && chanTypeID.equals((chanType = (Element)n).getAttribute("ID"))); n = n.getNextSibling()) {
            }
            String cpdUri = null;
            for (Node n = chanType.getLastChild(); n != null; n = n.getPreviousSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("cpd-uri")) continue;
                for (Node m = n.getFirstChild(); m != null; m = m.getNextSibling()) {
                    if (!(m instanceof Text)) continue;
                    cpdUri = m.getNodeValue();
                }
                break;
            }
            if (cpdUri != null) {
                try {
                    cpd = ResourceLoader.getResourceAsDocument(class$org$jasig$portal$ChannelRegistryManager == null ? (class$org$jasig$portal$ChannelRegistryManager = ChannelRegistryManager.class$("org.jasig.portal.ChannelRegistryManager")) : class$org$jasig$portal$ChannelRegistryManager, cpdUri);
                }
                catch (IOException ioe) {
                    throw new ResourceMissingException(cpdUri, "Channel publishing document", ioe.getMessage());
                }
                catch (SAXException se) {
                    throw new PortalException("Unable to parse CPD file: " + cpdUri, (Exception)se);
                }
                catch (ParserConfigurationException pce) {
                    throw new PortalException("Unable to parse CPD file: " + cpdUri, (Exception)pce);
                }
            }
            if (cpd != null) {
                cpdCache.put(CPD_CACHE_KEY + chanTypeID, cpd);
                LogService.log(LogService.INFO, "Caching CPD for channel type " + chanTypeID);
            }
        }
        return (Document)cpd.cloneNode(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

