/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.jasig.portal.ChannelCacheEntry;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.ICharacterChannel;
import org.jasig.portal.InternalPortalException;
import org.jasig.portal.PortalException;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SetCheckInSemaphore;
import org.jasig.portal.utils.SoftHashMap;
import org.jasig.portal.utils.threading.ThreadPool;
import org.jasig.portal.utils.threading.WorkTracker;
import org.jasig.portal.utils.threading.WorkerTask;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ChannelRenderer
implements IChannelRenderer {
    public static final boolean CACHE_CHANNELS = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.ChannelRenderer.cache_channels");
    public static final int RENDERING_SUCCESSFUL = 0;
    public static final int RENDERING_FAILED = 1;
    public static final int RENDERING_TIMED_OUT = 2;
    public static final String[] renderingStatus = new String[]{"successful", "failed", "timed out"};
    protected IChannel channel;
    protected ChannelRuntimeData rd;
    protected Map channelCache;
    protected Map cacheTables;
    protected boolean rendering;
    protected boolean donerendering;
    protected Thread workerThread;
    protected WorkTracker workTracker;
    protected Worker worker;
    protected long startTime;
    protected long timeOut = Long.MAX_VALUE;
    protected boolean ccacheable;
    protected static ThreadPool tp = null;
    protected static Map systemCache = null;
    protected SetCheckInSemaphore groupSemaphore;
    protected Object groupRenderingKey;
    private Object cacheWriteLock;

    public ChannelRenderer(IChannel chan, ChannelRuntimeData runtimeData, ThreadPool threadPool) {
        this.channel = chan;
        this.rd = runtimeData;
        this.rendering = false;
        this.ccacheable = false;
        this.cacheWriteLock = new Object();
        tp = threadPool;
        if (systemCache == null) {
            systemCache = ChannelManager.systemCache;
        }
        this.groupSemaphore = null;
        this.groupRenderingKey = null;
    }

    public ChannelRenderer(IChannel chan, ChannelRuntimeData runtimeData, ThreadPool threadPool, SetCheckInSemaphore groupSemaphore, Object groupRenderingKey) {
        this(chan, runtimeData, threadPool);
        this.groupSemaphore = groupSemaphore;
        this.groupRenderingKey = groupRenderingKey;
    }

    public void setChannel(IChannel channel) {
        LogService.log(LogService.DEBUG, "ChannelRenderer::setChannel() : channel is being reset!");
        this.channel = channel;
        if (this.worker != null) {
            this.worker.setChannel(channel);
        }
        this.channelCache = null;
        this.cacheWriteLock = new Object();
    }

    Map getChannelCache() {
        if (this.channelCache == null && (this.channelCache = (SoftHashMap)this.cacheTables.get(this.channel)) == null) {
            this.channelCache = new SoftHashMap(1);
            this.cacheTables.put(this.channel, this.channelCache);
        }
        return this.channelCache;
    }

    public void setTimeout(long value) {
        this.timeOut = value;
    }

    public void setCacheTables(Map cacheTables) {
        this.cacheTables = cacheTables;
    }

    public void setCharacterCacheable(boolean setting) {
        this.ccacheable = setting;
    }

    public void startRendering() {
        this.worker = new Worker(this.channel, this.rd);
        this.workTracker = tp.execute(this.worker);
        this.rendering = true;
        this.startTime = System.currentTimeMillis();
    }

    public void startRendering(SetCheckInSemaphore groupSemaphore, Object groupRenderingKey) {
        this.groupSemaphore = groupSemaphore;
        this.groupRenderingKey = groupRenderingKey;
        this.startRendering();
    }

    public void cancelRendering() {
        if (null != this.worker) {
            this.worker.kill();
        }
    }

    public int outputRendering(ContentHandler out) throws Throwable {
        int renderingStatus = this.completeRendering();
        if (renderingStatus == 0) {
            SAX2BufferImpl buffer = this.worker.getBuffer();
            if (buffer != null) {
                try {
                    buffer.setAllHandlers(out);
                    buffer.outputBuffer();
                    return 0;
                }
                catch (SAXException e) {
                    LogService.log(LogService.ERROR, "ChannelRenderer::outputRendering() : following SAX exception occured : " + e);
                    throw e;
                }
            }
            LogService.log(LogService.ERROR, "ChannelRenderer::outputRendering() : output buffer is null even though rendering was a success?! trying to rendering for ccaching ?");
            throw new PortalException("unable to obtain rendering buffer");
        }
        return renderingStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int completeRendering() throws Throwable {
        long wait;
        if (!this.rendering) {
            this.startRendering();
        }
        boolean abandoned = false;
        long timeOutTarget = this.startTime + this.timeOut;
        if (this.groupSemaphore != null) {
            while (!this.worker.isSetRuntimeDataComplete() && System.currentTimeMillis() < timeOutTarget && !this.workTracker.isJobComplete()) {
                wait = timeOutTarget - System.currentTimeMillis();
                if (wait <= 0L) {
                    wait = 1L;
                }
                try {
                    SetCheckInSemaphore setCheckInSemaphore = this.groupSemaphore;
                    synchronized (setCheckInSemaphore) {
                        this.groupSemaphore.wait(wait);
                    }
                }
                catch (InterruptedException ie) {
                }
            }
            if (!this.worker.isSetRuntimeDataComplete() && !this.workTracker.isJobComplete()) {
                this.workTracker.killJob();
                abandoned = true;
                LogService.log(LogService.DEBUG, "ChannelRenderer::outputRendering() : killed. (key=" + this.groupRenderingKey.toString() + ")");
            } else {
                this.groupSemaphore.waitOn();
            }
            timeOutTarget = System.currentTimeMillis() + this.timeOut;
        }
        if (!abandoned) {
            while (System.currentTimeMillis() < timeOutTarget && !this.workTracker.isJobComplete()) {
                wait = timeOutTarget - System.currentTimeMillis();
                if (wait <= 0L) {
                    wait = 1L;
                }
                try {
                    WorkTracker ie = this.workTracker;
                    synchronized (ie) {
                        this.workTracker.wait(wait);
                    }
                }
                catch (InterruptedException ie) {
                }
            }
            if (!this.workTracker.isJobComplete()) {
                this.workTracker.killJob();
                abandoned = true;
                LogService.log(LogService.DEBUG, "ChannelRenderer::outputRendering() : killed.");
            } else {
                boolean bl = abandoned = !this.workTracker.isJobSuccessful();
            }
        }
        if (!abandoned && this.worker.done()) {
            if (this.worker.successful() && (this.worker.getBuffer() != null || this.ccacheable && this.worker.cbuffer != null)) {
                return 0;
            }
            Throwable e = this.worker.getThrowable();
            if (e != null) {
                throw new InternalPortalException(e);
            }
            return 1;
        }
        Exception e = this.workTracker.getException();
        if (e != null) {
            throw new InternalPortalException(e);
        }
        return 2;
    }

    public SAX2BufferImpl getBuffer() {
        if (this.worker != null) {
            return this.worker.getBuffer();
        }
        return null;
    }

    public String getCharacters() {
        if (this.worker != null) {
            return this.worker.getCharacters();
        }
        LogService.log(LogService.DEBUG, "ChannelRenderer::getCharacters() : worker is null already !");
        return null;
    }

    public void setCharacterCache(String chars) {
        if (this.worker != null) {
            this.worker.setCharacterCache(chars);
        }
    }

    protected void finalize() throws Throwable {
        if (this.workTracker != null && !this.workTracker.isJobComplete()) {
            this.workTracker.killJob();
        }
        super.finalize();
    }

    protected class Worker
    extends WorkerTask {
        private boolean successful;
        private boolean done;
        private boolean setRuntimeDataComplete;
        private boolean decremented;
        private IChannel channel;
        private ChannelRuntimeData rd;
        private SAX2BufferImpl buffer;
        private String cbuffer;
        private Throwable exc = null;

        public Worker(IChannel ch, ChannelRuntimeData runtimeData) {
            this.channel = ch;
            this.rd = runtimeData;
            this.successful = false;
            this.done = false;
            this.setRuntimeDataComplete = false;
            this.buffer = null;
            this.cbuffer = null;
        }

        public void setChannel(IChannel ch) {
            this.channel = ch;
        }

        public boolean isSetRuntimeDataComplete() {
            return this.setRuntimeDataComplete;
        }

        public void run() {
            try {
                if (this.rd != null) {
                    this.channel.setRuntimeData(this.rd);
                }
                this.setRuntimeDataComplete = true;
                if (ChannelRenderer.this.groupSemaphore != null) {
                    ChannelRenderer.this.groupSemaphore.checkInAndWaitOn(ChannelRenderer.this.groupRenderingKey);
                }
                if (CACHE_CHANNELS) {
                    if (this.channel instanceof ICacheable) {
                        ChannelCacheKey key = ((ICacheable)((Object)this.channel)).generateKey();
                        if (key != null) {
                            ChannelCacheEntry entry;
                            if (key.getKeyScope() == 1) {
                                entry = (ChannelCacheEntry)systemCache.get(key.getKey());
                                if (entry != null) {
                                    if (((ICacheable)((Object)this.channel)).isCacheValid(entry.validity) && entry.buffer != null) {
                                        if (ChannelRenderer.this.ccacheable && entry.buffer instanceof String) {
                                            this.cbuffer = (String)entry.buffer;
                                            LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : retrieved system-wide cached character content based on a key \"" + key.getKey() + "\"");
                                        } else if (entry.buffer instanceof SAX2BufferImpl) {
                                            this.buffer = (SAX2BufferImpl)entry.buffer;
                                            LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : retrieved system-wide cached content based on a key \"" + key.getKey() + "\"");
                                        }
                                    } else {
                                        systemCache.remove(key.getKey());
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : removed system-wide unvalidated cache based on a key \"" + key.getKey() + "\"");
                                    }
                                }
                            } else {
                                entry = (ChannelCacheEntry)ChannelRenderer.this.getChannelCache().get(key.getKey());
                                if (entry != null) {
                                    if (((ICacheable)((Object)this.channel)).isCacheValid(entry.validity) && entry.buffer != null) {
                                        if (ChannelRenderer.this.ccacheable && entry.buffer instanceof String) {
                                            this.cbuffer = (String)entry.buffer;
                                            LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : retrieved instance-cached character content based on a key \"" + key.getKey() + "\"");
                                        } else if (entry.buffer instanceof SAX2BufferImpl) {
                                            this.buffer = (SAX2BufferImpl)entry.buffer;
                                            LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : retrieved instance-cached content based on a key \"" + key.getKey() + "\"");
                                        }
                                    } else {
                                        ChannelRenderer.this.getChannelCache().remove(key.getKey());
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : removed unvalidated instance-cache based on a key \"" + key.getKey() + "\"");
                                    }
                                }
                            }
                        }
                        if (ChannelRenderer.this.ccacheable && this.cbuffer == null && this.buffer == null || !ChannelRenderer.this.ccacheable && this.buffer == null) {
                            if (ChannelRenderer.this.ccacheable && this.channel instanceof ICharacterChannel) {
                                StringWriter sw = new StringWriter(100);
                                PrintWriter pw = new PrintWriter(sw);
                                ((ICharacterChannel)this.channel).renderCharacters(pw);
                                pw.flush();
                                this.cbuffer = sw.toString();
                                if (key != null) {
                                    if (key.getKeyScope() == 1) {
                                        systemCache.put(key.getKey(), new ChannelCacheEntry(this.cbuffer, key.getKeyValidity()));
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : recorded system character cache based on a key \"" + key.getKey() + "\"");
                                    } else {
                                        ChannelRenderer.this.getChannelCache().put(key.getKey(), new ChannelCacheEntry(this.cbuffer, key.getKeyValidity()));
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : recorded instance character cache based on a key \"" + key.getKey() + "\"");
                                    }
                                }
                            } else {
                                this.buffer = new SAX2BufferImpl();
                                this.buffer.startBuffering();
                                this.channel.renderXML(this.buffer);
                                if (key != null) {
                                    if (key.getKeyScope() == 1) {
                                        systemCache.put(key.getKey(), new ChannelCacheEntry(this.buffer, key.getKeyValidity()));
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : recorded system cache based on a key \"" + key.getKey() + "\"");
                                    } else {
                                        ChannelRenderer.this.getChannelCache().put(key.getKey(), new ChannelCacheEntry(this.buffer, key.getKeyValidity()));
                                        LogService.log(LogService.DEBUG, "ChannelRenderer.Worker::run() : recorded instance cache based on a key \"" + key.getKey() + "\"");
                                    }
                                }
                            }
                        }
                    } else if (ChannelRenderer.this.ccacheable && this.channel instanceof ICharacterChannel) {
                        StringWriter sw = new StringWriter(100);
                        PrintWriter pw = new PrintWriter(sw);
                        ((ICharacterChannel)this.channel).renderCharacters(pw);
                        pw.flush();
                        this.cbuffer = sw.toString();
                    } else {
                        this.buffer = new SAX2BufferImpl();
                        this.buffer.startBuffering();
                        this.channel.renderXML(this.buffer);
                    }
                } else {
                    this.buffer = new SAX2BufferImpl();
                    this.buffer.startBuffering();
                    this.channel.renderXML(this.buffer);
                }
                this.successful = true;
            }
            catch (Exception e) {
                if (ChannelRenderer.this.groupSemaphore != null) {
                    ChannelRenderer.this.groupSemaphore.checkIn(ChannelRenderer.this.groupRenderingKey);
                }
                this.setException(e);
            }
            this.done = true;
        }

        public boolean successful() {
            return this.successful;
        }

        public SAX2BufferImpl getBuffer() {
            return this.buffer;
        }

        public String getCharacters() {
            if (ChannelRenderer.this.ccacheable) {
                return this.cbuffer;
            }
            LogService.log(LogService.ERROR, "ChannelRenderer.Worker::getCharacters() : attempting to obtain character data while character caching is not enabled !");
            return null;
        }

        public void setCharacterCache(String chars) {
            this.cbuffer = chars;
            if (CACHE_CHANNELS && this.channel instanceof ICacheable) {
                ChannelCacheKey key = ((ICacheable)((Object)this.channel)).generateKey();
                if (key != null) {
                    LogService.log(LogService.DEBUG, "ChannelRenderer::setCharacterCache() : called on a key \"" + key.getKey() + "\"");
                    ChannelCacheEntry entry = null;
                    if (key.getKeyScope() == 1) {
                        entry = (ChannelCacheEntry)systemCache.get(key.getKey());
                        if (entry == null) {
                            LogService.log(LogService.DEBUG, "ChannelRenderer::setCharacterCache() : setting character cache buffer based on a system key \"" + key.getKey() + "\"");
                            entry = new ChannelCacheEntry(chars, key.getKeyValidity());
                        } else {
                            entry.buffer = chars;
                        }
                        systemCache.put(key.getKey(), entry);
                    } else {
                        entry = (ChannelCacheEntry)ChannelRenderer.this.getChannelCache().get(key.getKey());
                        if (entry == null) {
                            LogService.log(LogService.DEBUG, "ChannelRenderer::setCharacterCache() : no existing cache on a key \"" + key.getKey() + "\"");
                            entry = new ChannelCacheEntry(chars, key.getKeyValidity());
                        } else {
                            entry.buffer = chars;
                        }
                        ChannelRenderer.this.getChannelCache().put(key.getKey(), entry);
                    }
                } else {
                    LogService.log(LogService.DEBUG, "ChannelRenderer::setCharacterCache() : channel cache key is null.");
                }
            }
        }

        public boolean done() {
            return this.done;
        }

        public Throwable getThrowable() {
            return this.getException();
        }
    }
}

