/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import org.jasig.portal.ChannelRenderer;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.threading.BoundedThreadPool;

public final class ChannelRendererFactoryImpl
implements IChannelRendererFactory {
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/ChannelRendererFactoryImpl.java,v 1.2 2003/11/05 02:21:23 kweiner Exp $";
    private BoundedThreadPool mThreadPool = null;
    private static BoundedThreadPool cSharedThreadPool = null;

    public ChannelRendererFactoryImpl(String keyBase) {
        int initialThreads = 1;
        int maxThreads = 20;
        int threadPriority = 5;
        boolean sharedPool = false;
        try {
            initialThreads = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_initialThreads");
            maxThreads = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_maxThreads");
            threadPriority = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_threadPriority");
            sharedPool = PropertiesManager.getPropertyAsBoolean(keyBase + ".threadPool_shared");
        }
        catch (Exception x) {
            LogService.log(LogService.ERROR, "ChannelRendererFactoryImpl(" + keyBase + ") failed to find configuration parameters. Constructing with: " + "threadPool_initialThreads = " + initialThreads + " " + "threadPool_maxThreads = " + maxThreads + " " + "threadPool_threadPriority = " + threadPriority + " " + "threadPool_shared = " + sharedPool, x);
        }
        if (sharedPool) {
            cSharedThreadPool = new BoundedThreadPool(initialThreads, maxThreads, threadPriority);
        } else {
            this.mThreadPool = new BoundedThreadPool(initialThreads, maxThreads, threadPriority);
        }
    }

    public IChannelRenderer newInstance(IChannel channel, ChannelRuntimeData channelRuntimeData) {
        return new ChannelRenderer(channel, channelRuntimeData, null == this.mThreadPool ? cSharedThreadPool : this.mThreadPool);
    }
}

