/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IChannel;
import org.jasig.portal.IMimeResponse;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.IWorkerRequestProcessor;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.services.LogService;

public class DownloadDispatchWorker
implements IWorkerRequestProcessor {
    public void processWorkerDispatch(PortalControlStructures pcs) throws PortalException {
        HttpServletRequest req = pcs.getHttpServletRequest();
        HttpServletResponse res = pcs.getHttpServletResponse();
        String channelTarget = null;
        Hashtable<String, Object[]> targetParams = new Hashtable<String, Object[]>();
        channelTarget = req.getParameter("uP_channelTarget");
        if (channelTarget == null) {
            UPFileSpec upfs = new UPFileSpec(req);
            channelTarget = upfs.getTargetNodeId();
        }
        if (channelTarget != null) {
            IChannel ch;
            Enumeration en = req.getParameterNames();
            if (en != null) {
                while (en.hasMoreElements()) {
                    String pName = (String)en.nextElement();
                    if (pName.equals("uP_channelTarget")) continue;
                    Object[] val = req.getParameterValues(pName);
                    if (val == null) {
                        val = ((PortalSessionManager.RequestParamWrapper)req).getObjectParameterValues(pName);
                    }
                    targetParams.put(pName, val);
                }
            }
            if ((ch = pcs.getChannelManager().getChannelInstance(channelTarget)) != null) {
                if (ch instanceof IPrivilegedChannel) {
                    ((IPrivilegedChannel)ch).setPortalControlStructures(pcs);
                }
                ChannelRuntimeData rd = new ChannelRuntimeData();
                rd.setParameters(targetParams);
                rd.setBrowserInfo(new BrowserInfo(req));
                rd.setHttpRequestMethod(req.getMethod());
                rd.setUPFile(new UPFileSpec(null, 0, "userLayoutRootNode", channelTarget, null));
                ch.setRuntimeData(rd);
                if (ch instanceof IMimeResponse) {
                    IMimeResponse ds = (IMimeResponse)((Object)ch);
                    try {
                        Map httpHeaders = ds.getHeaders();
                        if (httpHeaders != null) {
                            Set headerKeys = httpHeaders.keySet();
                            Iterator it = headerKeys.iterator();
                            while (it.hasNext()) {
                                String param = (String)it.next();
                                String value = (String)httpHeaders.get(param);
                                res.setHeader(param, value);
                            }
                            httpHeaders.clear();
                        }
                        res.setContentType(ds.getContentType());
                        ServletOutputStream out = res.getOutputStream();
                        InputStream ios = ds.getInputStream();
                        if (ios != null) {
                            int size = 0;
                            byte[] contentBytes = new byte[8192];
                            while ((size = ios.read(contentBytes)) != -1) {
                                out.write(contentBytes, 0, size);
                            }
                            ios.close();
                        } else {
                            ds.downloadData((OutputStream)out);
                        }
                        out.flush();
                    }
                    catch (Exception e) {
                        ds.reportDownloadError(e);
                    }
                } else {
                    LogService.log(LogService.ERROR, "DownloadDispatchWorker::processWorkerDispatch(): Channel (instanceId=\"" + channelTarget + "\" needs to implement org.jasig.portal.IMimeResponse interface in order to download files.");
                }
            } else {
                LogService.log(LogService.ERROR, "DownloadDispatchWorker::processWorkerDispatch(): unable to obtain instance a channel. instanceId=\"" + channelTarget + "\".");
            }
        } else {
            LogService.log(LogService.ERROR, "DownloadDispatchWorker::processWorkerDispatch(): unable to determine instance Id of the target channel. requestURL=\"" + pcs.getHttpServletRequest().getRequestURI() + "\".");
        }
    }
}

