/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.ErrorID;
import org.jasig.portal.Errors;
import org.jasig.portal.PortalException;
import org.jasig.portal.ProblemsTable;
import org.jasig.portal.services.LogService;

public class ExceptionHelper {
    public static final String[] boundaries = new String[]{"at javax.servlet.http.HttpServlet."};

    public static String shortStackTrace(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        sw.flush();
        String stktr = sw.toString();
        for (int i = 0; i < boundaries.length; ++i) {
            int cut = stktr.indexOf(boundaries[i]);
            if (cut <= 0) continue;
            return stktr.substring(0, cut).trim();
        }
        return stktr;
    }

    public static void genericHandler(ErrorID eid, String parm, Throwable ex) throws PortalException {
        if (ex instanceof PortalException) {
            if (((PortalException)ex).isLogPending()) {
                ExceptionHelper.traceToLog(eid, parm, ex);
            }
            throw (PortalException)ex;
        }
        ExceptionHelper.traceToLog(eid, parm, ex);
        PortalException nex = ex instanceof Exception ? new PortalException(eid, (Exception)ex) : new PortalException(eid);
        nex.setLogPending(false);
        ProblemsTable.store(nex);
        throw nex;
    }

    public static void genericHandler(ErrorID eid, Throwable ex) throws PortalException {
        ExceptionHelper.genericHandler(eid, null, ex);
    }

    public static void signal(ErrorID eid, String parm, boolean tracenow) throws PortalException {
        PortalException nex = new PortalException(eid);
        nex.setParameter(parm);
        ExceptionHelper.signal(nex, tracenow);
    }

    public static void signal(ErrorID eid, String parm) throws PortalException {
        ExceptionHelper.signal(eid, parm, true);
    }

    private static void signal(PortalException nex, boolean tracenow) throws PortalException {
        if (tracenow) {
            ExceptionHelper.traceToLog(nex.getErrorID(), nex.getParameter(), nex);
            ProblemsTable.store(nex);
        }
        throw nex;
    }

    public static void signal(ErrorID eid) throws PortalException {
        ExceptionHelper.signal(eid, null, true);
    }

    private static void traceToLog(ErrorID eid, String parm, Throwable ex) {
        if (ex != null && ex instanceof PortalException) {
            if (!((PortalException)ex).isLogPending()) {
                return;
            }
            ((PortalException)ex).setLogPending(false);
        }
        String logmsg = ExceptionHelper.errorInfo(eid, parm, ex);
        LogService.log(LogService.ERROR, logmsg);
    }

    public static String errorInfo(ErrorID eid, String parm, Throwable ex) {
        StringBuffer errorinfobuffer = new StringBuffer(1000);
        if (eid != Errors.legacy) {
            errorinfobuffer.append(eid.getMessage());
        } else {
            errorinfobuffer.append(ex.getMessage());
        }
        if (parm != null) {
            errorinfobuffer.append("\n    [specific data: ");
            errorinfobuffer.append(parm);
            errorinfobuffer.append("] ");
        }
        errorinfobuffer.append("\n");
        if (ex != null) {
            errorinfobuffer.append(ExceptionHelper.shortStackTrace(ex));
        }
        return errorinfobuffer.toString();
    }

    public static void genericTopHandler(ErrorID eid, String parm, Throwable ex) {
        if (ex instanceof PortalException && !((PortalException)ex).isLogPending()) {
            return;
        }
        ExceptionHelper.traceToLog(eid, parm, ex);
        if (ex instanceof PortalException) {
            return;
        }
        PortalException nex = null;
        nex = ex instanceof Exception ? new PortalException(eid, (Exception)ex) : new PortalException(eid);
        ProblemsTable.store(nex);
    }

    public static void genericTopHandler(ErrorID eid, Throwable ex) {
        ExceptionHelper.genericTopHandler(eid, null, ex);
    }

    public static void generateErrorPage(HttpServletResponse resp, Exception e) {
        resp.setContentType("text/html");
        try {
            PrintWriter out = resp.getWriter();
            out.println("<h1>Cannot start uPortal</h1>");
            out.println("<p>Sorry, but a problem is preventing the Portal from starting. The error must be corrected by system administrators. Try again later.</p>");
            out.println("<!--");
            ErrorID eid = Errors.bug;
            String parm = "";
            if (e instanceof PortalException) {
                PortalException pe = (PortalException)e;
                if (pe.errorID != null) {
                    eid = pe.errorID;
                }
                if (pe.parameter != null) {
                    parm = pe.parameter;
                }
            }
            out.println(ExceptionHelper.errorInfo(eid, parm, e));
            out.println("-->");
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

