/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.GuestUserPreferencesManager;
import org.jasig.portal.GuestUserPreferencesManagerWrapper;
import org.jasig.portal.PortalException;
import org.jasig.portal.StandaloneChannelRenderer;
import org.jasig.portal.UserInstance;
import org.jasig.portal.channels.CSelectSystemProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.StatsRecorder;

public class GuestUserInstance
extends UserInstance
implements HttpSessionBindingListener {
    Map stateTable = Collections.synchronizedMap(new HashMap());
    GuestUserPreferencesManager uLayoutManager;

    public GuestUserInstance(IPerson person) {
        super(person);
        this.uLayoutManager = new GuestUserPreferencesManager(person);
    }

    public void registerSession(HttpServletRequest req) throws PortalException {
        IState newState = new IState();
        newState.channelManager = new ChannelManager(new GuestUserPreferencesManagerWrapper(this.uLayoutManager, req.getSession(false).getId()));
        newState.localeManager = new LocaleManager(this.person, req.getHeader("Accept-Language"));
        newState.p_rendering_lock = new Object();
        this.uLayoutManager.setLocaleManager(newState.localeManager);
        this.uLayoutManager.registerSession(req);
        this.stateTable.put(req.getSession(false).getId(), newState);
    }

    public void unbindSession(String sessionId) {
        IState state = (IState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserInstance::unbindSession() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return;
        }
        state.channelManager.finishedSession();
        this.uLayoutManager.unbindSession(sessionId);
        this.stateTable.remove(sessionId);
    }

    public void valueUnbound(HttpSessionBindingEvent bindingEvent) {
        this.unbindSession(bindingEvent.getSession().getId());
        LogService.log(LogService.DEBUG, "GuestUserInstance::valueUnbound() : unbinding session \"" + bindingEvent.getSession().getId() + "\"");
        StatsRecorder.recordSessionDestroyed(this.person);
    }

    public void valueBound(HttpSessionBindingEvent bindingEvent) {
        LogService.log(LogService.DEBUG, "GuestUserInstance::valueBound() : instance bound to a new session \"" + bindingEvent.getSession().getId() + "\"");
        StatsRecorder.recordSessionCreated(this.person);
    }

    public void writeContent(HttpServletRequest req, HttpServletResponse res) throws PortalException {
        String sessionId = req.getSession(false).getId();
        IState state = (IState)this.stateTable.get(sessionId);
        if (state == null) {
            LogService.log(LogService.ERROR, "GuestUserInstance::writeContent() : trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
            return;
        }
        if (state.p_browserMapper != null) {
            try {
                state.p_browserMapper.prepare(req);
            }
            catch (Exception e) {
                throw new PortalException(e);
            }
        }
        if (this.uLayoutManager.isUserAgentUnmapped(sessionId)) {
            this.uLayoutManager.unbindSession(sessionId);
            this.uLayoutManager.registerSession(req);
        } else {
            state.p_browserMapper = null;
        }
        if (this.uLayoutManager.isUserAgentUnmapped(sessionId)) {
            if (state.p_browserMapper == null) {
                state.p_browserMapper = new CSelectSystemProfile();
                state.p_browserMapper.initialize(new Hashtable(), "CSelectSystemProfile", true, true, false, 10000L, this.getPerson());
            }
            try {
                state.p_browserMapper.render(req, res);
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Throwable t) {
                LogService.log(LogService.ERROR, "GuestUserInstance::writeContent() : CSelectSystemProfileChannel.render() threw: " + t);
                throw new PortalException("CSelectSystemProfileChannel.render() threw: " + t);
            }
            return;
        }
        this.renderState(req, res, state.channelManager, state.localeManager, new GuestUserPreferencesManagerWrapper(this.uLayoutManager, sessionId), state.p_rendering_lock);
    }

    private class IState {
        private ChannelManager channelManager = null;
        private LocaleManager localeManager;
        private StandaloneChannelRenderer p_browserMapper = null;
        private Object p_rendering_lock = null;
    }
}

