/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jasig.portal.services.LogService;

public class LdapServices {
    private static boolean bPropsLoaded = false;
    private static String sLdapHost = null;
    private static String sLdapPort = null;
    private static String sLdapBaseDN = null;
    private static String sLdapUidAttribute = null;
    private static String sLdapManagerDN = null;
    private static String sLdapManagerPW = null;
    private static String sLdapManagerProto = null;

    public LdapServices() {
        try {
            if (!bPropsLoaded) {
                InputStream ins = this.getClass().getResourceAsStream("/properties/ldap.properties");
                Properties ldapProps = new Properties();
                ldapProps.load(ins);
                sLdapHost = ldapProps.getProperty("ldap.host", "");
                sLdapPort = ldapProps.getProperty("ldap.port", "389");
                sLdapBaseDN = ldapProps.getProperty("ldap.baseDN", "");
                sLdapUidAttribute = ldapProps.getProperty("ldap.uidAttribute", "");
                sLdapManagerDN = ldapProps.getProperty("ldap.managerDN", "");
                sLdapManagerPW = ldapProps.getProperty("ldap.managerPW", "");
                sLdapManagerProto = ldapProps.getProperty("ldap.protocol", "");
                LogService.log(LogService.DEBUG, "ldap.host = " + sLdapHost);
                LogService.log(LogService.DEBUG, "ldap.port = " + sLdapPort);
                LogService.log(LogService.DEBUG, "ldap.baseDN = " + sLdapBaseDN);
                LogService.log(LogService.DEBUG, "ldap.uidAttribute = " + sLdapUidAttribute);
                LogService.log(LogService.DEBUG, "ldap.managerDN = " + sLdapManagerDN);
                LogService.log(LogService.DEBUG, "ldap.managerPW = " + sLdapManagerPW);
                LogService.log(LogService.DEBUG, "ldap.protocol = " + sLdapManagerProto);
                bPropsLoaded = true;
            }
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
    }

    public DirContext getConnection() {
        InitialDirContext conn = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>(5, 0.75f);
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            StringBuffer urlBuffer = new StringBuffer("ldap://");
            urlBuffer.append(sLdapHost).append(":").append(sLdapPort);
            env.put("java.naming.provider.url", urlBuffer.toString());
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", sLdapManagerDN);
            env.put("java.naming.security.credentials", sLdapManagerPW);
            if (sLdapManagerProto.equals("ssl")) {
                env.put("java.naming.security.protocol", "ssl");
            }
            conn = new InitialDirContext(env);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        return conn;
    }

    public String getBaseDN() {
        return sLdapBaseDN;
    }

    public String getUidAttribute() {
        return sLdapUidAttribute;
    }

    public void releaseConnection(DirContext conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
        }
    }
}

