/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import com.oreilly.servlet.multipart.FilePart;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import org.jasig.portal.services.LogService;

public class MultipartDataSource
implements DataSource {
    File tempfile;
    ByteArrayOutputStream buff = null;
    String contentType = null;
    String filename = null;

    public MultipartDataSource(FilePart filePart) throws IOException {
        this.contentType = filePart.getContentType();
        this.filename = filePart.getFileName();
        try {
            this.tempfile = File.createTempFile("uPdata", null);
            this.tempfile.deleteOnExit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempfile));
            filePart.writeTo((OutputStream)out);
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            LogService.log(LogService.ERROR, "MultipartDataSource unable to create temp file: " + ioe.getMessage());
            if (this.tempfile != null) {
                try {
                    this.tempfile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.tempfile = null;
            }
            this.buff = new ByteArrayOutputStream();
            filePart.writeTo((OutputStream)this.buff);
        }
    }

    public void finalize() {
        this.buff = null;
        if (this.tempfile != null) {
            this.tempfile.delete();
            this.tempfile = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.tempfile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempfile));
        }
        return new ByteArrayInputStream(this.buff.toByteArray());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not implemented");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.filename;
    }

    public File getFile() throws Exception {
        throw new Exception("getFile() not implemented");
    }

    public void setFileTypeMap(FileTypeMap p0) throws Exception {
        throw new Exception("setFileTypeMap() not implemented");
    }
}

