/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.RDBMUserLayoutStore;
import org.jasig.portal.services.LogService;

public final class OracleUserLayoutStore
extends RDBMUserLayoutStore
implements IUserLayoutStore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIncrementIntegerId(String tableName) throws Exception {
        int id;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT " + tableName + "_SEQ.NEXTVAL FROM DUAL";
                LogService.log(LogService.DEBUG, "OracleUserLayoutStore::getIncrementInteger(): " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    rs.next();
                    id = rs.getInt(1);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return id;
    }

    public void createCounter(String tableName) throws Exception {
        this.createCounter(tableName, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createCounter(String tableName, int startAt) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sInsert = "CREATE SEQUENCE " + tableName + "_SEQ INCREMENT BY 1 START WITH " + startAt + " NOMAXVALUE NOCYCLE";
                LogService.log(LogService.DEBUG, "OracleUserLayoutStore::createCounter(): " + sInsert);
                stmt.executeUpdate(sInsert);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCounter(String tableName, int value) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sUpdate = "DROP SEQUENCE " + tableName + "_SEQ";
                LogService.log(LogService.DEBUG, "OracleUserLayoutStore::setCounter(): " + sUpdate);
                stmt.executeUpdate(sUpdate);
                this.createCounter(tableName, value);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }
}

