/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.CoreStylesheetDescription;
import org.jasig.portal.CoreXSLTStylesheetDescription;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.ThemeStylesheetUserPreferences;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.CounterStoreFactory;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.ICounterStore;
import org.jasig.portal.utils.IPortalDocument;
import org.jasig.portal.utils.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RDBMUserLayoutStore
implements IUserLayoutStore {
    protected static int DEBUG = 0;
    protected static final String channelPrefix = "n";
    protected static final String folderPrefix = "s";
    protected IChannelRegistryStore crs;
    protected ICounterStore csdb;
    protected static final boolean localeAware = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.i18n.LocaleManager.locale_aware");
    private IPerson systemUser = new SystemUser();

    public RDBMUserLayoutStore() throws Exception {
        this.crs = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
        this.csdb = CounterStoreFactory.getCounterStoreImpl();
        if (RDBMServices.supportsOuterJoins) {
            if (RDBMServices.joinQuery instanceof RDBMServices.JdbcDb) {
                RDBMServices.joinQuery.addQuery("layout", "{oj UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID} WHERE");
                RDBMServices.joinQuery.addQuery("ss_struct", "{oj UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID} WHERE");
                RDBMServices.joinQuery.addQuery("ss_theme", "{oj UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID} WHERE");
            } else if (RDBMServices.joinQuery instanceof RDBMServices.PostgreSQLDb) {
                RDBMServices.joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID WHERE");
                RDBMServices.joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID WHERE");
                RDBMServices.joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID WHERE");
            } else if (RDBMServices.joinQuery instanceof RDBMServices.OracleDb) {
                RDBMServices.joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS, UP_LAYOUT_PARAM USP WHERE ULS.STRUCT_ID = USP.STRUCT_ID(+) AND ULS.USER_ID = USP.USER_ID(+) AND");
                RDBMServices.joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS, UP_SS_STRUCT_PAR USP WHERE USS.SS_ID=USP.SS_ID(+) AND");
                RDBMServices.joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS, UP_SS_THEME_PARM UTP WHERE UTS.SS_ID=UTP.SS_ID(+) AND");
            } else {
                throw new Exception("Unknown database driver");
            }
        }
    }

    /*
     * Loose catch block
     */
    public Integer addStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int id = this.csdb.getIncrementIntegerId("UP_SS_STRUCT");
                ssd.setId(id);
                String sQuery = "INSERT INTO UP_SS_STRUCT (SS_ID,SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT) VALUES (" + id + ",'" + ssd.getStylesheetName() + "','" + ssd.getStylesheetURI() + "','" + ssd.getStylesheetDescriptionURI() + "','" + ssd.getStylesheetWordDescription() + "')";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery);
                stmt.executeUpdate(sQuery);
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getStylesheetParameterDefaultValue(pName) + "','" + ssd.getStylesheetParameterWordDescription(pName) + "',1)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getFolderAttributeDefaultValue(pName) + "','" + ssd.getFolderAttributeWordDescription(pName) + "',2)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + ssd.getChannelAttributeDefaultValue(pName) + "','" + ssd.getChannelAttributeWordDescription(pName) + "',3)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
                Integer n = new Integer(id);
                return n;
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * Loose catch block
     */
    public Integer addThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int id = this.csdb.getIncrementIntegerId("UP_SS_THEME");
                tsd.setId(id);
                String sQuery = "INSERT INTO UP_SS_THEME (SS_ID,SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT,STRUCT_SS_ID,SAMPLE_URI,SAMPLE_ICON_URI,MIME_TYPE,DEVICE_TYPE,SERIALIZER_NAME,UP_MODULE_CLASS) VALUES (" + id + ",'" + tsd.getStylesheetName() + "','" + tsd.getStylesheetURI() + "','" + tsd.getStylesheetDescriptionURI() + "','" + tsd.getStylesheetWordDescription() + "'," + tsd.getStructureStylesheetId() + ",'" + tsd.getSamplePictureURI() + "','" + tsd.getSampleIconURI() + "','" + tsd.getMimeType() + "','" + tsd.getDeviceType() + "','" + tsd.getSerializerName() + "','" + tsd.getCustomUserPreferencesManagerClass() + "')";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery);
                stmt.executeUpdate(sQuery);
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + tsd.getStylesheetParameterDefaultValue(pName) + "','" + tsd.getStylesheetParameterWordDescription(pName) + "',1)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + id + ",'" + pName + "','" + tsd.getChannelAttributeDefaultValue(pName) + "','" + tsd.getChannelAttributeWordDescription(pName) + "',3)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
                Integer n = new Integer(id);
                return n;
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public boolean updateThemeStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI, int stylesheetId) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            String ssName = this.getRootElementTextValue(stylesheetDescriptionXML, "parentStructureStylesheet");
            if (ssName == null) {
                return false;
            }
            Integer ssId = this.getStructureStylesheetId(ssName);
            if (ssId == null) {
                return false;
            }
            ThemeStylesheetDescription sssd = new ThemeStylesheetDescription();
            sssd.setId(stylesheetId);
            sssd.setStructureStylesheetId(ssId);
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            sssd.setStylesheetName(xmlStylesheetName);
            sssd.setStylesheetURI(stylesheetURI);
            sssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            sssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            sssd.setMimeType(this.getRootElementTextValue(stylesheetDescriptionXML, "mimeType"));
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : setting mimetype=\"" + sssd.getMimeType() + "\"");
            sssd.setSerializerName(this.getRootElementTextValue(stylesheetDescriptionXML, "serializer"));
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : setting serializerName=\"" + sssd.getSerializerName() + "\"");
            sssd.setCustomUserPreferencesManagerClass(this.getRootElementTextValue(stylesheetDescriptionXML, "userPreferencesModuleClass"));
            sssd.setSamplePictureURI(this.getRootElementTextValue(stylesheetDescriptionXML, "samplePictureURI"));
            sssd.setSampleIconURI(this.getRootElementTextValue(stylesheetDescriptionXML, "sampleIconURI"));
            sssd.setDeviceType(this.getRootElementTextValue(stylesheetDescriptionXML, "deviceType"));
            this.populateParameterTable(stylesheetDescriptionXML, sssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, sssd);
            this.updateThemeStylesheetDescription(sssd);
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
            return false;
        }
        return true;
    }

    public boolean updateStructureStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI, int stylesheetId) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            StructureStylesheetDescription fssd = new StructureStylesheetDescription();
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            fssd.setId(stylesheetId);
            fssd.setStylesheetName(xmlStylesheetName);
            fssd.setStylesheetURI(stylesheetURI);
            fssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            fssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            this.populateParameterTable(stylesheetDescriptionXML, fssd);
            this.populateFolderAttributeTable(stylesheetDescriptionXML, fssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, fssd);
            this.updateStructureStylesheetDescription(fssd);
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
            return false;
        }
        return true;
    }

    public Integer addStructureStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            StructureStylesheetDescription fssd = new StructureStylesheetDescription();
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            fssd.setStylesheetName(xmlStylesheetName);
            fssd.setStylesheetURI(stylesheetURI);
            fssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            fssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            this.populateParameterTable(stylesheetDescriptionXML, fssd);
            this.populateFolderAttributeTable(stylesheetDescriptionXML, fssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, fssd);
            return this.addStructureStylesheetDescription(fssd);
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
            return null;
        }
    }

    public Integer addThemeStylesheetDescription(String stylesheetDescriptionURI, String stylesheetURI) {
        try {
            Document stylesheetDescriptionXML = this.getDOM(stylesheetDescriptionURI);
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription() : stylesheet name = " + this.getName(stylesheetDescriptionXML));
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription() : stylesheet description = " + this.getDescription(stylesheetDescriptionXML));
            String ssName = this.getRootElementTextValue(stylesheetDescriptionXML, "parentStructureStylesheet");
            if (ssName == null) {
                return null;
            }
            Integer ssId = this.getStructureStylesheetId(ssName);
            if (ssId == null) {
                return null;
            }
            ThemeStylesheetDescription sssd = new ThemeStylesheetDescription();
            sssd.setStructureStylesheetId(ssId);
            String xmlStylesheetName = this.getName(stylesheetDescriptionXML);
            String xmlStylesheetDescriptionText = this.getDescription(stylesheetDescriptionXML);
            sssd.setStylesheetName(xmlStylesheetName);
            sssd.setStylesheetURI(stylesheetURI);
            sssd.setStylesheetDescriptionURI(stylesheetDescriptionURI);
            sssd.setStylesheetWordDescription(xmlStylesheetDescriptionText);
            sssd.setMimeType(this.getRootElementTextValue(stylesheetDescriptionXML, "mimeType"));
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription() : setting mimetype=\"" + sssd.getMimeType() + "\"");
            sssd.setSerializerName(this.getRootElementTextValue(stylesheetDescriptionXML, "serializer"));
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addThemeStylesheetDescription() : setting serializerName=\"" + sssd.getSerializerName() + "\"");
            sssd.setCustomUserPreferencesManagerClass(this.getRootElementTextValue(stylesheetDescriptionXML, "userPreferencesModuleClass"));
            sssd.setSamplePictureURI(this.getRootElementTextValue(stylesheetDescriptionXML, "samplePictureURI"));
            sssd.setSampleIconURI(this.getRootElementTextValue(stylesheetDescriptionXML, "sampleIconURI"));
            sssd.setDeviceType(this.getRootElementTextValue(stylesheetDescriptionXML, "deviceType"));
            this.populateParameterTable(stylesheetDescriptionXML, sssd);
            this.populateChannelAttributeTable(stylesheetDescriptionXML, sssd);
            return this.addThemeStylesheetDescription(sssd);
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile addUserProfile(IPerson person, UserProfile profile) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            int id = this.csdb.getIncrementIntegerId("UP_USER_PROFILE");
            profile.setProfileId(id);
            Statement stmt = con.createStatement();
            try {
                String sQuery = "INSERT INTO UP_USER_PROFILE (USER_ID,PROFILE_ID,PROFILE_NAME,STRUCTURE_SS_ID,THEME_SS_ID,DESCRIPTION) VALUES (" + userId + "," + profile.getProfileId() + ",'" + profile.getProfileName() + "'," + profile.getStructureStylesheetId() + "," + profile.getThemeStylesheetId() + ",'" + profile.getProfileDescription() + "')";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::addUserProfile(): " + sQuery);
                stmt.executeUpdate(sQuery);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return profile;
    }

    protected static boolean channelApproved(Date approvedDate) {
        Date rightNow = new Date();
        return approvedDate != null && rightNow.after(approvedDate);
    }

    protected final void createLayout(HashMap layoutStructure, Document doc, Element root, int structId) throws SQLException, Exception {
        while (structId != 0) {
            if (DEBUG > 1) {
                System.err.println("CreateLayout(" + structId + ")");
            }
            LayoutStructure ls = (LayoutStructure)layoutStructure.get(new Integer(structId));
            Element structure = ls.getStructureDocument(doc);
            root.appendChild(structure);
            if (!ls.isChannel()) {
                this.createLayout(layoutStructure, doc, structure, ls.getChildId());
            }
            structId = ls.getNextId();
        }
    }

    protected static final boolean xmlBool(String value) {
        return value != null && value.equals("true");
    }

    public void deleteUserProfile(IPerson person, int profileId) throws Exception {
        int userId = person.getID();
        this.deleteUserProfile(userId, profileId);
    }

    private Document getDOM(String uri) throws Exception {
        DOMResult result = new DOMResult();
        SAXSource source = new SAXSource(new InputSource(ResourceLoader.getResourceAsStream(this.getClass(), uri)));
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer emptytr = tFactory.newTransformer();
        emptytr.transform(source, result);
        Node node = result.getNode();
        if (node instanceof Document) {
            return (Document)node;
        }
        Document dom = DocumentFactory.getNewDocument();
        dom.appendChild(dom.importNode(node, true));
        return dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUserProfile(int userId, int profileId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "DELETE FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::deleteUserProfile() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_USER_UA_MAP WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::deleteUserProfile() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::deleteUserProfile() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + Integer.toString(profileId);
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::deleteUserProfile() : " + sQuery);
                stmt.executeUpdate(sQuery);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public static final void dumpDoc(Node node, String indent) {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            System.err.print(indent + "element: tag=" + ((Element)node).getTagName() + " ");
        } else if (node instanceof Document) {
            System.err.print("document:");
        } else {
            System.err.print(indent + "node:");
        }
        System.err.println("name=" + node.getNodeName() + " value=" + node.getNodeValue());
        NamedNodeMap nm = node.getAttributes();
        if (nm != null) {
            for (int i = 0; i < nm.getLength(); ++i) {
                System.err.println(indent + " " + nm.item(i).getNodeName() + ": '" + nm.item(i).getNodeValue() + "'");
            }
            System.err.println(indent + "--");
        }
        if (node.hasChildNodes()) {
            RDBMUserLayoutStore.dumpDoc(node.getFirstChild(), indent + "   ");
        }
        RDBMUserLayoutStore.dumpDoc(node.getNextSibling(), indent);
    }

    /*
     * Exception decompiling
     */
    public Hashtable getMimeTypeList() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String generateNewChannelSubscribeId(IPerson person) throws Exception {
        return this.getNextStructId(person, channelPrefix);
    }

    public String generateNewFolderId(IPerson person) throws Exception {
        return this.getNextStructId(person, folderPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String getNextStructId(IPerson person, String prefix) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                for (int i = 0; i < 25; ++i) {
                    int currentStructId;
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getNextStructId(): " + sQuery);
                    ResultSet rs = stmt.executeQuery(sQuery);
                    try {
                        rs.next();
                        currentStructId = rs.getInt(1);
                    }
                    finally {
                        rs.close();
                    }
                    int nextStructId = currentStructId + 1;
                    try {
                        String sUpdate = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nextStructId + " WHERE USER_ID=" + userId + " AND NEXT_STRUCT_ID=" + currentStructId;
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getNextStructId(): " + sUpdate);
                        stmt.executeUpdate(sUpdate);
                        RDBMServices.commit(con);
                        String string = prefix + nextStructId;
                        return string;
                    }
                    catch (SQLException sqle) {
                        RDBMServices.rollback(con);
                        Thread.sleep(Math.round(Math.random() * 3.0 * 1000.0));
                        continue;
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    protected String getStructId(int structId, int chanId) {
        if (chanId == 0) {
            return folderPrefix + structId;
        }
        return channelPrefix + structId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureStylesheetDescription getStructureStylesheetDescription(int stylesheetId) throws Exception {
        StructureStylesheetDescription ssd = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement stmt = con.createStatement();
            int dbOffset = 0;
            String sQuery = "SELECT SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT";
            if (RDBMServices.supportsOuterJoins) {
                sQuery = sQuery + ",TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM " + RDBMServices.joinQuery.getQuery("ss_struct");
                dbOffset = 4;
            } else {
                sQuery = sQuery + " FROM UP_SS_STRUCT USS WHERE";
            }
            sQuery = sQuery + " USS.SS_ID=" + stylesheetId;
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetDescription(): " + sQuery);
            ResultSet rs = stmt.executeQuery(sQuery);
            try {
                if (rs.next()) {
                    ssd = new StructureStylesheetDescription();
                    ssd.setId(stylesheetId);
                    ssd.setStylesheetName(rs.getString(1));
                    ssd.setStylesheetURI(rs.getString(2));
                    ssd.setStylesheetDescriptionURI(rs.getString(3));
                    ssd.setStylesheetWordDescription(rs.getString(4));
                }
                if (!RDBMServices.supportsOuterJoins) {
                    rs.close();
                    sQuery = "SELECT TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetDescription(): " + sQuery);
                    rs = stmt.executeQuery(sQuery);
                }
                do {
                    if (!RDBMServices.supportsOuterJoins && !rs.next()) {
                        break;
                    }
                    int type = rs.getInt(dbOffset + 1);
                    if (rs.wasNull()) {
                        break;
                    }
                    if (type == 1) {
                        ssd.addStylesheetParameter(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 2) {
                        ssd.addFolderAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 3) {
                        ssd.addChannelAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ").");
                } while (!RDBMServices.supportsOuterJoins || rs.next());
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {}
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return ssd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getStructureStylesheetId(String ssName) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_STRUCT WHERE SS_NAME='" + ssName + "'";
                ResultSet rs = stmt.executeQuery(sQuery);
                if (rs.next()) {
                    int id = rs.getInt("SS_ID");
                    if (rs.wasNull()) {
                        id = 0;
                    }
                    Integer n = new Integer(id);
                    return n;
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getStructureStylesheetList(String mimeType) throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, StructureStylesheetDescription> list = new Hashtable<Integer, StructureStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT A.SS_ID FROM UP_SS_STRUCT A, UP_SS_THEME B WHERE B.MIME_TYPE='" + mimeType + "' AND B.STRUCT_SS_ID=A.SS_ID";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetList() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(rs.getInt("SS_ID"));
                        if (ssd == null) continue;
                        list.put(new Integer(ssd.getId()), ssd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getStructureStylesheetList() throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, StructureStylesheetDescription> list = new Hashtable<Integer, StructureStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_STRUCT";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetList() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(rs.getInt("SS_ID"));
                        if (ssd == null) continue;
                        list.put(new Integer(ssd.getId()), ssd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureStylesheetUserPreferences getStructureStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        StructureStylesheetUserPreferences ssup;
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String pName;
                String sQuery;
                int layoutId;
                StructureStylesheetDescription ssd = this.getStructureStylesheetDescription(stylesheetId);
                String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + subSelectString);
                ResultSet rs = stmt.executeQuery(subSelectString);
                try {
                    rs.next();
                    layoutId = rs.getInt(1);
                    if (rs.wasNull()) {
                        layoutId = 0;
                    }
                }
                finally {
                    rs.close();
                }
                if (layoutId == 0) {
                    sQuery = "SELECT USER_DFLT_USR_ID FROM UP_USER WHERE USER_ID=" + userId;
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                    rs = stmt.executeQuery(sQuery);
                    try {
                        rs.next();
                        userId = rs.getInt(1);
                    }
                    finally {
                        rs.close();
                    }
                }
                sQuery = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ssd.setStylesheetParameterDefaultValue(rs.getString(1), rs.getString(2));
                    }
                }
                finally {
                    rs.close();
                }
                ssup = new StructureStylesheetUserPreferences();
                ssup.setStylesheetId(stylesheetId);
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.putParameterValue(pName, ssd.getStylesheetParameterDefaultValue(pName));
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addChannelAttribute(pName, ssd.getChannelAttributeDefaultValue(pName));
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    ssup.addFolderAttribute(pName, ssd.getFolderAttributeDefaultValue(pName));
                }
                sQuery = "SELECT PARAM_NAME, PARAM_VAL, PARAM_TYPE, ULS.STRUCT_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT ULS WHERE UUSA.USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        String temp1 = rs.getString(1);
                        String temp2 = rs.getString(2);
                        int param_type = rs.getInt(3);
                        int structId = rs.getInt(4);
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type == 1) {
                            LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences() :  stylesheet global params should be specified in the user defaults table ! UP_SS_USER_ATTS is corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + temp1 + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 2) {
                            ssup.setFolderAttributeValue(this.getStructId(structId, chanId), temp1, temp2);
                            continue;
                        }
                        if (param_type == 3) {
                            ssup.setChannelAttributeValue(this.getStructId(structId, chanId), temp1, temp2);
                            continue;
                        }
                        LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getStructureStylesheetUserPreferences() : unknown param type encountered! DB corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + temp1 + "\", param_type=" + Integer.toString(param_type));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return ssup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeStylesheetDescription getThemeStylesheetDescription(int stylesheetId) throws Exception {
        ThemeStylesheetDescription tsd = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement stmt = con.createStatement();
            int dbOffset = 0;
            String sQuery = "SELECT SS_NAME,SS_URI,SS_DESCRIPTION_URI,SS_DESCRIPTION_TEXT,STRUCT_SS_ID,SAMPLE_ICON_URI,SAMPLE_URI,MIME_TYPE,DEVICE_TYPE,SERIALIZER_NAME,UP_MODULE_CLASS";
            if (RDBMServices.supportsOuterJoins) {
                sQuery = sQuery + ",TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM " + RDBMServices.joinQuery.getQuery("ss_theme");
                dbOffset = 11;
            } else {
                sQuery = sQuery + " FROM UP_SS_THEME UTS WHERE";
            }
            sQuery = sQuery + " UTS.SS_ID=" + stylesheetId;
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetDescription(): " + sQuery);
            ResultSet rs = stmt.executeQuery(sQuery);
            try {
                if (rs.next()) {
                    tsd = new ThemeStylesheetDescription();
                    tsd.setId(stylesheetId);
                    tsd.setStylesheetName(rs.getString(1));
                    tsd.setStylesheetURI(rs.getString(2));
                    tsd.setStylesheetDescriptionURI(rs.getString(3));
                    tsd.setStylesheetWordDescription(rs.getString(4));
                    int ssId = rs.getInt(5);
                    if (rs.wasNull()) {
                        ssId = 0;
                    }
                    tsd.setStructureStylesheetId(ssId);
                    tsd.setSampleIconURI(rs.getString(6));
                    tsd.setSamplePictureURI(rs.getString(7));
                    tsd.setMimeType(rs.getString(8));
                    tsd.setDeviceType(rs.getString(9));
                    tsd.setSerializerName(rs.getString(10));
                    tsd.setCustomUserPreferencesManagerClass(rs.getString(11));
                }
                if (!RDBMServices.supportsOuterJoins) {
                    rs.close();
                    sQuery = "SELECT TYPE,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetDescription(): " + sQuery);
                    rs = stmt.executeQuery(sQuery);
                }
                do {
                    if (!RDBMServices.supportsOuterJoins && !rs.next()) {
                        break;
                    }
                    int type = rs.getInt(dbOffset + 1);
                    if (rs.wasNull()) {
                        break;
                    }
                    if (type == 1) {
                        tsd.addStylesheetParameter(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 3) {
                        tsd.addChannelAttribute(rs.getString(dbOffset + 2), rs.getString(dbOffset + 3), rs.getString(dbOffset + 4));
                        continue;
                    }
                    if (type == 2) {
                        LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getThemeStylesheetDescription() : encountered a folder attribute specified for a theme stylesheet ! Corrupted DB entry. (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ").");
                        continue;
                    }
                    LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getThemeStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rs.getString(dbOffset + 2) + "\" type=" + type + ").");
                } while (!RDBMServices.supportsOuterJoins || rs.next());
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception e) {}
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return tsd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getThemeStylesheetId(String tsName) throws Exception {
        Integer id = null;
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE SS_NAME='" + tsName + "'";
                ResultSet rs = stmt.executeQuery(sQuery);
                if (rs.next()) {
                    id = new Integer(rs.getInt("SS_ID"));
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getThemeStylesheetList(int structureStylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, ThemeStylesheetDescription> list = new Hashtable<Integer, ThemeStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE STRUCT_SS_ID=" + structureStylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetList() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(rs.getInt("SS_ID"));
                        if (tsd == null) continue;
                        list.put(new Integer(tsd.getId()), tsd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getThemeStylesheetList() throws Exception {
        Connection con = RDBMServices.getConnection();
        Hashtable<Integer, ThemeStylesheetDescription> list = new Hashtable<Integer, ThemeStylesheetDescription>();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetList() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(rs.getInt("SS_ID"));
                        if (tsd == null) continue;
                        list.put(new Integer(tsd.getId()), tsd);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeStylesheetUserPreferences getThemeStylesheetUserPreferences(IPerson person, int profileId, int stylesheetId) throws Exception {
        ThemeStylesheetUserPreferences tsup;
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String pName;
                ThemeStylesheetDescription tsd = this.getThemeStylesheetDescription(stylesheetId);
                String sQuery = "SELECT PARAM_NAME, PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences(): " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        tsd.setStylesheetParameterDefaultValue(rs.getString(1), rs.getString(2));
                    }
                }
                finally {
                    rs.close();
                }
                tsup = new ThemeStylesheetUserPreferences();
                tsup.setStylesheetId(stylesheetId);
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.putParameterValue(pName, tsd.getStylesheetParameterDefaultValue(pName));
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    tsup.addChannelAttribute(pName, tsd.getChannelAttributeDefaultValue(pName));
                }
                sQuery = "SELECT PARAM_TYPE, PARAM_NAME, PARAM_VAL, ULS.STRUCT_ID, CHAN_ID FROM UP_SS_USER_ATTS UUSA, UP_LAYOUT_STRUCT ULS WHERE UUSA.USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND UUSA.STRUCT_ID = ULS.STRUCT_ID AND UUSA.USER_ID = ULS.USER_ID";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences(): " + sQuery);
                rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        int param_type = rs.getInt(1);
                        if (rs.wasNull()) {
                            param_type = 0;
                        }
                        int structId = rs.getInt(4);
                        if (rs.wasNull()) {
                            structId = 0;
                        }
                        int chanId = rs.getInt(5);
                        if (rs.wasNull()) {
                            chanId = 0;
                        }
                        if (param_type == 1) {
                            LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences() :  stylesheet global params should be specified in the user defaults table ! UP_SS_USER_ATTS is corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 2) {
                            LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences() :  folder attribute specified for the theme stylesheet! UP_SS_USER_ATTS corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                            continue;
                        }
                        if (param_type == 3) {
                            tsup.setChannelAttributeValue(this.getStructId(structId, chanId), rs.getString(2), rs.getString(3));
                            continue;
                        }
                        LogService.log(LogService.ERROR, "RDBMUserLayoutStore::getThemeStylesheetUserPreferences() : unknown param type encountered! DB corrupt. (userId=" + Integer.toString(userId) + ", profileId=" + Integer.toString(profileId) + ", stylesheetId=" + Integer.toString(stylesheetId) + ", param_name=\"" + rs.getString(2) + "\", param_type=" + Integer.toString(param_type));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return tsup;
    }

    private String getName(Document descr) {
        NodeList names = descr.getElementsByTagName("name");
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getName() : no \"name\" element was found under the \"stylesheetdescription\" node!");
        return null;
    }

    private String getRootElementTextValue(Document descr, String elementName) {
        NodeList names = descr.getElementsByTagName(elementName);
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getRootElementTextValue() : no \"" + elementName + "\" element was found under the \"stylesheetdescription\" node!");
        return null;
    }

    private String getDescription(Document descr) {
        NodeList descriptions = descr.getElementsByTagName("description");
        Node description = null;
        for (int i = descriptions.getLength() - 1; i >= 0 && !(description = descriptions.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            description = null;
        }
        if (description != null) {
            return this.getTextChildNodeValue(description);
        }
        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getDescription() : no \"description\" element was found under the \"stylesheetdescription\" node!");
        return null;
    }

    private void populateParameterTable(Document descr, CoreStylesheetDescription csd) {
        NodeList parametersNodes = descr.getElementsByTagName("parameters");
        Node parametersNode = null;
        for (int i = parametersNodes.getLength() - 1; i >= 0 && !(parametersNode = parametersNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            parametersNode = null;
        }
        if (parametersNode != null) {
            NodeList children = parametersNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("parameter")) continue;
                Element parameter = (Element)children.item(i);
                String name = parameter.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = parameter.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::populateParameterTable() : adding a stylesheet parameter : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")");
                csd.addStylesheetParameter(name, defaultvalue, description);
            }
        }
    }

    private void populateFolderAttributeTable(Document descr, StructureStylesheetDescription cxsd) {
        NodeList parametersNodes = descr.getElementsByTagName("parameters");
        NodeList folderattributesNodes = descr.getElementsByTagName("folderattributes");
        Node folderattributesNode = null;
        for (int i = folderattributesNodes.getLength() - 1; i >= 0 && !(folderattributesNode = folderattributesNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            folderattributesNode = null;
        }
        if (folderattributesNode != null) {
            NodeList children = folderattributesNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("attribute")) continue;
                Element attribute = (Element)children.item(i);
                String name = attribute.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = attribute.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::populateFolderAttributeTable() : adding a stylesheet folder attribute : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")");
                cxsd.addFolderAttribute(name, defaultvalue, description);
            }
        }
    }

    private void populateChannelAttributeTable(Document descr, CoreXSLTStylesheetDescription cxsd) {
        NodeList channelattributesNodes = descr.getElementsByTagName("channelattributes");
        Node channelattributesNode = null;
        for (int i = channelattributesNodes.getLength() - 1; i >= 0 && !(channelattributesNode = channelattributesNodes.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            channelattributesNode = null;
        }
        if (channelattributesNode != null) {
            NodeList children = channelattributesNode.getChildNodes();
            for (int i = children.getLength() - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals("attribute")) continue;
                Element attribute = (Element)children.item(i);
                String name = attribute.getAttribute("name");
                String description = null;
                String defaultvalue = null;
                NodeList pchildren = attribute.getChildNodes();
                for (int j = pchildren.getLength() - 1; j >= 0; --j) {
                    Node pchild = pchildren.item(j);
                    if (pchild.getNodeType() != 1) continue;
                    if (pchild.getNodeName().equals("defaultvalue")) {
                        defaultvalue = this.getTextChildNodeValue(pchild);
                        continue;
                    }
                    if (!pchild.getNodeName().equals("description")) continue;
                    description = this.getTextChildNodeValue(pchild);
                }
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::populateChannelAttributeTable() : adding a stylesheet channel attribute : (\"" + name + "\",\"" + defaultvalue + "\",\"" + description + "\")");
                cxsd.addChannelAttribute(name, defaultvalue, description);
            }
        }
    }

    private Vector getVectorOfSimpleTextElementValues(Document descr, String elementName) {
        Vector<String> v = new Vector<String>();
        Element stylesheetdescriptionElement = (Element)descr.getElementsByTagName("stylesheetdescription").item(0);
        if (stylesheetdescriptionElement == null) {
            LogService.log(LogService.ERROR, "Could not obtain <stylesheetdescription> element");
            return null;
        }
        NodeList elements = stylesheetdescriptionElement.getElementsByTagName(elementName);
        for (int i = elements.getLength() - 1; i >= 0; --i) {
            v.add(this.getTextChildNodeValue(elements.item(i)));
        }
        return v;
    }

    private String getTextChildNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserBrowserMapping(IPerson person, String userAgent) throws Exception {
        int profileId;
        block13: {
            int userId = person.getID();
            profileId = 0;
            Connection con = RDBMServices.getConnection();
            try {
                Statement stmt = con.createStatement();
                try {
                    String sQuery = "SELECT PROFILE_ID, USER_ID FROM UP_USER_UA_MAP WHERE USER_ID=" + userId + " AND USER_AGENT='" + userAgent + "'";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserBrowserMapping(): " + sQuery);
                    ResultSet rs = stmt.executeQuery(sQuery);
                    try {
                        if (rs.next()) {
                            profileId = rs.getInt("PROFILE_ID");
                            if (rs.wasNull()) {
                                profileId = 0;
                            }
                            break block13;
                        }
                        int n = 0;
                        return n;
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                RDBMServices.releaseConnection(con);
            }
        }
        return profileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getUserLayout(IPerson person, UserProfile profile) throws Exception {
        int userId;
        int realUserId = userId = person.getID();
        Connection con = RDBMServices.getConnection();
        LocaleManager localeManager = profile.getLocaleManager();
        RDBMServices.setAutoCommit(con, false);
        try {
            Document doc = DocumentFactory.getNewDocument();
            Element root = doc.createElement("layout");
            Statement stmt = con.createStatement();
            Statement insertStmt = con.createStatement();
            try {
                HashMap<Integer, LayoutStructure> layoutStructure;
                int firstStructId;
                long startTime;
                block66: {
                    StringBuffer structChanIds;
                    String sql;
                    ResultSet rs;
                    int layoutId;
                    block64: {
                        block63: {
                            startTime = System.currentTimeMillis();
                            String subSelectString = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profile.getProfileId();
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + subSelectString);
                            layoutId = 0;
                            rs = stmt.executeQuery(subSelectString);
                            try {
                                if (rs.next()) {
                                    layoutId = rs.getInt(1);
                                    if (rs.wasNull()) {
                                        layoutId = 0;
                                    }
                                }
                            }
                            finally {
                                rs.close();
                            }
                            if (layoutId == 0) {
                                int nextStructId;
                                String sQuery = "SELECT USER_DFLT_USR_ID, USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=" + userId;
                                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                                rs = stmt.executeQuery(sQuery);
                                try {
                                    rs.next();
                                    userId = rs.getInt(1);
                                    layoutId = rs.getInt(2);
                                }
                                finally {
                                    rs.close();
                                }
                                sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + userId;
                                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                                rs = stmt.executeQuery(sQuery);
                                try {
                                    rs.next();
                                    nextStructId = rs.getInt(1);
                                }
                                finally {
                                    rs.close();
                                }
                                int realNextStructId = 0;
                                if (realUserId != userId) {
                                    sQuery = "SELECT NEXT_STRUCT_ID FROM UP_USER WHERE USER_ID=" + realUserId;
                                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                                    rs = stmt.executeQuery(sQuery);
                                    try {
                                        rs.next();
                                        realNextStructId = rs.getInt(1);
                                    }
                                    finally {
                                        rs.close();
                                    }
                                }
                                if (nextStructId > realNextStructId) {
                                    sQuery = "UPDATE UP_USER SET NEXT_STRUCT_ID=" + nextStructId + " WHERE USER_ID=" + realUserId;
                                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                                    stmt.executeUpdate(sQuery);
                                }
                                sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID=" + realUserId;
                                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                                stmt.executeUpdate(sQuery);
                                sQuery = " SELECT " + realUserId + ", PROFILE_ID, SS_ID, SS_TYPE, STRUCT_ID, PARAM_NAME, PARAM_TYPE, PARAM_VAL " + " FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId;
                                rs = stmt.executeQuery(sQuery);
                                while (rs.next()) {
                                    String Insert = "INSERT INTO UP_SS_USER_ATTS (USER_ID, PROFILE_ID, SS_ID, SS_TYPE, STRUCT_ID, PARAM_NAME, PARAM_TYPE, PARAM_VAL) VALUES(" + realUserId + "," + rs.getInt("PROFILE_ID") + "," + rs.getInt("SS_ID") + "," + rs.getInt("SS_TYPE") + "," + rs.getInt("STRUCT_ID") + "," + "'" + rs.getString("PARAM_NAME") + "'," + rs.getInt("PARAM_TYPE") + "," + "'" + rs.getString("PARAM_VAL") + "')";
                                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + Insert);
                                    insertStmt.executeUpdate(Insert);
                                }
                                if (rs != null) {
                                    rs.close();
                                }
                                RDBMServices.commit(con);
                            }
                            firstStructId = -1;
                            String sQuery = "SELECT INIT_STRUCT_ID FROM UP_USER_LAYOUT WHERE USER_ID=" + userId + " AND LAYOUT_ID = " + layoutId;
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sQuery);
                            rs = stmt.executeQuery(sQuery);
                            try {
                                if (rs.next()) {
                                    firstStructId = rs.getInt(1);
                                    break block63;
                                }
                                throw new Exception("RDBMUserLayoutStore::getUserLayout(): No INIT_STRUCT_ID in UP_USER_LAYOUT for " + userId + " and LAYOUT_ID " + layoutId);
                            }
                            finally {
                                rs.close();
                            }
                        }
                        sql = localeAware ? "SELECT ULS.STRUCT_ID,ULS.NEXT_STRUCT_ID,ULS.CHLD_STRUCT_ID,ULS.CHAN_ID,ULS.NAME,ULS.TYPE,ULS.HIDDEN,ULS.UNREMOVABLE,ULS.IMMUTABLE" : "SELECT ULS.STRUCT_ID,ULS.NEXT_STRUCT_ID,ULS.CHLD_STRUCT_ID,ULS.CHAN_ID,ULS.NAME,ULS.TYPE,ULS.HIDDEN,ULS.UNREMOVABLE,ULS.IMMUTABLE";
                        sql = RDBMServices.supportsOuterJoins ? sql + ",USP.STRUCT_PARM_NM,USP.STRUCT_PARM_VAL FROM " + RDBMServices.joinQuery.getQuery("layout") : sql + " FROM UP_LAYOUT_STRUCT ULS WHERE ";
                        sql = sql + " ULS.USER_ID=" + userId + " AND ULS.LAYOUT_ID=" + layoutId + " ORDER BY ULS.STRUCT_ID";
                        layoutStructure = new HashMap<Integer, LayoutStructure>();
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sql);
                        structChanIds = new StringBuffer();
                        rs = stmt.executeQuery(sql);
                        try {
                            int lastStructId = 0;
                            LayoutStructure ls = null;
                            String sepChar = "";
                            if (!rs.next()) break block64;
                            int structId = rs.getInt(1);
                            if (rs.wasNull()) {
                                structId = 0;
                            }
                            while (true) {
                                int value_index;
                                int name_index;
                                if (DEBUG > 1) {
                                    System.err.println("Found layout structureID " + structId);
                                }
                                int nextId = rs.getInt(2);
                                if (rs.wasNull()) {
                                    nextId = 0;
                                }
                                int childId = rs.getInt(3);
                                if (rs.wasNull()) {
                                    childId = 0;
                                }
                                int chanId = rs.getInt(4);
                                if (rs.wasNull()) {
                                    chanId = 0;
                                }
                                String temp5 = rs.getString(5);
                                String temp6 = rs.getString(6);
                                if (localeAware) {
                                    ls = new LayoutStructure(structId, nextId, childId, chanId, rs.getString(7), rs.getString(8), rs.getString(9), localeManager.getLocales()[0].toString());
                                    name_index = 10;
                                    value_index = 11;
                                } else {
                                    ls = new LayoutStructure(structId, nextId, childId, chanId, rs.getString(7), rs.getString(8), rs.getString(9));
                                    name_index = 10;
                                    value_index = 11;
                                }
                                layoutStructure.put(new Integer(structId), ls);
                                lastStructId = structId;
                                if (!ls.isChannel()) {
                                    ls.addFolderData(temp5, temp6);
                                }
                                if (RDBMServices.supportsOuterJoins) {
                                    do {
                                        String name = rs.getString(name_index);
                                        String value = rs.getString(value_index);
                                        if (name != null) {
                                            ls.addParameter(name, value);
                                        }
                                        if (!rs.next()) {
                                            break block64;
                                        }
                                        structId = rs.getInt(1);
                                        if (!rs.wasNull()) continue;
                                        structId = 0;
                                    } while (structId == lastStructId);
                                    continue;
                                }
                                if (ls.isChannel()) {
                                    structChanIds.append(sepChar + ls.chanId);
                                    sepChar = ",";
                                }
                                if (rs.next()) {
                                    structId = rs.getInt(1);
                                    if (!rs.wasNull()) continue;
                                    structId = 0;
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    if (!RDBMServices.supportsOuterJoins) {
                        sql = "SELECT STRUCT_ID FROM UP_LAYOUT_STRUCT WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND CHAN_ID IN (" + structChanIds.toString() + ") ORDER BY STRUCT_ID";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sql);
                        StringBuffer structIdsSB = new StringBuffer("");
                        String sep = "";
                        rs = stmt.executeQuery(sql);
                        try {
                            while (rs.next()) {
                                structIdsSB.append(sep + rs.getString(1));
                                sep = ",";
                            }
                        }
                        finally {
                            rs.close();
                        }
                        sql = "SELECT STRUCT_ID, STRUCT_PARM_NM,STRUCT_PARM_VAL FROM UP_LAYOUT_PARAM WHERE USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId + " AND STRUCT_ID IN (" + structIdsSB.toString() + ") ORDER BY STRUCT_ID";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): " + sql);
                        rs = stmt.executeQuery(sql);
                        try {
                            if (!rs.next()) break block66;
                            int structId = rs.getInt(1);
                            while (true) {
                                LayoutStructure ls = (LayoutStructure)layoutStructure.get(new Integer(structId));
                                int lastStructId = structId;
                                do {
                                    ls.addParameter(rs.getString(2), rs.getString(3));
                                    if (rs.next()) continue;
                                    break block66;
                                } while ((structId = rs.getInt(1)) == lastStructId);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                }
                if (layoutStructure.size() > 0) {
                    this.createLayout(layoutStructure, doc, root, firstStructId);
                    layoutStructure.clear();
                    long stopTime = System.currentTimeMillis();
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to create");
                    doc.appendChild(root);
                    if (DEBUG > 1) {
                        System.err.println("--> created document");
                        RDBMUserLayoutStore.dumpDoc(doc, "");
                        System.err.println("<--");
                    }
                }
            }
            finally {
                stmt.close();
                insertStmt.close();
            }
            Document document = doc;
            return document;
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public UserProfile getUserProfileById(IPerson person, int profileId) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT USER_ID, PROFILE_ID, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserProfileById(): " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    if (rs.next()) {
                        String temp3 = rs.getString(3);
                        String temp4 = rs.getString(4);
                        int layoutId = rs.getInt(5);
                        if (rs.wasNull()) {
                            layoutId = 0;
                        }
                        int structSsId = rs.getInt(6);
                        if (rs.wasNull()) {
                            structSsId = 0;
                        }
                        int themeSsId = rs.getInt(7);
                        if (rs.wasNull()) {
                            themeSsId = 0;
                        }
                        UserProfile userProfile = new UserProfile(profileId, temp3, temp4, layoutId, structSsId, themeSsId);
                        return userProfile;
                    }
                    throw new Exception("Unable to find User Profile for user " + userId + " and profile " + profileId);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserProfileList(IPerson person) throws Exception {
        int userId = person.getID();
        Hashtable<Integer, UserProfile> pv = new Hashtable<Integer, UserProfile>();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT USER_ID, PROFILE_ID, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::getUserProfileList(): " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        int layoutId = rs.getInt(5);
                        if (rs.wasNull()) {
                            layoutId = 0;
                        }
                        int structSsId = rs.getInt(6);
                        if (rs.wasNull()) {
                            structSsId = 0;
                        }
                        int themeSsId = rs.getInt(7);
                        if (rs.wasNull()) {
                            themeSsId = 0;
                        }
                        UserProfile upl = new UserProfile(rs.getInt(2), rs.getString(3), rs.getString(4), layoutId, structSsId, themeSsId);
                        pv.put(new Integer(upl.getProfileId()), upl);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
        return pv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureChannelAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=3 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureChannelAttribute() : " + sQuery);
            stmt.executeQuery(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=3 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureChannelAttribute() : " + sQuery);
            stmt.executeQuery(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureFolderAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=2 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureFolderAttribute() : " + sQuery);
            stmt.executeQuery(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=2 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureFolderAttribute() : " + sQuery);
            stmt.executeQuery(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStructureStylesheetDescription(int stylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "SELECT SS_ID FROM UP_SS_THEME WHERE STRUCT_SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        this.removeThemeStylesheetDescription(rs.getInt("SS_ID"));
                    }
                }
                finally {
                    rs.close();
                }
                sQuery = "DELETE FROM UP_SS_STRUCT WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStructureStylesheetParam(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId + " AND TYPE=1 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureStylesheetParam() : " + sQuery);
            stmt.executeQuery(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_TYPE=1 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeStructureStylesheetParam() : " + sQuery);
            stmt.executeQuery(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThemeChannelAttribute(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId + " AND TYPE=3 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeChannelAttribute() : " + sQuery);
            stmt.executeQuery(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_TYPE=3 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery);
            stmt.executeQuery(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThemeStylesheetDescription(int stylesheetId) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "DELETE FROM UP_SS_THEME WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "SELECT USER_ID,PROFILE_ID FROM UP_USER_PROFILE WHERE THEME_SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery);
                ResultSet rs = stmt.executeQuery(sQuery);
                try {
                    while (rs.next()) {
                        this.deleteUserProfile(rs.getInt("USER_ID"), rs.getInt("PROFILE_ID"));
                    }
                }
                finally {
                    rs.close();
                }
                sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "DELETE FROM UP_SS_USER_ATTS WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThemeStylesheetParam(int stylesheetId, String pName, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        try {
            String sQuery = "DELETE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId + " AND TYPE=1 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery);
            stmt.executeQuery(sQuery);
            sQuery = "DELETE FROM UP_SS_USER_PARM WHERE SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_TYPE=1 AND PARAM_NAME='" + pName + "'";
            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::removeThemeStylesheetParam() : " + sQuery);
            stmt.executeQuery(sQuery);
        }
        finally {
            stmt.close();
        }
    }

    protected final int saveStructure(Node node, RDBMServices.PreparedStatement structStmt, RDBMServices.PreparedStatement parmStmt) throws SQLException {
        if (node == null || node.getNodeName().equals("parameter")) {
            return 0;
        }
        Element structure = (Element)node;
        int saveStructId = Integer.parseInt(structure.getAttribute("ID").substring(1));
        int nextStructId = 0;
        int childStructId = 0;
        if (DEBUG > 0) {
            LogService.log(LogService.DEBUG, "-->" + node.getNodeName() + "@" + saveStructId);
        }
        if (node.hasChildNodes()) {
            childStructId = this.saveStructure(node.getFirstChild(), structStmt, parmStmt);
        }
        nextStructId = this.saveStructure(node.getNextSibling(), structStmt, parmStmt);
        structStmt.clearParameters();
        structStmt.setInt(1, saveStructId);
        structStmt.setInt(2, nextStructId);
        structStmt.setInt(3, childStructId);
        String externalId = structure.getAttribute("external_id");
        if (externalId != null && externalId.trim().length() > 0) {
            Integer eID = new Integer(externalId);
            structStmt.setInt(4, eID);
        } else {
            structStmt.setNull(4, 2);
        }
        if (node.getNodeName().equals("channel")) {
            int chanId = Integer.parseInt(node.getAttributes().getNamedItem("chanID").getNodeValue());
            structStmt.setInt(5, chanId);
            structStmt.setNull(6, 12);
        } else {
            structStmt.setNull(5, 2);
            structStmt.setString(6, structure.getAttribute("name"));
        }
        String structType = structure.getAttribute("type");
        structStmt.setString(7, structType);
        structStmt.setString(8, RDBMServices.dbFlag(RDBMUserLayoutStore.xmlBool(structure.getAttribute("hidden"))));
        structStmt.setString(9, RDBMServices.dbFlag(RDBMUserLayoutStore.xmlBool(structure.getAttribute("immutable"))));
        structStmt.setString(10, RDBMServices.dbFlag(RDBMUserLayoutStore.xmlBool(structure.getAttribute("unremovable"))));
        if (localeAware) {
            structStmt.setString(11, RDBMServices.dbFlag(RDBMUserLayoutStore.xmlBool(structure.getAttribute("locale"))));
        }
        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::saveStructure(): " + structStmt);
        structStmt.executeUpdate();
        NodeList parameters = node.getChildNodes();
        if (parameters != null) {
            for (int i = 0; i < parameters.getLength(); ++i) {
                if (!parameters.item(i).getNodeName().equals("parameter")) continue;
                Element parmElement = (Element)parameters.item(i);
                NamedNodeMap nm = parmElement.getAttributes();
                String nodeName = nm.getNamedItem("name").getNodeValue();
                String nodeValue = nm.getNamedItem("value").getNodeValue();
                Node override = nm.getNamedItem("override");
                if (DEBUG > 0) {
                    System.err.println(nodeName + "=" + nodeValue);
                }
                if (override == null || !override.getNodeValue().equals("yes")) {
                    if (DEBUG <= 0) continue;
                    System.err.println("Not saving channel defined parameter value " + nodeName);
                    continue;
                }
                if (nodeValue == null || nodeValue.length() <= 0) continue;
                parmStmt.clearParameters();
                parmStmt.setInt(1, saveStructId);
                parmStmt.setString(2, nodeName);
                parmStmt.setString(3, nodeValue);
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::saveStructure(): " + parmStmt);
                parmStmt.executeUpdate();
            }
        }
        return saveStructId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStructureStylesheetUserPreferences(IPerson person, int profileId, StructureStylesheetUserPreferences ssup) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            int stylesheetId = ssup.getStylesheetId();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                ResultSet rs;
                String sQuery;
                String pValue;
                String pName;
                Enumeration attre;
                Enumeration e = ssup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName2 = (String)e.nextElement();
                    String sQuery2 = "SELECT PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_NAME='" + pName2 + "'";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery2);
                    ResultSet rs2 = stmt.executeQuery(sQuery2);
                    sQuery2 = rs2.next() ? "UPDATE UP_SS_USER_PARM SET PARAM_VAL='" + ssup.getParameterValue(pName2) + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND PARAM_NAME='" + pName2 + "'" : "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1,'" + pName2 + "','" + ssup.getParameterValue(pName2) + "')";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery2);
                    stmt.executeUpdate(sQuery2);
                }
                e = ssup.getFolders();
                while (e.hasMoreElements()) {
                    String folderId = (String)e.nextElement();
                    attre = ssup.getFolderAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedFolderAttributeValue(folderId, pName);
                        if (pValue == null) continue;
                        sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + folderId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=2";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + folderId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=2" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1," + folderId.substring(1) + ",'" + pName + "',2,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                e = ssup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    attre = ssup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        pName = (String)attre.nextElement();
                        pValue = ssup.getDefinedChannelAttributeValue(channelId, pName);
                        if (pValue == null) continue;
                        sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=1 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",1," + channelId.substring(1) + ",'" + pName + "',3,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setStructureStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThemeStylesheetUserPreferences(IPerson person, int profileId, ThemeStylesheetUserPreferences tsup) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            int stylesheetId = tsup.getStylesheetId();
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                Enumeration e = tsup.getParameterValues().keys();
                while (e.hasMoreElements()) {
                    String pName = (String)e.nextElement();
                    String sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_PARM WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_NAME='" + pName + "'";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                    ResultSet rs = stmt.executeQuery(sQuery);
                    sQuery = rs.next() ? "UPDATE UP_SS_USER_PARM SET PARAM_VAL='" + tsup.getParameterValue(pName) + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND PARAM_NAME='" + pName + "'" : "INSERT INTO UP_SS_USER_PARM (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,PARAM_NAME,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",2,'" + pName + "','" + tsup.getParameterValue(pName) + "')";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = tsup.getChannels();
                while (e.hasMoreElements()) {
                    String channelId = (String)e.nextElement();
                    Enumeration attre = tsup.getChannelAttributeNames();
                    while (attre.hasMoreElements()) {
                        String pName = (String)attre.nextElement();
                        String pValue = tsup.getDefinedChannelAttributeValue(channelId, pName);
                        if (pValue == null) continue;
                        String sQuery = "SELECT PARAM_VAL FROM UP_SS_USER_ATTS WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                        ResultSet rs = stmt.executeQuery(sQuery);
                        sQuery = rs.next() ? "UPDATE UP_SS_USER_ATTS SET PARAM_VAL='" + pValue + "' WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId + " AND SS_ID=" + stylesheetId + " AND SS_TYPE=2 AND STRUCT_ID=" + channelId.substring(1) + " AND PARAM_NAME='" + pName + "' AND PARAM_TYPE=3" : "INSERT INTO UP_SS_USER_ATTS (USER_ID,PROFILE_ID,SS_ID,SS_TYPE,STRUCT_ID,PARAM_NAME,PARAM_TYPE,PARAM_VAL) VALUES (" + userId + "," + profileId + "," + stylesheetId + ",2," + channelId.substring(1) + ",'" + pName + "',3,'" + pValue + "')";
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setThemeStylesheetUserPreferences(): " + sQuery);
                        stmt.executeUpdate(sQuery);
                    }
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserBrowserMapping(IPerson person, String userAgent, int profileId) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String sQuery = "DELETE FROM UP_USER_UA_MAP WHERE USER_ID=" + userId + " AND USER_AGENT='" + userAgent + "'";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserBrowserMapping(): " + sQuery);
                stmt.executeUpdate(sQuery);
                sQuery = "INSERT INTO UP_USER_UA_MAP (USER_ID,USER_AGENT,PROFILE_ID) VALUES (" + userId + ",'" + userAgent + "'," + profileId + ")";
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserBrowserMapping(): " + sQuery);
                stmt.executeUpdate(sQuery);
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserLayout(IPerson person, UserProfile profile, Document layoutXML, boolean channelsAdded) throws Exception {
        int userId = person.getID();
        int profileId = profile.getProfileId();
        int layoutId = 0;
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                long startTime = System.currentTimeMillis();
                String query = "SELECT LAYOUT_ID FROM UP_USER_PROFILE WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + query);
                ResultSet rs = stmt.executeQuery(query);
                try {
                    rs.next();
                    layoutId = rs.getInt(1);
                    if (rs.wasNull()) {
                        layoutId = 0;
                    }
                }
                finally {
                    rs.close();
                }
                boolean firstLayout = false;
                if (layoutId == 0) {
                    layoutId = 1;
                    firstLayout = true;
                }
                String selectString = "USER_ID=" + userId + " AND LAYOUT_ID=" + layoutId;
                String sSql = "DELETE FROM UP_LAYOUT_PARAM WHERE " + selectString;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sSql);
                stmt.executeUpdate(sSql);
                sSql = "DELETE FROM UP_LAYOUT_STRUCT WHERE " + selectString;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sSql);
                stmt.executeUpdate(sSql);
                if (DEBUG > 1) {
                    System.err.println("--> saving document");
                    RDBMUserLayoutStore.dumpDoc(layoutXML.getFirstChild().getFirstChild(), "");
                    System.err.println("<--");
                }
                RDBMServices.PreparedStatement structStmt = new RDBMServices.PreparedStatement(con, "INSERT INTO UP_LAYOUT_STRUCT (USER_ID, LAYOUT_ID, STRUCT_ID, NEXT_STRUCT_ID, CHLD_STRUCT_ID,EXTERNAL_ID,CHAN_ID,NAME,TYPE,HIDDEN,IMMUTABLE,UNREMOVABLE) VALUES (" + userId + "," + layoutId + ",?,?,?,?,?,?,?,?,?,?)");
                try {
                    RDBMServices.PreparedStatement parmStmt = new RDBMServices.PreparedStatement(con, "INSERT INTO UP_LAYOUT_PARAM (USER_ID, LAYOUT_ID, STRUCT_ID, STRUCT_PARM_NM, STRUCT_PARM_VAL) VALUES (" + userId + "," + layoutId + ",?,?,?)");
                    try {
                        int firstStructId = this.saveStructure(layoutXML.getFirstChild().getFirstChild(), structStmt, parmStmt);
                        sSql = "UPDATE UP_USER_LAYOUT SET INIT_STRUCT_ID=" + firstStructId + " WHERE " + selectString;
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sSql);
                        stmt.executeUpdate(sSql);
                        if (channelsAdded) {
                            sSql = "UPDATE UP_USER SET LST_CHAN_UPDT_DT=" + RDBMServices.sqlTimeStamp() + " WHERE USER_ID=" + userId;
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sSql);
                            stmt.executeUpdate(sSql);
                        }
                        if (firstLayout) {
                            String sQuery = "SELECT USER_DFLT_USR_ID,USER_DFLT_LAY_ID FROM UP_USER WHERE USER_ID=" + userId;
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sQuery);
                            rs = stmt.executeQuery(sQuery);
                            try {
                                rs.next();
                                int defaultUserId = rs.getInt(1);
                                int defaultLayoutId = rs.getInt(2);
                            }
                            finally {
                                rs.close();
                            }
                            sQuery = "UPDATE UP_USER_PROFILE SET LAYOUT_ID=1 WHERE USER_ID=" + userId + " AND PROFILE_ID=" + profileId;
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): " + sQuery);
                            stmt.executeUpdate(sQuery);
                        }
                        long stopTime = System.currentTimeMillis();
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::setUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to save");
                    }
                    finally {
                        parmStmt.close();
                    }
                }
                finally {
                    structStmt.close();
                }
            }
            finally {
                stmt.close();
            }
            RDBMServices.commit(con);
        }
        catch (Exception e) {
            RDBMServices.rollback(con);
            throw e;
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructureStylesheetDescription(StructureStylesheetDescription ssd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int stylesheetId = ssd.getId();
                String sQuery = "UPDATE UP_SS_STRUCT SET SS_NAME='" + ssd.getStylesheetName() + "',SS_URI='" + ssd.getStylesheetURI() + "',SS_DESCRIPTION_URI='" + ssd.getStylesheetDescriptionURI() + "',SS_DESCRIPTION_TEXT='" + ssd.getStylesheetWordDescription() + "' WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                HashSet<String> oparams = new HashSet<String>();
                HashSet<String> ofattrs = new HashSet<String>();
                HashSet<String> ocattrs = new HashSet<String>();
                sQuery = "SELECT PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE FROM UP_SS_STRUCT_PAR WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery);
                Statement stmtOld = con.createStatement();
                ResultSet rsOld = stmtOld.executeQuery(sQuery);
                try {
                    while (rsOld.next()) {
                        int type = rsOld.getInt("TYPE");
                        if (type == 1) {
                            pName = rsOld.getString("PARAM_NAME");
                            oparams.add(pName);
                            if (!ssd.containsParameterName(pName)) {
                                this.removeStructureStylesheetParam(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getStylesheetParameterDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getStylesheetParameterWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=1";
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery);
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 2) {
                            pName = rsOld.getString("PARAM_NAME");
                            ofattrs.add(pName);
                            if (!ssd.containsFolderAttribute(pName)) {
                                this.removeStructureFolderAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getFolderAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getFolderAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "'AND TYPE=2";
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery);
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 3) {
                            pName = rsOld.getString("PARAM_NAME");
                            ocattrs.add(pName);
                            if (!ssd.containsChannelAttribute(pName)) {
                                this.removeStructureChannelAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_STRUCT_PAR SET PARAM_DEFAULT_VAL='" + ssd.getChannelAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + ssd.getChannelAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=3";
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : " + sQuery);
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ").");
                    }
                }
                finally {
                    rsOld.close();
                    stmtOld.close();
                }
                Enumeration e = ssd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (oparams.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getStylesheetParameterDefaultValue(pName) + "','" + ssd.getStylesheetParameterWordDescription(pName) + "',1)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getFolderAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ofattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getFolderAttributeDefaultValue(pName) + "','" + ssd.getFolderAttributeWordDescription(pName) + "',2)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = ssd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ocattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_STRUCT_PAR (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + ssd.getChannelAttributeDefaultValue(pName) + "','" + ssd.getChannelAttributeWordDescription(pName) + "',3)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateStructureStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThemeStylesheetDescription(ThemeStylesheetDescription tsd) throws Exception {
        Connection con = RDBMServices.getConnection();
        try {
            RDBMServices.setAutoCommit(con, false);
            Statement stmt = con.createStatement();
            try {
                String pName;
                int stylesheetId = tsd.getId();
                String sQuery = "UPDATE UP_SS_THEME SET SS_NAME='" + tsd.getStylesheetName() + "',SS_URI='" + tsd.getStylesheetURI() + "',SS_DESCRIPTION_URI='" + tsd.getStylesheetDescriptionURI() + "',SS_DESCRIPTION_TEXT='" + tsd.getStylesheetWordDescription() + "',SAMPLE_ICON_URI='" + tsd.getSampleIconURI() + "',SAMPLE_URI='" + tsd.getSamplePictureURI() + "',MIME_TYPE='" + tsd.getMimeType() + "',DEVICE_TYPE='" + tsd.getDeviceType() + "',SERIALIZER_NAME='" + tsd.getSerializerName() + "',UP_MODULE_CLASS='" + tsd.getCustomUserPreferencesManagerClass() + "' WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery);
                stmt.executeUpdate(sQuery);
                HashSet<String> oparams = new HashSet<String>();
                HashSet<String> ocattrs = new HashSet<String>();
                sQuery = "SELECT PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE FROM UP_SS_THEME_PARM WHERE SS_ID=" + stylesheetId;
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery);
                Statement stmtOld = con.createStatement();
                ResultSet rsOld = stmtOld.executeQuery(sQuery);
                try {
                    while (rsOld.next()) {
                        int type = rsOld.getInt("TYPE");
                        if (type == 1) {
                            pName = rsOld.getString("PARAM_NAME");
                            oparams.add(pName);
                            if (!tsd.containsParameterName(pName)) {
                                this.removeThemeStylesheetParam(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_THEME_PARM SET PARAM_DEFAULT_VAL='" + tsd.getStylesheetParameterDefaultValue(pName) + "',PARAM_DESCRIPT='" + tsd.getStylesheetParameterWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=1";
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery);
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        if (type == 2) {
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : encountered a folder attribute specified for a theme stylesheet ! DB is corrupt. (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ").");
                            continue;
                        }
                        if (type == 3) {
                            pName = rsOld.getString("PARAM_NAME");
                            ocattrs.add(pName);
                            if (!tsd.containsChannelAttribute(pName)) {
                                this.removeThemeChannelAttribute(stylesheetId, pName, con);
                                continue;
                            }
                            sQuery = "UPDATE UP_SS_THEME_PARM SET PARAM_DEFAULT_VAL='" + tsd.getChannelAttributeDefaultValue(pName) + "',PARAM_DESCRIPT='" + tsd.getChannelAttributeWordDescription(pName) + "' WHERE SS_ID=" + stylesheetId + " AND PARAM_NAME='" + pName + "' AND TYPE=3";
                            LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : " + sQuery);
                            stmt.executeUpdate(sQuery);
                            continue;
                        }
                        LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription() : encountered param of unknown type! (stylesheetId=" + stylesheetId + " param_name=\"" + rsOld.getString("PARAM_NAME") + "\" type=" + type + ").");
                    }
                }
                finally {
                    rsOld.close();
                    stmtOld.close();
                }
                Enumeration e = tsd.getStylesheetParameterNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (oparams.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + tsd.getStylesheetParameterDefaultValue(pName) + "','" + tsd.getStylesheetParameterWordDescription(pName) + "',1)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                e = tsd.getChannelAttributeNames();
                while (e.hasMoreElements()) {
                    pName = (String)e.nextElement();
                    if (ocattrs.contains(pName)) continue;
                    sQuery = "INSERT INTO UP_SS_THEME_PARM (SS_ID,PARAM_NAME,PARAM_DEFAULT_VAL,PARAM_DESCRIPT,TYPE) VALUES (" + stylesheetId + ",'" + pName + "','" + tsd.getChannelAttributeDefaultValue(pName) + "','" + tsd.getChannelAttributeWordDescription(pName) + "',3)";
                    LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateThemeStylesheetDescription(): " + sQuery);
                    stmt.executeUpdate(sQuery);
                }
                RDBMServices.commit(con);
            }
            catch (Exception e) {
                RDBMServices.rollback(con);
                throw e;
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserProfile(IPerson person, UserProfile profile) throws Exception {
        int userId = person.getID();
        Connection con = RDBMServices.getConnection();
        try {
            Statement stmt = con.createStatement();
            try {
                String sQuery = "UPDATE UP_USER_PROFILE SET LAYOUT_ID=" + profile.getLayoutId() + ", THEME_SS_ID=" + profile.getThemeStylesheetId() + ", STRUCTURE_SS_ID=" + profile.getStructureStylesheetId() + ", DESCRIPTION='" + profile.getProfileDescription() + "', PROFILE_NAME='" + profile.getProfileName() + "' WHERE USER_ID = " + userId + " AND PROFILE_ID=" + profile.getProfileId();
                LogService.log(LogService.DEBUG, "RDBMUserLayoutStore::updateUserProfile() : " + sQuery);
                stmt.executeUpdate(sQuery);
            }
            finally {
                stmt.close();
            }
        }
        finally {
            RDBMServices.releaseConnection(con);
        }
    }

    public void setSystemBrowserMapping(String userAgent, int profileId) throws Exception {
        this.setUserBrowserMapping(this.systemUser, userAgent, profileId);
    }

    private int getSystemBrowserMapping(String userAgent) throws Exception {
        return this.getUserBrowserMapping(this.systemUser, userAgent);
    }

    public UserProfile getUserProfile(IPerson person, String userAgent) throws Exception {
        int profileId = this.getUserBrowserMapping(person, userAgent);
        if (profileId == 0) {
            return null;
        }
        return this.getUserProfileById(person, profileId);
    }

    public UserProfile getSystemProfile(String userAgent) throws Exception {
        int profileId = this.getSystemBrowserMapping(userAgent);
        if (profileId == 0) {
            return null;
        }
        UserProfile up = this.getUserProfileById(this.systemUser, profileId);
        up.setSystemProfile(true);
        return up;
    }

    public UserProfile getSystemProfileById(int profileId) throws Exception {
        UserProfile up = this.getUserProfileById(this.systemUser, profileId);
        up.setSystemProfile(true);
        return up;
    }

    public Hashtable getSystemProfileList() throws Exception {
        Hashtable pl = this.getUserProfileList(this.systemUser);
        Enumeration e = pl.elements();
        while (e.hasMoreElements()) {
            UserProfile up = (UserProfile)e.nextElement();
            up.setSystemProfile(true);
        }
        return pl;
    }

    public void updateSystemProfile(UserProfile profile) throws Exception {
        this.updateUserProfile(this.systemUser, profile);
    }

    public UserProfile addSystemProfile(UserProfile profile) throws Exception {
        return this.addUserProfile(this.systemUser, profile);
    }

    public void deleteSystemProfile(int profileId) throws Exception {
        this.deleteUserProfile(this.systemUser, profileId);
    }

    public UserPreferences getUserPreferences(IPerson person, int profileId) throws Exception {
        UserPreferences up = null;
        UserProfile profile = this.getUserProfileById(person, profileId);
        if (profile != null) {
            up = this.getUserPreferences(person, profile);
        }
        return up;
    }

    public UserPreferences getUserPreferences(IPerson person, UserProfile profile) throws Exception {
        int profileId = profile.getProfileId();
        UserPreferences up = new UserPreferences(profile);
        up.setStructureStylesheetUserPreferences(this.getStructureStylesheetUserPreferences(person, profileId, profile.getStructureStylesheetId()));
        up.setThemeStylesheetUserPreferences(this.getThemeStylesheetUserPreferences(person, profileId, profile.getThemeStylesheetId()));
        return up;
    }

    public void putUserPreferences(IPerson person, UserPreferences up) throws Exception {
        UserProfile profile = up.getProfile();
        this.updateUserProfile(person, profile);
        this.setStructureStylesheetUserPreferences(person, profile.getProfileId(), up.getStructureStylesheetUserPreferences());
        this.setThemeStylesheetUserPreferences(person, profile.getProfileId(), up.getThemeStylesheetUserPreferences());
    }

    private class SystemUser
    implements IPerson {
        private SystemUser() {
        }

        public void setID(int sID) {
        }

        public int getID() {
            return 0;
        }

        public void setFullName(String sFullName) {
        }

        public String getFullName() {
            return "uPortal System Account";
        }

        public Object getAttribute(String key) {
            return null;
        }

        public void setAttribute(String key, Object value) {
        }

        public Enumeration getAttributes() {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public boolean isGuest() {
            return false;
        }

        public ISecurityContext getSecurityContext() {
            return null;
        }

        public void setSecurityContext(ISecurityContext context) {
        }

        public EntityIdentifier getEntityIdentifier() {
            return null;
        }
    }

    protected final class LayoutStructure {
        int structId;
        int nextId;
        int childId;
        int chanId;
        String name;
        String type;
        boolean hidden;
        boolean unremovable;
        boolean immutable;
        ArrayList parameters;
        String locale;

        public LayoutStructure(int structId, int nextId, int childId, int chanId, String hidden, String unremovable, String immutable) {
            this.nextId = nextId;
            this.childId = childId;
            this.chanId = chanId;
            this.structId = structId;
            this.hidden = RDBMServices.dbFlag(hidden);
            this.immutable = RDBMServices.dbFlag(immutable);
            this.unremovable = RDBMServices.dbFlag(unremovable);
            if (DEBUG > 1) {
                System.err.println("New layout: id=" + structId + ", next=" + nextId + ", child=" + childId + ", chan=" + chanId);
            }
        }

        public LayoutStructure(int structId, int nextId, int childId, int chanId, String hidden, String unremovable, String immutable, String locale) {
            this.nextId = nextId;
            this.childId = childId;
            this.chanId = chanId;
            this.structId = structId;
            this.hidden = RDBMServices.dbFlag(hidden);
            this.immutable = RDBMServices.dbFlag(immutable);
            this.unremovable = RDBMServices.dbFlag(unremovable);
            this.locale = locale;
            if (DEBUG > 1) {
                System.err.println("New layout: id=" + structId + ", next=" + nextId + ", child=" + childId + ", chan=" + chanId);
            }
        }

        public void addFolderData(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public boolean isChannel() {
            return this.chanId != 0;
        }

        public void addParameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new ArrayList(5);
            }
            this.parameters.add(new StructureParameter(name, value));
        }

        public int getNextId() {
            return this.nextId;
        }

        public int getChildId() {
            return this.childId;
        }

        public int getChanId() {
            return this.chanId;
        }

        public Element getStructureDocument(Document doc) throws Exception {
            Element structure = null;
            if (this.isChannel()) {
                ChannelDefinition channelDef = RDBMUserLayoutStore.this.crs.getChannelDefinition(this.chanId);
                if (channelDef != null && RDBMUserLayoutStore.channelApproved(channelDef.getApprovalDate())) {
                    if (localeAware) {
                        channelDef.setLocale(this.locale);
                    }
                    structure = channelDef.getDocument(doc, RDBMUserLayoutStore.channelPrefix + this.structId);
                } else {
                    ChannelDefinition cd = new ChannelDefinition(this.chanId);
                    cd.setTitle("Missing channel");
                    cd.setName("Missing channel");
                    cd.setTimeout(20000);
                    String missingChannel = "Unknown";
                    if (channelDef != null) {
                        missingChannel = channelDef.getName();
                    }
                    structure = cd.getDocument(doc, RDBMUserLayoutStore.channelPrefix + this.structId, "The '" + missingChannel + "' channel is no longer available. Please remove it from your layout.", 7);
                }
            } else {
                structure = doc.createElement("folder");
                ((IPortalDocument)doc).putIdentifier(RDBMUserLayoutStore.folderPrefix + this.structId, structure);
                structure.setAttribute("ID", RDBMUserLayoutStore.folderPrefix + this.structId);
                structure.setAttribute("name", this.name);
                structure.setAttribute("type", this.type != null ? this.type : "regular");
            }
            structure.setAttribute("hidden", this.hidden ? "true" : "false");
            structure.setAttribute("immutable", this.immutable ? "true" : "false");
            structure.setAttribute("unremovable", this.unremovable ? "true" : "false");
            if (localeAware) {
                structure.setAttribute("locale", this.locale);
            }
            if (this.parameters != null) {
                for (int i = 0; i < this.parameters.size(); ++i) {
                    StructureParameter sp = (StructureParameter)this.parameters.get(i);
                    if (!this.isChannel()) {
                        structure.setAttribute(sp.name, sp.value);
                        continue;
                    }
                    NodeList nodeListParameters = structure.getElementsByTagName("parameter");
                    for (int j = 0; j < nodeListParameters.getLength(); ++j) {
                        Node override;
                        Element parmElement = (Element)nodeListParameters.item(j);
                        NamedNodeMap nm = parmElement.getAttributes();
                        String nodeName = nm.getNamedItem("name").getNodeValue();
                        if (!nodeName.equals(sp.name) || (override = nm.getNamedItem("override")) == null || !override.getNodeValue().equals("yes")) continue;
                        Node valueNode = nm.getNamedItem("value");
                        valueNode.setNodeValue(sp.value);
                    }
                }
            }
            return structure;
        }

        private class StructureParameter {
            String name;
            String value;

            public StructureParameter(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

