/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.StylesheetDescription;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class StylesheetSet
extends SAX2FilterImpl {
    protected static final String m_defaultMediaPropsUri = "/properties/media.properties";
    protected static Hashtable m_mediaPropsCache = new Hashtable(5);
    protected String m_myMediaPropsUri = "/properties/media.properties";
    protected Hashtable title_table;

    public StylesheetSet() {
        this.title_table = new Hashtable();
    }

    public StylesheetSet(ContentHandler dt) {
        super(dt);
    }

    public StylesheetSet(String uri) throws PortalException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            StylesheetSet dummy = new StylesheetSet();
            reader.setContentHandler(dummy);
            URL url = null;
            try {
                url = new URL(uri);
                reader.parse(url.toString());
                this.title_table = dummy.getTitleTable();
            }
            catch (IOException ioe) {
                throw new ResourceMissingException(url.toString(), "XSLT stylesheet", "StylesheetSet(uri) : Unable to read stylesheet set from the specified location. Please check the URL.");
            }
            catch (SAXException se) {
                throw new GeneralRenderingException("StylesheetSet(uri) : Unable to parse stylesheet set (.ssl) file. URL=\"" + url + "\", exception message: " + se.getMessage());
            }
        }
        catch (SAXException se) {
            LogService.log(LogService.ERROR, se);
            throw new GeneralRenderingException("StylesheetSet(uri) : Unable to instantiate SAX Reader. Please check your library installation.");
        }
    }

    public Source getStylesheet(String title) {
        Hashtable media_table = (Hashtable)this.title_table.get(title);
        if (media_table == null) {
            return null;
        }
        StylesheetDescription sd = null;
        if (media_table.isEmpty()) {
            return null;
        }
        Enumeration e = media_table.elements();
        while (e.hasMoreElements()) {
            if (sd == null) {
                sd = (StylesheetDescription)e.nextElement();
                continue;
            }
            StylesheetDescription tsd = (StylesheetDescription)e.nextElement();
            if (tsd.getAlternate()) continue;
            sd = tsd;
        }
        return new StreamSource(sd.getURI());
    }

    public Source getStylesheet() {
        StylesheetDescription sd = null;
        Enumeration e = this.title_table.elements();
        block0: while (e.hasMoreElements()) {
            Hashtable media_table = (Hashtable)e.nextElement();
            if (media_table.isEmpty()) continue;
            Enumeration f = media_table.elements();
            while (f.hasMoreElements()) {
                if (sd == null) {
                    sd = (StylesheetDescription)f.nextElement();
                } else {
                    StylesheetDescription tsd = (StylesheetDescription)f.nextElement();
                    if (!tsd.getAlternate()) {
                        sd = tsd;
                    }
                }
                if (sd.getAlternate()) continue;
                continue block0;
            }
        }
        return new StreamSource(sd.getURI());
    }

    public Source getStylesheet(String title, String media) {
        Enumeration sls;
        Hashtable media_table = (Hashtable)this.title_table.get(title);
        if (media_table == null) {
            return null;
        }
        StylesheetDescription sd = (StylesheetDescription)media_table.get(media);
        if (sd == null && (sls = media_table.elements()).hasMoreElements()) {
            sd = (StylesheetDescription)sls.nextElement();
        }
        if (sd == null) {
            return null;
        }
        return new StreamSource(sd.getURI());
    }

    public Source getStylesheet(String title, BrowserInfo bi) throws PortalException {
        Enumeration sls;
        String media = this.getMedia(bi);
        Hashtable media_table = (Hashtable)this.title_table.get(title);
        if (media_table == null) {
            return null;
        }
        StylesheetDescription sd = (StylesheetDescription)media_table.get(media);
        if (sd == null && (sls = media_table.elements()).hasMoreElements()) {
            sd = (StylesheetDescription)sls.nextElement();
        }
        if (sd == null) {
            return null;
        }
        return new StreamSource(sd.getURI());
    }

    public String getStylesheetURI(String media) throws GeneralRenderingException {
        if (media == null) {
            throw new GeneralRenderingException("StylesheetSet.getStylesheetURI(): Media argument cannot be null");
        }
        String ssURI = null;
        StylesheetDescription sd = this.getStylesheetDescription(media);
        if (sd != null) {
            ssURI = sd.getURI();
        }
        return ssURI;
    }

    public String getStylesheetURI(HttpServletRequest req) throws PortalException {
        return this.getStylesheetURI(this.getMedia(req));
    }

    public String getStylesheetURI(BrowserInfo bi) throws PortalException {
        return this.getStylesheetURI(this.getMedia(bi));
    }

    public String getStylesheetURI(String title, HttpServletRequest req) throws PortalException {
        return this.getStylesheetURI(title, this.getMedia(req));
    }

    public String getStylesheetURI(String title, BrowserInfo bi) throws PortalException {
        return this.getStylesheetURI(title, this.getMedia(bi));
    }

    public String getStylesheetURI(String title, String media) throws GeneralRenderingException {
        if (title != null) {
            Enumeration sls;
            Hashtable media_table = (Hashtable)this.title_table.get(title);
            if (media_table == null) {
                return null;
            }
            LogService.log(LogService.DEBUG, "media=\"" + media + "\"");
            StylesheetDescription sd = (StylesheetDescription)media_table.get(media);
            if (sd == null && (sls = media_table.elements()).hasMoreElements()) {
                sd = (StylesheetDescription)sls.nextElement();
            }
            if (sd == null) {
                return null;
            }
            return sd.getURI();
        }
        return this.getStylesheetURI(media);
    }

    protected StylesheetDescription getStylesheetDescription(String media) throws GeneralRenderingException {
        if (media == null) {
            LogService.log(LogService.ERROR, "StylesheetSet::getStylesheetDescription() : media argument is null");
            throw new GeneralRenderingException("StylesheetSet.getStylesheetDescription(): Null media argument passed in");
        }
        StylesheetDescription sd = null;
        Enumeration e = this.title_table.elements();
        while (e.hasMoreElements()) {
            Hashtable media_table = (Hashtable)e.nextElement();
            StylesheetDescription tsd = (StylesheetDescription)media_table.get(media);
            if (tsd != null) {
                if (sd == null) {
                    sd = tsd;
                }
                if (tsd.getAlternate()) continue;
                sd = tsd;
                break;
            }
            Enumeration sls = media_table.elements();
            if (!sls.hasMoreElements()) continue;
            sd = (StylesheetDescription)sls.nextElement();
        }
        return sd;
    }

    public Source getStylesheet(String title, HttpServletRequest req) throws PortalException {
        return this.getStylesheet(title, this.getMedia(req));
    }

    public Source getStylesheet(HttpServletRequest req) throws PortalException {
        StylesheetDescription sd = this.getStylesheetDescription(this.getMedia(req));
        if (sd != null) {
            return new StreamSource(sd.getURI());
        }
        return null;
    }

    public Source getStylesheetByMedia(String media) throws GeneralRenderingException {
        StylesheetDescription sd = this.getStylesheetDescription(media);
        if (sd != null) {
            return new StreamSource(sd.getURI());
        }
        return null;
    }

    public void addStyleSheet(StylesheetDescription sd) {
        Hashtable<String, StylesheetDescription> media_table = (Hashtable<String, StylesheetDescription>)this.title_table.get(sd.getTitle());
        if (media_table == null) {
            media_table = new Hashtable<String, StylesheetDescription>();
            media_table.put(sd.getMedia(), sd);
            this.title_table.put(sd.getTitle(), media_table);
        } else {
            media_table.put(sd.getMedia(), sd);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equals("xml-stylesheet")) {
            StylesheetDescription sd = new StylesheetDescription(data);
            this.addStyleSheet(sd);
        }
        if (this.getContentHandler() != null) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    protected OrderedProps getMediaProps() throws PortalException {
        if (m_mediaPropsCache.containsKey(this.m_myMediaPropsUri)) {
            return (OrderedProps)m_mediaPropsCache.get(this.m_myMediaPropsUri);
        }
        this.setMediaProps(this.m_myMediaPropsUri);
        return (OrderedProps)m_mediaPropsCache.get(this.m_myMediaPropsUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaProps(String uri) throws PortalException {
        block9: {
            if (uri == null) {
                uri = m_defaultMediaPropsUri;
            } else {
                this.m_myMediaPropsUri = uri = ResourceLoader.getResourceAsURLString(this.getClass(), uri);
            }
            if (m_mediaPropsCache.containsKey(uri)) {
                return;
            }
            try {
                URL url = new URL(uri);
                if (url != null) {
                    InputStream in = url.openStream();
                    try {
                        m_mediaPropsCache.put(uri, new OrderedProps(in));
                        break block9;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new ResourceMissingException(uri, "The media.properties file", "Unable to understand the media.properties URI");
            }
            catch (IOException ioe) {
                throw new ResourceMissingException(uri, "The media.properties file ", ioe.getMessage());
            }
        }
    }

    protected Hashtable getTitleTable() {
        return this.title_table;
    }

    protected String getMedia(HttpServletRequest req) throws PortalException {
        return this.getMediaProps().getValue(req.getHeader("User-Agent"));
    }

    protected String getMedia(BrowserInfo bi) throws PortalException {
        return this.getMediaProps().getValue(bi.getUserAgent());
    }

    class OrderedProps {
        private Vector attVec = new Vector(15);

        OrderedProps(InputStream inputStream) throws IOException {
            String currentLine;
            BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
            String Key2 = null;
            while ((currentLine = input.readLine()) != null) {
                StringTokenizer currentTokens = new StringTokenizer(currentLine, "=\t\r\n");
                if (currentTokens.hasMoreTokens()) {
                    Key2 = currentTokens.nextToken().trim();
                }
                if (Key2 == null || Key2.startsWith("#") || !currentTokens.hasMoreTokens()) continue;
                String[] temp = new String[]{Key2, currentTokens.nextToken().trim()};
                this.attVec.addElement(temp);
            }
            input.close();
        }

        String getValue(String s) {
            if (s == null) {
                return null;
            }
            int j = this.attVec.size();
            for (int i = 0; i < j; ++i) {
                String[] temp = (String[])this.attVec.elementAt(i);
                if (s.indexOf(temp[0]) <= -1) continue;
                return temp[1];
            }
            return "unknown";
        }
    }
}

