/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.GuestUserInstance;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserInstance;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.security.PortalSecurityException;
import org.jasig.portal.services.LogService;

public class UserInstanceManager {
    static Hashtable guestUserInstances = new Hashtable();

    public static UserInstance getUserInstance(HttpServletRequest request) throws PortalException {
        IPerson person = null;
        try {
            person = PersonManagerFactory.getPersonManagerInstance().getPerson(request);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "UserInstanceManager: Unable to retrieve IPerson!", e);
            throw new PortalSecurityException("Could not retrieve IPerson");
        }
        UserInstance userInstance = (UserInstance)request.getSession(false).getAttribute("org.jasig.portal.UserInstance");
        if (userInstance != null) {
            return userInstance;
        }
        if (person.isGuest()) {
            GuestUserInstance guestUserInstance = (GuestUserInstance)guestUserInstances.get(new Integer(person.getID()));
            if (guestUserInstance == null) {
                guestUserInstance = new GuestUserInstance(person);
                guestUserInstances.put(new Integer(person.getID()), guestUserInstance);
            }
            guestUserInstance.registerSession(request);
            userInstance = guestUserInstance;
        } else if (person.getSecurityContext().isAuthenticated()) {
            userInstance = new UserInstance(person);
        } else {
            throw new PortalSecurityException("System does not allow for unauthenticated non-guest users.");
        }
        request.getSession(false).setAttribute("org.jasig.portal.UserInstance", (Object)userInstance);
        return userInstance;
    }
}

