/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.IWorkerRequestProcessor;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.car.CarResources;
import org.jasig.portal.car.MimeTypeCache;

public class CarResourceWorker
implements IWorkerRequestProcessor {
    private static CarResources resources = CarResources.getInstance();
    public static final String RCS_ID = "@(#) $Header: /home/cvs/jasig/portal/source/org/jasig/portal/car/CarResourceWorker.java,v 1.8 2003/11/04 01:03:50 wgthom Exp $";

    public void processWorkerDispatch(PortalControlStructures pcs) throws PortalException {
        HttpServletRequest req = pcs.getHttpServletRequest();
        HttpServletResponse res = pcs.getHttpServletResponse();
        String resourceName = this.getResourceName(req);
        InputStream in = resources.getResourceAsStream(resourceName);
        if (in == null) {
            res.setStatus(404);
            return;
        }
        this.setContentType(res, resourceName);
        long resourceSize = resources.getResourceSize(resourceName);
        if (resourceSize != -1L) {
            res.setHeader("Content-Length", "" + resourceSize);
        }
        try {
            ServletOutputStream out = res.getOutputStream();
            byte[] bytes = new byte[4096];
            int bytesRead = 0;
            bytesRead = in.read(bytes);
            while (bytesRead != -1) {
                out.write(bytes, 0, bytesRead);
                bytesRead = in.read(bytes);
            }
            out.flush();
        }
        catch (IOException ioe) {
            throw new PortalException("Error writing resource");
        }
    }

    private void setContentType(HttpServletResponse res, String resourceName) throws PortalException {
        resourceName = resourceName.toLowerCase();
        ServletContext sc = PortalSessionManager.getInstance().getServletConfig().getServletContext();
        String mimeType = MimeTypeCache.getMimeType(sc, resourceName);
        if (null == mimeType) {
            throw new PortalException("Unsupported resource type '" + resourceName + "'");
        }
        res.setContentType(mimeType);
    }

    private String getResourceName(HttpServletRequest req) throws PortalException {
        String resourceName = req.getParameter("carRsrc");
        if (resourceName == null) {
            Enumeration e = req.getParameterNames();
            if (e == null) {
                throw new PortalException("getParameterNames() is null.");
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (!e.hasMoreElements()) {
                pw.print("getParameterNames() is empty. Req class = " + req.getClass().getName());
            }
            while (e.hasMoreElements()) {
                String parm = (String)e.nextElement();
                Object[] vals = req.getParameterValues(parm);
                if (vals == null) {
                    pw.print(" " + parm + "(-)");
                    if (req instanceof PortalSessionManager.RequestParamWrapper) {
                        vals = ((PortalSessionManager.RequestParamWrapper)req).getObjectParameterValues(parm);
                    }
                    if (vals == null) {
                        pw.print(" " + parm + "(both)=[]");
                    } else {
                        pw.print(" " + parm + "(2nd)=[");
                    }
                } else {
                    pw.print(" " + parm + "=[");
                }
                if (vals == null) continue;
                for (int i = 0; i < vals.length; ++i) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    pw.print(vals[i]);
                }
                pw.print("]");
            }
            pw.flush();
            pw.close();
            throw new PortalException("Resource name not specified. " + sw.toString());
        }
        try {
            resourceName = URLDecoder.decode(resourceName);
        }
        catch (Exception ex) {
            throw new PortalException("Unable to URLDecode the resource name '" + resourceName + "'");
        }
        return resourceName;
    }
}

