/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IMultithreadedChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.xml.sax.ContentHandler;

public abstract class BaseMultithreadedChannel
implements IMultithreadedChannel {
    protected static Map channelStateMap = Collections.synchronizedMap(new HashMap());

    public ChannelRuntimeProperties getRuntimeProperties(String uid) {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev, String uid) {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        if (channelState != null) {
            channelState.setPortalEvent(ev);
            if (ev.getEventNumber() == 1) {
                channelStateMap.remove(uid);
            }
        }
    }

    public void setStaticData(ChannelStaticData sd, String uid) throws PortalException {
        ChannelState channelState = new ChannelState();
        channelState.setStaticData(sd);
        channelStateMap.put(uid, channelState);
    }

    public void setRuntimeData(ChannelRuntimeData rd, String uid) throws PortalException {
        ChannelState channelState = (ChannelState)channelStateMap.get(uid);
        channelState.setRuntimeData(rd);
    }

    public void renderXML(ContentHandler out, String uid) throws PortalException {
    }

    protected class ChannelState {
        private ChannelStaticData staticData = null;
        private ChannelRuntimeData runtimeData = null;
        private PortalEvent portalEvent = null;
        private Map channelData = new HashMap();

        protected ChannelState() {
        }

        public ChannelStaticData getStaticData() {
            return this.staticData;
        }

        public ChannelRuntimeData getRuntimeData() {
            return this.runtimeData;
        }

        public PortalEvent getPortalEvent() {
            return this.portalEvent;
        }

        public Map getChannelData() {
            return this.channelData;
        }

        public void setStaticData(ChannelStaticData sd) {
            this.staticData = sd;
        }

        public void setRuntimeData(ChannelRuntimeData rd) {
            this.runtimeData = rd;
        }

        public void setPortalEvent(PortalEvent ev) {
            this.portalEvent = ev;
        }

        public void setChannelData(Map cd) {
            this.channelData = cd;
        }
    }
}

