/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jasig.portal.ChannelRegistryManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.GeneralRenderingException;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerServantFactory;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class CChannelManager
extends BaseChannel {
    protected static final String sslLocation = "CChannelManager/CChannelManager.ssl";
    protected static final Document emptyDoc = DocumentFactory.getNewDocument();
    protected short state;
    protected static final short DEFAULT_STATE = 0;
    protected static final short CHANNEL_TYPE_STATE = 1;
    protected static final short GENERAL_SETTINGS_STATE = 2;
    protected static final short CUSTOM_SETTINGS_STATE = 3;
    protected static final short CHANNEL_DEF_STATE = 4;
    protected static final short CHANNEL_CONTROLS_STATE = 5;
    protected static final short CHANNEL_CATEGORIES_STATE = 6;
    protected static final short CHANNEL_GROUPS_STATE = 7;
    protected static final short CHANNEL_REVIEW_STATE = 8;
    protected static final short MODIFY_CHANNEL_STATE = 9;
    protected String action;
    protected String stepID;
    protected Document channelManagerDoc;
    protected ChannelDefinition channelDef;
    protected ModifyChannelSettings modChanSettings = new ModifyChannelSettings();
    protected IPerson person;
    protected IServant categoryServant;
    protected IServant groupServant;
    protected String errorMsg;

    protected void resetSettings() {
        this.channelDef = new ChannelDefinition();
        this.modChanSettings = new ModifyChannelSettings();
        this.categoryServant = null;
        this.groupServant = null;
        this.errorMsg = null;
    }

    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;
        this.person = sd.getPerson();
    }

    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;
        this.action = this.runtimeData.getParameter("uPCM_action");
        if (this.action != null && this.action.equals("selectCategories") || this.action == null && this.state == 6) {
            this.action = "selectCategories";
            this.state = (short)6;
            this.getCategoryServant().setRuntimeData(rd);
        }
        if (this.action != null && this.action.equals("selectGroups") || this.action == null && this.state == 7) {
            this.action = "selectGroups";
            this.state = (short)7;
            this.getGroupServant().setRuntimeData(rd);
        }
        this.doCapture();
        this.doAction();
    }

    public void renderXML(ContentHandler out) throws PortalException {
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(this.channelManagerDoc);
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
        String action = null;
        switch (this.state) {
            case 0: {
                action = "none";
                break;
            }
            case 1: {
                action = "selectChannelType";
                break;
            }
            case 2: {
                action = "selectGeneralSettings";
                break;
            }
            case 3: {
                action = "customSettings";
                break;
            }
            case 4: {
                action = "channelDef";
                xslt.setStylesheetParameter("stepID", this.fixStepID(this.stepID));
                break;
            }
            case 5: {
                action = "selectControls";
                break;
            }
            case 6: {
                action = "selectCategories";
                break;
            }
            case 7: {
                action = "selectGroups";
                break;
            }
            case 8: {
                action = "reviewChannel";
                if (this.errorMsg != null) {
                    xslt.setStylesheetParameter("errorMsg", this.errorMsg);
                }
                this.errorMsg = null;
                break;
            }
            case 9: {
                action = "selectModifyChannel";
                break;
            }
            default: {
                action = "none";
            }
        }
        xslt.setStylesheetParameter("action", action);
        xslt.transform();
        if (this.categoryServant != null && action.equals("selectCategories")) {
            this.categoryServant.renderXML(out);
            xslt.setStylesheetParameter("action", "selectCategoriesButtons");
            xslt.transform();
        }
        if (this.groupServant != null && action.equals("selectGroups")) {
            this.groupServant.renderXML(out);
            xslt.setStylesheetParameter("action", "selectGroupsButtons");
            xslt.transform();
        }
    }

    protected synchronized IServant getGroupServant() {
        if (this.groupServant == null) {
            try {
                if (this.channelDef.ID == null) {
                    this.groupServant = CGroupsManagerServantFactory.getGroupsServantforSelection(this.staticData, "Please select groups or people who should have access to this channel:", "org.jasig.portal.security.IPerson", false, true);
                } else {
                    IPermissionManager pm = AuthorizationService.instance().newPermissionManager("UP_FRAMEWORK");
                    IAuthorizationPrincipal[] prins = pm.getAuthorizedPrincipals("SUBSCRIBE", "CHAN_ID." + this.channelDef.ID.substring(4));
                    IGroupMember[] members = new IGroupMember[prins.length];
                    for (int mp = 0; mp < prins.length; ++mp) {
                        members[mp] = AuthorizationService.instance().getGroupMember(prins[mp]);
                    }
                    this.groupServant = CGroupsManagerServantFactory.getGroupsServantforSelection(this.staticData, "Please select groups or people who should have access to this channel:", "org.jasig.portal.security.IPerson", false, true, members);
                }
                this.groupServant.setRuntimeData((ChannelRuntimeData)this.runtimeData.clone());
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            LogService.log(LogService.DEBUG, "CChannelManager.getGroupServant():  created new servant");
        }
        return this.groupServant;
    }

    protected synchronized IServant getCategoryServant() {
        if (this.categoryServant == null) {
            try {
                if (this.channelDef.ID == null) {
                    this.categoryServant = CGroupsManagerServantFactory.getGroupsServantforSelection(this.staticData, "Please select channel categories for this channel:", "org.jasig.portal.ChannelDefinition", false, false);
                } else {
                    IEntity thisChan = GroupService.getEntity(this.channelDef.ID.substring(4), Class.forName("org.jasig.portal.ChannelDefinition"));
                    this.categoryServant = CGroupsManagerServantFactory.getGroupsServantforGroupMemberships(this.staticData, "Please select channel categories for this channel:", thisChan, false);
                }
                this.categoryServant.setRuntimeData((ChannelRuntimeData)this.runtimeData.clone());
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            LogService.log(LogService.DEBUG, "CChannelManager.getCategoryServant():  created new servant");
        }
        return this.categoryServant;
    }

    private String fixStepID(String stepID) {
        if (stepID == null) {
            stepID = "1";
        } else {
            try {
                Integer.parseInt(stepID);
            }
            catch (NumberFormatException nfe) {
                stepID = "1";
            }
        }
        return stepID;
    }

    protected void doCapture() {
        this.stepID = this.runtimeData.getParameter("uPCM_step");
        String capture = this.runtimeData.getParameter("uPCM_capture");
        if (capture != null) {
            if (capture.equals("selectChannelType")) {
                String typeID = this.runtimeData.getParameter("ID");
                if (typeID != null) {
                    if (!typeID.equals(this.channelDef.getTypeID())) {
                        this.channelDef.setTypeID(typeID);
                        this.channelDef.resetChannelControls();
                        this.channelDef.removeParameters();
                    }
                } else {
                    this.action = "selectChannelType";
                }
            } else if (capture.equals("selectGeneralSettings")) {
                String name = this.runtimeData.getParameter("name");
                String fname = this.runtimeData.getParameter("fname");
                String description = this.runtimeData.getParameter("description");
                String title = this.runtimeData.getParameter("title");
                String timeout = this.runtimeData.getParameter("timeout");
                String javaClass = this.runtimeData.getParameter("class");
                String secure = this.runtimeData.getParameter("secure");
                if (name != null) {
                    this.channelDef.setName(name.trim());
                }
                if (fname != null) {
                    this.channelDef.setFunctionalName(fname.trim());
                }
                if (description != null) {
                    this.channelDef.setDescription(description.trim());
                }
                if (title != null) {
                    this.channelDef.setTitle(title.trim());
                }
                if (timeout != null) {
                    this.channelDef.setTimeout(timeout.trim());
                }
                if (javaClass != null) {
                    this.channelDef.setJavaClass(javaClass.trim());
                }
                this.channelDef.setIsSecure(secure != null ? "true" : "false");
            } else if (capture.equals("customSettings")) {
                String subAction = this.runtimeData.getParameter("uPCM_subAction");
                if (subAction != null) {
                    String namePrefix;
                    String name = this.runtimeData.getParameter("name");
                    if (name != null) {
                        name = name.trim();
                    }
                    if ((namePrefix = this.runtimeData.getParameter("uPCM_namePrefix")) != null) {
                        name = namePrefix + name;
                    }
                    if (subAction.equals("addParameter")) {
                        String override;
                        String value = this.runtimeData.getParameter("value");
                        if (value != null) {
                            value = value.trim();
                        }
                        this.channelDef.addParameter(name, value, (override = this.runtimeData.getParameter("override")) != null ? "yes" : "no");
                    } else if (subAction.equals("deleteParameter")) {
                        this.channelDef.removeParameter(name);
                    }
                }
            } else if (capture.equals("channelDef")) {
                Iterator iter = this.runtimeData.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    if (name.startsWith("uPCM_")) continue;
                    String value = this.runtimeData.getParameter(name);
                    String override = this.runtimeData.getParameter("uPCM_" + name + "_sub");
                    this.channelDef.addParameter(name, value, override != null ? "yes" : "no");
                }
            } else if (capture.equals("selectControls")) {
                String editable = this.runtimeData.getParameter("editable");
                this.channelDef.setEditable(editable != null ? "true" : "false");
                String hasHelp = this.runtimeData.getParameter("hasHelp");
                this.channelDef.setHasHelp(hasHelp != null ? "true" : "false");
                String hasAbout = this.runtimeData.getParameter("hasAbout");
                this.channelDef.setHasAbout(hasAbout != null ? "true" : "false");
            }
        }
    }

    protected void doAction() throws PortalException {
        if (this.action != null) {
            if (this.action.equals("selectChannelType")) {
                this.state = 1;
                Workflow workflow = new Workflow();
                WorkflowSection chanTypeSection = new WorkflowSection("selectChannelType");
                WorkflowStep step = new WorkflowStep("1", "Channel Type");
                step.addDataElement(ChannelRegistryManager.getChannelTypes().getDocumentElement());
                step.addDataElement(this.channelDef.toXML());
                chanTypeSection.addStep(step);
                workflow.setChannelTypesSection(chanTypeSection);
                this.channelManagerDoc = workflow.toXML();
            } else if (this.action.equals("selectGeneralSettings")) {
                this.state = (short)2;
                Workflow workflow = new Workflow();
                WorkflowSection gsSection = new WorkflowSection("selectGeneralSettings");
                workflow.setGeneralSettingsSection(gsSection);
                WorkflowStep step = new WorkflowStep("1", "General Settings");
                step.addDataElement(this.channelDef.toXML());
                gsSection.addStep(step);
                this.channelManagerDoc = workflow.toXML();
            } else if (this.action.equals("channelParams") || this.action.equals("customSettings") || this.action.equals("channelDef")) {
                Workflow workflow = new Workflow();
                if (this.channelDef.getTypeID().equals("-1")) {
                    this.state = (short)3;
                    WorkflowSection csSection = new WorkflowSection("customSettings");
                    WorkflowStep step = new WorkflowStep("1", "Channel Parameters");
                    step.addDataElement(this.channelDef.toXML());
                    csSection.addStep(step);
                    workflow.setChannelParamsSection(csSection);
                } else {
                    this.state = (short)4;
                    CPDWorkflowSection cpdSection = new CPDWorkflowSection(this.channelDef.getTypeID());
                    cpdSection.addToStep(this.channelDef.toXML(), this.fixStepID(this.stepID));
                    workflow.setChannelParamsSection(cpdSection);
                }
                this.channelManagerDoc = workflow.toXML();
            } else if (this.action.equals("selectControls")) {
                this.state = (short)5;
                Workflow workflow = new Workflow();
                WorkflowSection controlsSection = new WorkflowSection("selectControls");
                if (this.channelDef.getEditable() == null) {
                    this.channelDef.resetChannelControls();
                }
                WorkflowStep step = new WorkflowStep("1", "Channel Controls");
                step.addDataElement(this.channelDef.toXML());
                controlsSection.addStep(step);
                workflow.setControlsSection(controlsSection);
                this.channelManagerDoc = workflow.toXML();
            } else if (this.action.equals("reviewChannel")) {
                this.state = (short)8;
                Workflow workflow = new Workflow();
                WorkflowSection ctSection = new WorkflowSection("selectChannelType");
                WorkflowStep ctStep = new WorkflowStep("1", "Channel Type");
                ctStep.addDataElement(ChannelRegistryManager.getChannelTypes().getDocumentElement());
                ctSection.addStep(ctStep);
                workflow.setChannelTypesSection(ctSection);
                WorkflowSection regSection = new WorkflowSection("selectCategories");
                WorkflowStep regStep = new WorkflowStep("1", "Categories");
                regStep.addDataElement(this.getCategoriesXML());
                regSection.addStep(regStep);
                workflow.setCategoriesSection(regSection);
                WorkflowSection groupsSection = new WorkflowSection("selectGroups");
                WorkflowStep groupsStep = new WorkflowStep("1", "Groups");
                groupsStep.addDataElement(this.getGroupsXML());
                groupsSection.addStep(groupsStep);
                workflow.setGroupsSection(groupsSection);
                WorkflowSection reviewSection = new WorkflowSection("reviewChannel");
                WorkflowStep step = new WorkflowStep("1", "Review");
                step.addDataElement(this.channelDef.toXML());
                reviewSection.addStep(step);
                workflow.setReviewSection(reviewSection);
                this.channelManagerDoc = workflow.toXML();
            } else {
                if (this.action.equals("finished")) {
                    this.state = 0;
                    IGroupMember[] ctgs = (IGroupMember[])this.getCategoryServant().getResults();
                    if (ctgs.length == 0) {
                        this.action = "reviewChannel";
                        this.errorMsg = "NO_CATEGORIES";
                        this.doAction();
                        return;
                    }
                    String[] catIDs = new String[ctgs.length];
                    for (int c = 0; c < ctgs.length; ++c) {
                        catIDs[c] = ctgs[c].getKey();
                    }
                    IGroupMember[] groupMembers = (IGroupMember[])this.getGroupServant().getResults();
                    if (groupMembers.length == 0) {
                        this.action = "reviewChannel";
                        this.errorMsg = "NO_GROUP_MEMBERS";
                        this.doAction();
                        return;
                    }
                    try {
                        Element channelE = this.channelDef.toXML();
                        ChannelRegistryManager.publishChannel(channelE, catIDs, groupMembers, this.person);
                        this.resetSettings();
                    }
                    catch (Exception e) {
                        throw new PortalException(e);
                    }
                }
                if (this.action.equals("selectModifyChannel")) {
                    this.state = (short)9;
                    this.channelManagerDoc = this.getChannelManagerDoc(this.modChanSettings);
                } else if (this.action.equals("changePage")) {
                    String newPage = this.runtimeData.getParameter("newPage");
                    if (newPage != null) {
                        this.modChanSettings.setCurrentPage(newPage);
                        this.channelManagerDoc = this.getChannelManagerDoc(this.modChanSettings);
                    }
                } else if (this.action.equals("changeRecordsPerPage")) {
                    String recordsPerPage = this.runtimeData.getParameter("recordsPerPage");
                    if (recordsPerPage != null) {
                        try {
                            int oldPage = Integer.parseInt(this.modChanSettings.getCurrentPage());
                            int oldRecordsPerPage = Integer.parseInt(this.modChanSettings.getRecordsPerPage());
                            int recsPerPage = Integer.parseInt(recordsPerPage);
                            if (recsPerPage > 0 && recsPerPage != oldRecordsPerPage) {
                                String newPage = String.valueOf(((oldPage - 1) * oldRecordsPerPage + 1) / recsPerPage + 1);
                                this.modChanSettings.setCurrentPage(newPage);
                                this.modChanSettings.setRecordsPerPage(recordsPerPage);
                                this.channelManagerDoc = this.getChannelManagerDoc(this.modChanSettings);
                            }
                        }
                        catch (NumberFormatException nfe) {}
                    }
                } else if (this.action.equals("filterByCategory")) {
                    String filterByID = this.runtimeData.getParameter("newCategory");
                    if (filterByID != null) {
                        this.modChanSettings.setCurrentPage("1");
                        this.modChanSettings.setFilterByID(filterByID);
                        this.channelManagerDoc = this.getChannelManagerDoc(this.modChanSettings);
                    }
                } else if (this.action.equals("editChannelSettings")) {
                    String str_channelPublishId = this.runtimeData.getParameter("channelID");
                    this.channelDef.setChannelDefinition(ChannelRegistryManager.getChannel(str_channelPublishId));
                    this.action = "reviewChannel";
                    this.doAction();
                } else if (this.action.equals("removePublishedChannel")) {
                    String channelPublishId = this.runtimeData.getParameter("channelID");
                    if (channelPublishId != null) {
                        try {
                            ChannelRegistryManager.removeChannel(channelPublishId, this.person);
                        }
                        catch (Exception e) {
                            throw new GeneralRenderingException(e.getMessage());
                        }
                    }
                    this.channelManagerDoc = this.getChannelManagerDoc(this.modChanSettings);
                }
            }
        }
        if (this.action == null || this.action.equals("cancel")) {
            this.state = 0;
            this.channelManagerDoc = emptyDoc;
            this.channelDef = new ChannelDefinition();
            this.categoryServant = null;
            this.groupServant = null;
        }
    }

    protected Document getChannelManagerDoc(ModifyChannelSettings modChanSettings) throws PortalException {
        Document channelManagerDoc = DocumentFactory.getNewDocument();
        Element channelManager = channelManagerDoc.createElement("manageChannels");
        channelManagerDoc.appendChild(channelManager);
        Document channelRegistryDoc = ChannelRegistryManager.getChannelRegistry();
        Element registry = channelRegistryDoc.getDocumentElement();
        registry.setAttribute("ID", "-1");
        Element channelRegistry = (Element)channelManagerDoc.importNode(channelRegistryDoc.getDocumentElement(), true);
        channelManager.appendChild(channelRegistry);
        CChannelManager.appendModifyChannelSettings(channelManager, modChanSettings);
        return channelManagerDoc;
    }

    protected Element getGroupsXML() {
        Element el = emptyDoc.createElement("userSettings");
        Element browsingGroupE = emptyDoc.createElement("browsingGroup");
        browsingGroupE.appendChild(emptyDoc.createTextNode("top"));
        el.appendChild(browsingGroupE);
        IGroupMember[] gms = (IGroupMember[])this.getGroupServant().getResults();
        if (gms != null && gms.length > 0) {
            Element selectedGroupsE = emptyDoc.createElement("selectedGroups");
            try {
                for (int c = 0; c < gms.length; ++c) {
                    Element selectedGroupE = emptyDoc.createElement("selectedGroup");
                    selectedGroupE.setAttribute("name", EntityNameFinderService.instance().getNameFinder(gms[c].getType()).getName(gms[c].getKey()));
                    selectedGroupE.appendChild(emptyDoc.createTextNode(gms[c].getKey()));
                    selectedGroupsE.appendChild(selectedGroupE);
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            el.appendChild(selectedGroupsE);
        }
        return el;
    }

    protected Element getCategoriesXML() {
        Element userSettingsE = emptyDoc.createElement("userSettings");
        Element browsingCategoryE = emptyDoc.createElement("browsingCategory");
        browsingCategoryE.appendChild(emptyDoc.createTextNode("top"));
        userSettingsE.appendChild(browsingCategoryE);
        IGroupMember[] gms = (IGroupMember[])this.getCategoryServant().getResults();
        if (gms != null && gms.length > 0) {
            Element selectedCategoriesE = emptyDoc.createElement("selectedCategories");
            try {
                for (int c = 0; c < gms.length; ++c) {
                    Element selectedCategoryE = emptyDoc.createElement("selectedCategory");
                    selectedCategoryE.setAttribute("name", EntityNameFinderService.instance().getNameFinder(gms[c].getType()).getName(gms[c].getKey()));
                    selectedCategoryE.appendChild(emptyDoc.createTextNode(gms[c].getKey()));
                    selectedCategoriesE.appendChild(selectedCategoryE);
                }
            }
            catch (Exception e) {
                LogService.log(LogService.ERROR, e);
            }
            userSettingsE.appendChild(selectedCategoriesE);
        }
        return userSettingsE;
    }

    protected static void appendModifyChannelSettings(Element channelManager, ModifyChannelSettings modChanSettings) {
        Document doc = channelManager.getOwnerDocument();
        Element userSettingsE = doc.createElement("userSettings");
        Element modifyView = doc.createElement("modifyView");
        userSettingsE.appendChild(modifyView);
        Element recordsPerPageE = doc.createElement("recordsPerPage");
        recordsPerPageE.appendChild(doc.createTextNode(modChanSettings.getRecordsPerPage()));
        modifyView.appendChild(recordsPerPageE);
        Element currentPageE = doc.createElement("currentPage");
        currentPageE.appendChild(doc.createTextNode(modChanSettings.getCurrentPage()));
        modifyView.appendChild(currentPageE);
        Element filterByIDE = doc.createElement("filterByID");
        filterByIDE.appendChild(doc.createTextNode(modChanSettings.getFilterByID()));
        modifyView.appendChild(filterByIDE);
        channelManager.appendChild(userSettingsE);
    }

    protected class ChannelDefinition {
        protected String ID;
        protected String typeID;
        protected String name;
        protected String description;
        protected String title;
        protected String timeout;
        protected String fname;
        protected String javaClass;
        protected String editable;
        protected String hasHelp;
        protected String hasAbout;
        protected String secure;
        protected Map parameters = new HashMap();

        protected ChannelDefinition() {
        }

        protected String getTypeID() {
            return this.typeID;
        }

        protected String getEditable() {
            return this.editable;
        }

        protected String getHasHelp() {
            return this.hasHelp;
        }

        protected String getHasAbout() {
            return this.hasAbout;
        }

        protected String isSecure() {
            return this.secure;
        }

        protected void setTypeID(String typeID) {
            this.typeID = typeID;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void setFunctionalName(String fname) {
            this.fname = fname;
        }

        protected void setDescription(String description) {
            this.description = description;
        }

        protected void setTitle(String title) {
            this.title = title;
        }

        protected void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        protected void setJavaClass(String javaClass) {
            this.javaClass = javaClass;
        }

        protected void setEditable(String editable) {
            this.editable = editable;
        }

        protected void setHasHelp(String hasHelp) {
            this.hasHelp = hasHelp;
        }

        protected void setHasAbout(String hasAbout) {
            this.hasAbout = hasAbout;
        }

        protected void setIsSecure(String secure) {
            this.secure = secure;
        }

        private void setAttribute(Element e, String attName, String attVal) {
            if (attVal != null) {
                e.setAttribute(attName, attVal);
            }
        }

        protected void addParameter(String name, String value, String modType) {
            this.parameters.put(name, new Parameter(name, value, modType));
        }

        protected void removeParameter(String name) {
            this.parameters.remove(name);
        }

        protected void removeParameters() {
            this.parameters = new HashMap();
        }

        protected void resetChannelControls() {
            try {
                Document cpdDoc = ChannelRegistryManager.getCPD(this.typeID);
                if (cpdDoc != null) {
                    for (Node n1 = cpdDoc.getDocumentElement().getFirstChild(); n1 != null; n1 = n1.getNextSibling()) {
                        if (n1.getNodeType() != 1 || !n1.getNodeName().equals("controls")) continue;
                        for (Node n2 = n1.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                            Element control;
                            String type;
                            if (n2.getNodeType() != 1 || !n2.getNodeName().equals("control") || (type = (control = (Element)n2).getAttribute("type")) == null) continue;
                            if (type.equals("edit")) {
                                String editAtt = control.getAttribute("include");
                                this.editable = editAtt != null && editAtt.equals("yes") ? "true" : "false";
                                continue;
                            }
                            if (type.equals("about")) {
                                String aboutAtt = control.getAttribute("include");
                                this.hasAbout = aboutAtt != null && aboutAtt.equals("yes") ? "true" : "false";
                                continue;
                            }
                            if (!type.equals("help")) continue;
                            String helpAtt = control.getAttribute("include");
                            this.hasHelp = helpAtt != null && helpAtt.equals("yes") ? "true" : "false";
                        }
                    }
                }
            }
            catch (PortalException portalException) {
                // empty catch block
            }
        }

        protected void setChannelDefinition(Element channelE) throws PortalException {
            this.ID = channelE.getAttribute("ID");
            this.typeID = channelE.getAttribute("typeID");
            this.name = channelE.getAttribute("name");
            this.description = channelE.getAttribute("description");
            this.title = channelE.getAttribute("title");
            this.timeout = channelE.getAttribute("timeout");
            this.fname = channelE.getAttribute("fname");
            this.javaClass = channelE.getAttribute("class");
            this.editable = channelE.getAttribute("editable");
            this.hasHelp = channelE.getAttribute("hasHelp");
            this.hasAbout = channelE.getAttribute("hasAbout");
            this.secure = channelE.getAttribute("secure");
            for (Node n = channelE.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getNodeName().equals("parameter")) continue;
                Element parameterE = (Element)n;
                String name = parameterE.getAttribute("name");
                String value = parameterE.getAttribute("value");
                String override = parameterE.getAttribute("override");
                this.parameters.put(name, new Parameter(name, value, override));
            }
        }

        protected Element toXML() {
            Element channelE = emptyDoc.createElement("channel");
            this.setAttribute(channelE, "ID", this.ID);
            this.setAttribute(channelE, "typeID", this.typeID);
            this.setAttribute(channelE, "name", this.name);
            this.setAttribute(channelE, "description", this.description);
            this.setAttribute(channelE, "title", this.title);
            this.setAttribute(channelE, "fname", this.fname);
            this.setAttribute(channelE, "class", this.javaClass);
            this.setAttribute(channelE, "timeout", this.timeout);
            this.setAttribute(channelE, "editable", this.editable);
            this.setAttribute(channelE, "hasAbout", this.hasAbout);
            this.setAttribute(channelE, "hasHelp", this.hasHelp);
            this.setAttribute(channelE, "secure", this.secure);
            Iterator iter = this.parameters.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Parameter param = (Parameter)this.parameters.get(name);
                Element parameterE = emptyDoc.createElement("parameter");
                parameterE.setAttribute("name", param.getName());
                parameterE.setAttribute("value", param.getValue());
                parameterE.setAttribute("override", param.getOverride());
                channelE.appendChild(parameterE);
            }
            return channelE;
        }

        protected class Parameter {
            protected String name;
            protected String value;
            protected String override;

            protected Parameter(String name, String value, String override) {
                this.name = name;
                this.value = value;
                this.override = override;
            }

            protected String getName() {
                return this.name;
            }

            protected String getValue() {
                return this.value;
            }

            protected String getOverride() {
                return this.override;
            }

            protected void setName(String name) {
                this.name = name;
            }

            protected void setValue(String value) {
                this.value = value;
            }

            protected void setOverride(String override) {
                this.override = override;
            }
        }
    }

    protected class WorkflowStep {
        protected String ID;
        protected String name;
        protected List dataElements;

        protected WorkflowStep(String ID2, String name) {
            this.ID = ID2;
            this.name = name;
            this.dataElements = new ArrayList();
        }

        protected String getID() {
            return this.ID;
        }

        protected String getName() {
            return this.name;
        }

        protected void setID(String ID2) {
            this.ID = ID2;
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void addDataElement(Element dataElement) {
            this.dataElements.add(dataElement);
        }

        protected Element toXML(Document doc) {
            Element stepE = doc.createElement("step");
            Element IDE = doc.createElement("ID");
            IDE.appendChild(doc.createTextNode(this.ID));
            stepE.appendChild(IDE);
            Element nameE = doc.createElement("name");
            nameE.appendChild(doc.createTextNode(this.name));
            stepE.appendChild(nameE);
            Iterator iter = this.dataElements.iterator();
            while (iter.hasNext()) {
                stepE.appendChild(doc.importNode((Element)iter.next(), true));
            }
            return stepE;
        }
    }

    protected class CPDWorkflowSection
    extends WorkflowSection {
        protected Document cpdDoc;

        protected CPDWorkflowSection(String chanTypeID) throws PortalException {
            this.cpdDoc = ChannelRegistryManager.getCPD(chanTypeID);
        }

        protected void addToStep(Element element, String stepID) {
            for (Node n1 = this.cpdDoc.getDocumentElement().getFirstChild(); n1 != null; n1 = n1.getNextSibling()) {
                if (n1.getNodeType() != 1 || !n1.getNodeName().equals("params")) continue;
                for (Node n2 = n1.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                    if (n2.getNodeType() != 1 || !n2.getNodeName().equals("step")) continue;
                    block2: for (Node n3 = n2.getFirstChild(); n3 != null; n3 = n3.getNextSibling()) {
                        if (n3.getNodeType() != 1 || !n3.getNodeName().equals("ID")) continue;
                        for (Node n4 = n3.getFirstChild(); n4 != null; n4 = n4.getNextSibling()) {
                            String ID2;
                            if (n4.getNodeType() != 3 || !(ID2 = n4.getNodeValue()).equals(stepID)) continue;
                            n2.appendChild(this.cpdDoc.importNode(element, true));
                            continue block2;
                        }
                    }
                }
            }
        }

        protected Element toXML(Document doc) {
            return (Element)doc.importNode(this.cpdDoc.getDocumentElement(), true);
        }
    }

    protected class WorkflowSection {
        protected String name;
        protected List steps;

        protected WorkflowSection() {
        }

        protected WorkflowSection(String name) {
            this.name = name;
            this.steps = new ArrayList();
        }

        protected void setName(String name) {
            this.name = name;
        }

        protected void addStep(WorkflowStep step) {
            this.steps.add(step);
        }

        protected Element toXML(Document doc) {
            Element sectionE = doc.createElement(this.name);
            Element paramsE = doc.createElement("params");
            sectionE.appendChild(paramsE);
            Iterator iter = this.steps.iterator();
            while (iter.hasNext()) {
                WorkflowStep step = (WorkflowStep)iter.next();
                paramsE.appendChild(step.toXML(doc));
            }
            return sectionE;
        }
    }

    protected class Workflow {
        protected WorkflowSection channelTypesSection;
        protected WorkflowSection generalSettingsSection;
        protected WorkflowSection channelParamsSection;
        protected WorkflowSection controlsSection;
        protected WorkflowSection categoriesSection;
        protected WorkflowSection groupsSection;
        protected WorkflowSection reviewSection;

        protected Workflow() {
        }

        protected void setChannelTypesSection(WorkflowSection channelTypesSection) {
            this.channelTypesSection = channelTypesSection;
        }

        protected void setGeneralSettingsSection(WorkflowSection generalSettingsSection) {
            this.generalSettingsSection = generalSettingsSection;
        }

        protected void setChannelParamsSection(WorkflowSection channelParamsSection) {
            this.channelParamsSection = channelParamsSection;
        }

        protected void setControlsSection(WorkflowSection controlsSection) {
            this.controlsSection = controlsSection;
        }

        protected void setCategoriesSection(WorkflowSection categoriesSection) {
            this.categoriesSection = categoriesSection;
        }

        protected void setGroupsSection(WorkflowSection groupsSection) {
            this.groupsSection = groupsSection;
        }

        protected void setReviewSection(WorkflowSection reviewSection) {
            this.reviewSection = reviewSection;
        }

        protected Document toXML() throws PortalException {
            Document doc = DocumentFactory.getNewDocument();
            Element channelManagerE = doc.createElement("manageChannels");
            doc.appendChild(channelManagerE);
            this.addSection(this.channelTypesSection, "selectChannelType", "Channel Type", channelManagerE);
            this.addSection(this.generalSettingsSection, "selectGeneralSettings", "General Settings", channelManagerE);
            this.addChannelParamsSection(channelManagerE);
            this.addSection(this.controlsSection, "selectControls", "Channel Controls", channelManagerE);
            this.addSection(this.categoriesSection, "selectCategories", "Categories", channelManagerE);
            this.addSection(this.groupsSection, "selectGroups", "Groups", channelManagerE);
            this.addSection(this.reviewSection, "reviewChannel", "Review", channelManagerE);
            return doc;
        }

        private void addSection(WorkflowSection section, String sectionElementName, String stepTitle, Element e) {
            if (section == null) {
                section = new WorkflowSection(sectionElementName);
                section.addStep(new WorkflowStep("1", stepTitle));
            }
            e.appendChild(section.toXML(e.getOwnerDocument()));
        }

        private void addChannelParamsSection(Element e) throws PortalException {
            if (this.channelParamsSection == null) {
                String channelTypeID = CChannelManager.this.channelDef.getTypeID();
                if (channelTypeID != null) {
                    if (channelTypeID.equals("-1")) {
                        WorkflowSection csSection = new WorkflowSection("customSettings");
                        WorkflowStep step = new WorkflowStep("1", "Channel Parameters");
                        csSection.addStep(step);
                        this.setChannelParamsSection(csSection);
                    } else {
                        CPDWorkflowSection cpdSection = new CPDWorkflowSection(CChannelManager.this.channelDef.getTypeID());
                        this.setChannelParamsSection(cpdSection);
                    }
                } else {
                    return;
                }
            }
            e.appendChild(this.channelParamsSection.toXML(e.getOwnerDocument()));
        }
    }

    protected class ModifyChannelSettings {
        private String recordsPerPage = "15";
        private String currentPage = "1";
        private String filterByID = "-1";

        protected ModifyChannelSettings() {
        }

        protected String getRecordsPerPage() {
            return this.recordsPerPage;
        }

        protected String getCurrentPage() {
            return this.currentPage;
        }

        protected String getFilterByID() {
            return this.filterByID;
        }

        protected void setRecordsPerPage(String recordsPerPage) {
            this.recordsPerPage = recordsPerPage;
        }

        protected void setCurrentPage(String currentPage) {
            this.currentPage = currentPage;
        }

        protected void setFilterByID(String filterByID) {
            this.filterByID = filterByID;
        }
    }
}

