/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.ICharacterChannel;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.InternalTimeoutException;
import org.jasig.portal.MediaManager;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.serialize.BaseMarkupSerializer;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CError
extends BaseChannel
implements IPrivilegedChannel,
ICacheable,
ICharacterChannel {
    public static final int GENERAL_ERROR = 0;
    public static final int RENDER_TIME_EXCEPTION = 1;
    public static final int SET_STATIC_DATA_EXCEPTION = 2;
    public static final int SET_RUNTIME_DATA_EXCEPTION = 3;
    public static final int TIMEOUT_EXCEPTION = 4;
    public static final int SET_PCS_EXCEPTION = 5;
    public static final int CHANNEL_AUTHORIZATION_EXCEPTION = 6;
    public static final int CHANNEL_MISSING_EXCEPTION = 7;
    public static final int GENERAL_RENDERING_EXCEPTION = 1;
    public static final int INTERNAL_TIMEOUT_EXCEPTION = 2;
    public static final int AUTHORIZATION_EXCEPTION = 3;
    public static final int RESOURCE_MISSING_EXCEPTION = 4;
    protected Throwable channelException = null;
    protected String str_channelSubscribeId = null;
    protected String str_message = null;
    protected IChannel the_channel = null;
    protected int errorID = -1;
    protected boolean placeHolder = false;
    private boolean showStackTrace = false;
    private String ssTitle = null;
    private PortalControlStructures portcs;
    private static final String sslLocation = "CError/CError.ssl";
    protected static MediaManager mediaM = new MediaManager();

    public CError() {
    }

    public CError(int errorCode, Throwable exception, String channelSubscribeId, IChannel channelInstance) {
        this();
        this.str_channelSubscribeId = channelSubscribeId;
        this.channelException = exception;
        this.the_channel = channelInstance;
        this.errorID = errorCode;
    }

    public CError(int errorCode, String message, String channelSubscribeId, IChannel channelInstance) {
        this();
        this.str_channelSubscribeId = channelSubscribeId;
        this.str_message = message;
        this.the_channel = channelInstance;
        this.errorID = errorCode;
    }

    public CError(int errorCode, Throwable exception, String channelSubscribeId, IChannel channelInstance, String message) {
        this(errorCode, exception, channelSubscribeId, channelInstance);
        this.setMessage(message);
    }

    public void setMessage(String m) {
        this.str_message = m;
    }

    private void resetCError(int errorCode, Throwable exception, String channelSubscribeId, IChannel channelInstance, String message) {
        this.str_channelSubscribeId = channelSubscribeId;
        this.channelException = exception;
        this.the_channel = channelInstance;
        this.errorID = errorCode;
        this.str_message = message;
    }

    public void setPortalControlStructures(PortalControlStructures pcs) {
        this.portcs = pcs;
    }

    public void setStaticData(ChannelStaticData sd) {
        this.str_message = sd.getParameter("CErrorMessage");
        this.str_channelSubscribeId = sd.getParameter("CErrorChanId");
        String value = sd.getParameter("CErrorErrorId");
        if (value != null) {
            this.errorID = Integer.parseInt(value);
        }
        this.placeHolder = true;
    }

    public void renderXML(ContentHandler out) {
        block15: {
            String chFate;
            if (this.str_channelSubscribeId != null && (chFate = this.runtimeData.getParameter("action")) != null) {
                if (chFate.equals("retry")) {
                    LogService.log(LogService.DEBUG, "CError:setRuntimeData() : going for retry");
                    ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                    crd.clear();
                    try {
                        if (this.the_channel instanceof IPrivilegedChannel) {
                            ((IPrivilegedChannel)this.the_channel).setPortalControlStructures(this.portcs);
                        }
                        this.the_channel.setRuntimeData(crd);
                        ChannelManager cm = this.portcs.getChannelManager();
                        cm.setChannelInstance(this.str_channelSubscribeId, this.the_channel);
                        this.the_channel.renderXML(out);
                        return;
                    }
                    catch (Exception e) {
                        this.resetCError(3, e, this.str_channelSubscribeId, this.the_channel, "Channel failed a refresh attempt.");
                    }
                } else if (chFate.equals("restart")) {
                    LogService.log(LogService.DEBUG, "CError:setRuntimeData() : going for reinstantiation");
                    ChannelManager cm = this.portcs.getChannelManager();
                    ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                    crd.clear();
                    try {
                        this.the_channel = cm.instantiateChannel(this.str_channelSubscribeId);
                        if (this.the_channel == null) {
                            this.resetCError(0, null, this.str_channelSubscribeId, null, "Channel failed to reinstantiate!");
                            break block15;
                        }
                        try {
                            if (this.the_channel instanceof IPrivilegedChannel) {
                                ((IPrivilegedChannel)this.the_channel).setPortalControlStructures(this.portcs);
                            }
                            this.the_channel.setRuntimeData(crd);
                            this.the_channel.renderXML(out);
                            return;
                        }
                        catch (Exception e) {
                            this.resetCError(3, e, this.str_channelSubscribeId, this.the_channel, "Channel failed a reload attempt.");
                            cm.setChannelInstance(this.str_channelSubscribeId, this);
                            LogService.log(LogService.ERROR, "CError::setRuntimeData() : an error occurred during channel reinitialization. " + e);
                        }
                    }
                    catch (Exception e) {
                        this.resetCError(0, e, this.str_channelSubscribeId, null, "Channel failed to reinstantiate!");
                        LogService.log(LogService.ERROR, "CError::setRuntimeData() : an error occurred during channel reinstantiation. " + e);
                    }
                } else if (chFate.equals("toggle_stack_trace")) {
                    this.showStackTrace = !this.showStackTrace;
                }
            }
        }
        this.localRenderXML(out);
    }

    private void localRenderXML(ContentHandler out) {
        Document doc = DocumentFactory.getNewDocument();
        Element errorEl = doc.createElement("error");
        errorEl.setAttribute("code", Integer.toString(this.errorID));
        if (this.str_message != null) {
            Element messageEl = doc.createElement("message");
            messageEl.appendChild(doc.createTextNode(this.str_message));
            errorEl.appendChild(messageEl);
        }
        if (this.str_channelSubscribeId != null) {
            Element channelEl = doc.createElement("channel");
            Element idEl = doc.createElement("id");
            idEl.appendChild(doc.createTextNode(this.str_channelSubscribeId));
            channelEl.appendChild(idEl);
            if (this.portcs != null) {
                String chName = null;
                try {
                    chName = this.portcs.getUserPreferencesManager().getUserLayoutManager().getNode(this.str_channelSubscribeId).getName();
                }
                catch (Exception e) {
                    chName = "undetermined name";
                }
                if (chName != null) {
                    Element nameEl = doc.createElement("name");
                    nameEl.appendChild(doc.createTextNode(chName));
                    channelEl.appendChild(nameEl);
                }
                errorEl.appendChild(channelEl);
            }
        }
        if (this.channelException != null) {
            PortalException pe;
            Exception realException;
            Element excEl = doc.createElement("exception");
            String m = this.channelException.getMessage();
            if (m != null) {
                Element emEl = doc.createElement("message");
                emEl.appendChild(doc.createTextNode(m));
                excEl.appendChild(emEl);
            }
            Element stEl = doc.createElement("stack");
            Element oeEl = doc.createElement("outerException");
            StringWriter sw = new StringWriter();
            this.channelException.printStackTrace(new PrintWriter(sw));
            sw.flush();
            oeEl.appendChild(doc.createTextNode(sw.toString()));
            stEl.appendChild(oeEl);
            if (this.channelException instanceof PortalException && (realException = (pe = (PortalException)this.channelException).getRecordedException()) != null) {
                Element ieEl = doc.createElement("innerException");
                StringWriter sw2 = new StringWriter();
                realException.printStackTrace(new PrintWriter(sw2));
                ieEl.appendChild(doc.createTextNode(sw2.toString()));
                stEl.appendChild(ieEl);
            }
            excEl.appendChild(stEl);
            if (this.channelException instanceof PortalException) {
                pe = (PortalException)this.channelException;
                excEl.setAttribute("code", Integer.toString(0));
                if (pe instanceof ResourceMissingException) {
                    excEl.setAttribute("code", Integer.toString(4));
                    ResourceMissingException rme = (ResourceMissingException)pe;
                    Element resourceEl = doc.createElement("resource");
                    Element uriEl = doc.createElement("uri");
                    uriEl.appendChild(doc.createTextNode(rme.getResourceURI()));
                    resourceEl.appendChild(uriEl);
                    Element descriptionEl = doc.createElement("description");
                    descriptionEl.appendChild(doc.createTextNode(rme.getResourceDescription()));
                    resourceEl.appendChild(descriptionEl);
                    excEl.appendChild(resourceEl);
                } else if (pe instanceof InternalTimeoutException) {
                    excEl.setAttribute("code", Integer.toString(2));
                    Long v = ((InternalTimeoutException)pe).getTimeoutValue();
                    if (v != null) {
                        Element timeoutEl = doc.createElement("timeout");
                        timeoutEl.setAttribute("value", v.toString());
                    }
                } else if (pe instanceof AuthorizationException) {
                    excEl.setAttribute("code", Integer.toString(3));
                }
            } else {
                excEl.setAttribute("code", "-1");
            }
            errorEl.appendChild(excEl);
        }
        doc.appendChild(errorEl);
        String allowRef = "true";
        String allowRel = "true";
        if (this.str_channelSubscribeId == null) {
            allowRef = "false";
            allowRel = "false";
        } else if (this.channelException != null && this.channelException instanceof PortalException) {
            if (this.errorID == 2 || !((PortalException)this.channelException).allowRefresh()) {
                allowRef = "false";
            }
            if (!((PortalException)this.channelException).allowReinstantiation()) {
                allowRel = "false";
            }
        }
        if (this.placeHolder) {
            allowRef = "false";
            allowRel = "false";
        }
        this.ssTitle = "friendly";
        try {
            AuthorizationService authService = AuthorizationService.instance();
            EntityIdentifier ei = this.portcs.getUserPreferencesManager().getPerson().getEntityIdentifier();
            IAuthorizationPrincipal ap = authService.newPrincipal(ei.getKey(), ei.getType());
            if (ap.hasPermission("UP_ERROR_CHAN", "VIEW", "DETAILS")) {
                this.ssTitle = "detailed";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            StringWriter outString = new StringWriter();
            OutputFormat format = new OutputFormat();
            format.setOmitXMLDeclaration(true);
            format.setIndenting(true);
            XMLSerializer xsl = new XMLSerializer((Writer)outString, format);
            xsl.serialize(doc);
            LogService.log(LogService.DEBUG, outString.toString());
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
        }
        try {
            XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
            xslt.setXML(doc);
            xslt.setXSL(sslLocation, this.ssTitle, this.runtimeData.getBrowserInfo());
            xslt.setTarget(out);
            xslt.setStylesheetParameter("baseActionURL", this.runtimeData.getBaseActionURL());
            xslt.setStylesheetParameter("showStackTrace", String.valueOf(this.showStackTrace));
            xslt.setStylesheetParameter("allowRefresh", allowRef);
            xslt.setStylesheetParameter("allowReinstantiation", allowRel);
            xslt.transform();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sw.flush();
            LogService.log(LogService.ERROR, "CError::renderXML() : Things are bad. Error channel threw: " + sw.toString());
        }
    }

    public ChannelCacheKey generateKey() {
        if (this.runtimeData.getParameter("action") != null) {
            return null;
        }
        ChannelCacheKey k = new ChannelCacheKey();
        StringBuffer sbKey = new StringBuffer(1024);
        k.setKeyScope(1);
        sbKey.append("org.jasig.portal.channels.CError: errorId=").append(Integer.toString(this.errorID)).append(", channelID=");
        sbKey.append(this.str_channelSubscribeId).append(", message=").append(this.str_message).append(" strace=").append(this.toString(this.showStackTrace));
        sbKey.append(", mode=").append(this.ssTitle);
        if (this.channelException != null) {
            sbKey.append("exception: ");
            sbKey.append(this.channelException.getMessage());
            if (this.channelException instanceof PortalException) {
                PortalException pe = (PortalException)this.channelException;
                sbKey.append(this.toString(pe.allowRefresh())).append(this.toString(pe.allowReinstantiation())).append(" ");
                if (pe.getRecordedException() != null) {
                    sbKey.append(pe.getRecordedException().getMessage());
                }
                if (this.channelException instanceof ResourceMissingException) {
                    ResourceMissingException rme = (ResourceMissingException)pe;
                    sbKey.append("resource: ").append(rme.getResourceURI()).append(rme.getResourceDescription());
                } else if (this.channelException instanceof InternalTimeoutException) {
                    sbKey.append("timeout: ").append(((InternalTimeoutException)this.channelException).getTimeoutValue().toString());
                }
            }
        }
        sbKey.append(", locales=").append(LocaleManager.stringValueOf(this.runtimeData.getLocales()));
        k.setKey(sbKey.toString());
        return k;
    }

    public boolean isCacheValid(Object validity) {
        return true;
    }

    private String toString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public void renderCharacters(PrintWriter out) throws PortalException {
        block22: {
            String chFate;
            if (this.str_channelSubscribeId != null && (chFate = this.runtimeData.getParameter("action")) != null) {
                if (chFate.equals("retry")) {
                    LogService.log(LogService.DEBUG, "CError:renderCharacters() : going for retry");
                    ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                    crd.clear();
                    try {
                        if (this.the_channel instanceof IPrivilegedChannel) {
                            ((IPrivilegedChannel)this.the_channel).setPortalControlStructures(this.portcs);
                        }
                        this.the_channel.setRuntimeData(crd);
                        ChannelManager cm = this.portcs.getChannelManager();
                        cm.setChannelInstance(this.str_channelSubscribeId, this.the_channel);
                        if (this.the_channel instanceof ICharacterChannel) {
                            ((ICharacterChannel)this.the_channel).renderCharacters(out);
                        } else {
                            ThemeStylesheetDescription tsd = this.portcs.getUserPreferencesManager().getThemeStylesheetDescription();
                            BaseMarkupSerializer serOut = mediaM.getSerializerByName(tsd.getSerializerName(), out);
                            this.the_channel.renderXML(serOut);
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.resetCError(3, e, this.str_channelSubscribeId, this.the_channel, "Channel failed a refresh attempt.");
                    }
                } else if (chFate.equals("restart")) {
                    LogService.log(LogService.DEBUG, "CError:renderCharacters() : going for reinstantiation");
                    ChannelManager cm = this.portcs.getChannelManager();
                    ChannelRuntimeData crd = (ChannelRuntimeData)this.runtimeData.clone();
                    crd.clear();
                    try {
                        this.the_channel = cm.instantiateChannel(this.str_channelSubscribeId);
                        if (this.the_channel == null) {
                            this.resetCError(0, null, this.str_channelSubscribeId, null, "Channel failed to reinstantiate!");
                            break block22;
                        }
                        try {
                            if (this.the_channel instanceof IPrivilegedChannel) {
                                ((IPrivilegedChannel)this.the_channel).setPortalControlStructures(this.portcs);
                            }
                            this.the_channel.setRuntimeData(crd);
                            if (this.the_channel instanceof ICharacterChannel) {
                                ((ICharacterChannel)this.the_channel).renderCharacters(out);
                            } else {
                                ThemeStylesheetDescription tsd = this.portcs.getUserPreferencesManager().getThemeStylesheetDescription();
                                BaseMarkupSerializer serOut = mediaM.getSerializerByName(tsd.getSerializerName(), out);
                                this.the_channel.renderXML(serOut);
                            }
                            return;
                        }
                        catch (Exception e) {
                            this.resetCError(3, e, this.str_channelSubscribeId, this.the_channel, "Channel failed a reload attempt.");
                            cm.setChannelInstance(this.str_channelSubscribeId, this);
                            LogService.log(LogService.ERROR, "CError::renderCharacters() : an error occurred during channel reinitialization. " + e);
                        }
                    }
                    catch (Exception e) {
                        this.resetCError(0, e, this.str_channelSubscribeId, null, "Channel failed to reinstantiate!");
                        LogService.log(LogService.ERROR, "CError::renderCharacters() : an error occurred during channel reinstantiation. " + e);
                    }
                } else if (chFate.equals("toggle_stack_trace")) {
                    this.showStackTrace = !this.showStackTrace;
                }
            }
        }
        BaseMarkupSerializer serOut = null;
        try {
            ThemeStylesheetDescription tsd = this.portcs.getUserPreferencesManager().getThemeStylesheetDescription();
            serOut = mediaM.getSerializerByName(tsd.getSerializerName(), out);
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, "CError::renderCharacters() : unable to obtain proper markup serializer : " + e);
        }
        if (serOut == null) {
            org.jasig.portal.serialize.OutputFormat frmt = new org.jasig.portal.serialize.OutputFormat("XML", "UTF-8", true);
            serOut = new org.jasig.portal.serialize.XMLSerializer(out, frmt);
        }
        this.localRenderXML(serOut);
    }
}

