/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels;

import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IPrivilegedChannel;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.utils.DocumentFactory;
import org.jasig.portal.utils.XSLT;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;

public class CSnoop
implements IPrivilegedChannel {
    private PortalControlStructures pcs;
    private ChannelStaticData staticData = new ChannelStaticData();
    private ChannelRuntimeData runtimeData = new ChannelRuntimeData();
    private static final String sslLocation = "CSnoop/CSnoop.ssl";

    public void setPortalControlStructures(PortalControlStructures pcs) {
        this.pcs = pcs;
    }

    public ChannelRuntimeProperties getRuntimeProperties() {
        return new ChannelRuntimeProperties();
    }

    public void receiveEvent(PortalEvent ev) {
    }

    public void setStaticData(ChannelStaticData sd) {
        this.staticData = sd;
    }

    public void setRuntimeData(ChannelRuntimeData rd) {
        this.runtimeData = rd;
    }

    public void renderXML(ContentHandler out) throws PortalException {
        HttpServletRequest request = this.pcs.getHttpServletRequest();
        Document doc = DocumentFactory.getNewDocument();
        Element snooperE = doc.createElement("snooper");
        Element requestInfoE = doc.createElement("request-info");
        Element requestProtocolE = doc.createElement("request-protocol");
        requestProtocolE.appendChild(doc.createTextNode(request.getProtocol()));
        requestInfoE.appendChild(requestProtocolE);
        Element requestMethodE = doc.createElement("request-method");
        requestMethodE.appendChild(doc.createTextNode(request.getMethod()));
        requestInfoE.appendChild(requestMethodE);
        Element serverNameE = doc.createElement("server-name");
        serverNameE.appendChild(doc.createTextNode(request.getServerName()));
        requestInfoE.appendChild(serverNameE);
        Element serverPortE = doc.createElement("server-port");
        serverPortE.appendChild(doc.createTextNode(String.valueOf(request.getServerPort())));
        requestInfoE.appendChild(serverPortE);
        Element requestUriE = doc.createElement("request-uri");
        requestUriE.appendChild(doc.createTextNode(request.getRequestURI()));
        requestInfoE.appendChild(requestUriE);
        Element contextPathE = doc.createElement("context-path");
        contextPathE.appendChild(doc.createTextNode(request.getContextPath()));
        requestInfoE.appendChild(contextPathE);
        Element servletPathE = doc.createElement("servlet-path");
        servletPathE.appendChild(doc.createTextNode(request.getServletPath()));
        requestInfoE.appendChild(servletPathE);
        Element queryStringE = doc.createElement("query-string");
        queryStringE.appendChild(doc.createTextNode(request.getQueryString()));
        requestInfoE.appendChild(queryStringE);
        Element pathInfoE = doc.createElement("path-info");
        pathInfoE.appendChild(doc.createTextNode(request.getPathInfo()));
        requestInfoE.appendChild(pathInfoE);
        Element pathTranslatedE = doc.createElement("path-translated");
        pathTranslatedE.appendChild(doc.createTextNode(request.getPathTranslated()));
        requestInfoE.appendChild(pathTranslatedE);
        Element contentLengthE = doc.createElement("content-length");
        contentLengthE.appendChild(doc.createTextNode(String.valueOf(request.getContentLength())));
        requestInfoE.appendChild(contentLengthE);
        Element contentTypeE = doc.createElement("content-type");
        contentTypeE.appendChild(doc.createTextNode(request.getContentType()));
        requestInfoE.appendChild(contentTypeE);
        Element remoteUserE = doc.createElement("remote-user");
        remoteUserE.appendChild(doc.createTextNode(request.getRemoteUser()));
        requestInfoE.appendChild(remoteUserE);
        Element remoteAddressE = doc.createElement("remote-address");
        remoteAddressE.appendChild(doc.createTextNode(request.getRemoteAddr()));
        requestInfoE.appendChild(remoteAddressE);
        Element remoteHostE = doc.createElement("remote-host");
        remoteHostE.appendChild(doc.createTextNode(request.getRemoteHost()));
        requestInfoE.appendChild(remoteHostE);
        Element authorizationSchemeE = doc.createElement("authorization-scheme");
        authorizationSchemeE.appendChild(doc.createTextNode(request.getAuthType()));
        requestInfoE.appendChild(authorizationSchemeE);
        Element localeE = doc.createElement("locale");
        localeE.appendChild(doc.createTextNode(request.getLocale().toString()));
        requestInfoE.appendChild(localeE);
        Element headersE = doc.createElement("headers");
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            Element headerE = doc.createElement("header");
            headerE.setAttribute("name", name);
            headerE.appendChild(doc.createTextNode(value));
            headersE.appendChild(headerE);
        }
        requestInfoE.appendChild(headersE);
        snooperE.appendChild(requestInfoE);
        Element channelRuntimeDataE = doc.createElement("channel-runtime-data");
        Locale[] locales = this.runtimeData.getLocales();
        if (locales == null) {
            locales = new Locale[]{Locale.getDefault()};
        }
        Element localesE = LocaleManager.xmlValueOf(locales).getDocumentElement();
        channelRuntimeDataE.appendChild(doc.importNode(localesE, true));
        snooperE.appendChild(channelRuntimeDataE);
        doc.appendChild(snooperE);
        XSLT xslt = XSLT.getTransformer(this, this.runtimeData.getLocales());
        xslt.setXML(doc);
        xslt.setXSL(sslLocation, this.runtimeData.getBrowserInfo());
        xslt.setTarget(out);
        xslt.transform();
    }
}

