/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager;

import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IMultithreadedChannel;
import org.jasig.portal.IServant;
import org.jasig.portal.MultithreadedCacheableChannelAdapter;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.groupsmanager.CGroupsManager;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerCommandFactory;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerCommand;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.groups.IGroupMember;

public class CGroupsManagerServant
extends MultithreadedCacheableChannelAdapter
implements IServant {
    final IMultithreadedChannel channel;
    final String uid;

    public CGroupsManagerServant(IMultithreadedChannel channel, String uid) {
        super(channel, uid);
        this.channel = channel;
        this.uid = uid;
    }

    public boolean isFinished() {
        CGroupsManagerSessionData sessionData = this.getSessionData();
        ChannelStaticData staticData = sessionData.staticData;
        boolean isFinished = false;
        if (staticData.containsKey("groupManagerFinished") && staticData.getParameter("groupManagerFinished").equals("true")) {
            isFinished = true;
        }
        return isFinished;
    }

    CGroupsManagerSessionData getSessionData() {
        return ((CGroupsManager)this.channel).getSessionData(this.uid);
    }

    public void setStaticData(ChannelStaticData sd) {
        try {
            this.channel.setStaticData(sd, this.uid);
            this.getSessionData().servantMode = true;
        }
        catch (PortalException pex) {
            Utility.logMessage("ERROR", this.getClass().getName() + ".setStaticData() : Unable to set static data for servant. " + "staticData parm = " + sd + "uid parm = " + this.uid, pex);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        PortalEvent ev = new PortalEvent(1);
        this.channel.receiveEvent(ev, this.uid);
    }

    public Object[] getResults() {
        CGroupsManagerSessionData sessionData = ((CGroupsManager)this.channel).getSessionData(this.uid);
        ChannelStaticData staticData = sessionData.staticData;
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        IGroupsManagerCommand cmd = GroupsManagerCommandFactory.get("Done");
        try {
            cmd.execute(sessionData);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", e.toString(), e);
            sessionData.feedback = "Error executing command Done: " + e.getMessage();
        }
        Object[] results = (Object[])staticData.get("princResults");
        if (results == null) {
            results = new IGroupMember[]{};
        }
        Utility.logMessage("DEBUG", "CGroupsManagerservant.getResults()");
        return results;
    }
}

