/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerUnrestrictedSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerConstants;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.services.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utility
implements GroupsManagerConstants {
    public static boolean areEqual(String one, String two) {
        String str1 = (one == null ? "" : one).trim();
        String str2 = (two == null ? "" : two).trim();
        return str1.equals(str2);
    }

    public static boolean notEmpty(String aString) {
        String testString = (aString == null ? "" : aString).trim();
        return !testString.equals("");
    }

    public static void logMessage(String msgTypeStr, String msg) {
        Utility.logMessage(msgTypeStr, msg, null);
    }

    public static void logMessage(String msgTypeStr, String msg, Throwable th) {
        boolean delay = false;
        Object msgType = msgTypeStr == null | msgTypeStr.equals("") ? LogService.DEBUG : Level.toLevel((String)msgTypeStr.toUpperCase());
        if (delay && msgTypeStr.toUpperCase().equals("DEBUG")) {
            long ts1;
            long ts2 = ts1 = Calendar.getInstance().getTime().getTime();
            while (ts2 <= ts1) {
                ts2 = Calendar.getInstance().getTime().getTime();
            }
        }
        LogService.log(msgType, msg);
        if (th != null) {
            LogService.log(msgType, th);
        }
    }

    public static String parseStringDelimitedBy(String fromDelim, String source, String toDelim) {
        Utility.logMessage("DEBUG", "Utility::parseStringDelimitedBy(): fromDelim = " + fromDelim + " source = " + source + " toDelim = " + toDelim);
        String parsedString = null;
        String tagString = null;
        int idxFrom = source.indexOf(fromDelim);
        if (idxFrom > -1) {
            tagString = source.substring(idxFrom);
            int idxTo = tagString.indexOf(toDelim);
            parsedString = idxTo < 0 ? tagString.substring(fromDelim.length()) : tagString.substring(fromDelim.length(), tagString.indexOf(toDelim));
        }
        Utility.logMessage("DEBUG", "Utility::parseStringDelimitedBy(): Returning parsedString = " + parsedString);
        return parsedString;
    }

    public static void printDoc(Document aDoc, String aMessage) {
        String aMsg = aMessage != null ? aMessage : "";
        try {
            Utility.logMessage("DEBUG", "****************************************");
            Utility.logMessage("DEBUG", aMsg + "\n" + Utility.toString(aDoc));
            Utility.logMessage("DEBUG", "########################################");
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", e.toString(), e);
        }
    }

    public static void printElement(Element anElem, String aMessage) {
        Document prtDoc = GroupsManagerXML.getNewDocument();
        Element cpy = (Element)prtDoc.importNode(anElem, true);
        prtDoc.appendChild(cpy);
        Utility.printDoc(prtDoc, aMessage);
    }

    public static IGroupMember retrieveGroupMemberForKeyAndType(String key, String type) {
        IGroupMember gm = null;
        if (type.equals("org.jasig.portal.groups.IEntityGroup")) {
            gm = GroupsManagerXML.retrieveGroup(key);
            Utility.logMessage("DEBUG", "Utility::retrieveGroupMemberForKeyAndType(): Retrieved group for Type: = " + type + " and key: " + key);
        } else {
            gm = GroupsManagerXML.retrieveEntity(key, type);
            Utility.logMessage("DEBUG", "Utility::retrieveGroupMemberForKeyAndType(): Retrieved entity for Type: = " + type + " and key: " + key);
        }
        return gm;
    }

    public static String toString(Document aDoc) {
        StringWriter sw = new StringWriter();
        try {
            XMLSerializer serial = new XMLSerializer((Writer)sw, new OutputFormat(aDoc, "UTF-8", true));
            serial.serialize(aDoc);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "Utility::asString(): " + e, e);
        }
        return sw.toString();
    }

    public static String translateKeytoID(String grpKey, CGroupsManagerUnrestrictedSessionData sd) {
        Document viewDoc = sd.model;
        String id = null;
        Iterator grpItr = GroupsManagerXML.getNodesByTagNameAndKey(viewDoc, "group", grpKey);
        IEntityGroup gm = GroupsManagerXML.retrieveGroup(grpKey);
        if (gm != null) {
            Element grpViewKeyElem;
            if (!grpItr.hasNext()) {
                grpViewKeyElem = GroupsManagerXML.getGroupMemberXml(gm, true, null, sd);
                Element rootElem = viewDoc.getDocumentElement();
                rootElem.appendChild(grpViewKeyElem);
            } else {
                grpViewKeyElem = (Element)grpItr.next();
                GroupsManagerXML.getGroupMemberXml(gm, true, grpViewKeyElem, sd);
            }
            id = grpViewKeyElem.getAttribute("id");
        }
        return id;
    }

    public static boolean hasValue(Object o) {
        boolean rval = false;
        if (o != null && !o.toString().trim().equals("")) {
            rval = true;
        }
        return rval;
    }

    public static boolean hasValue(Object o, String test) {
        boolean rval = false;
        if (Utility.hasValue(o) && String.valueOf(o).equals(test)) {
            rval = true;
        }
        return rval;
    }
}

