/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.commands;

import java.util.Iterator;
import java.util.Vector;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.commands.GroupsManagerCommand;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DoneWithSelection
extends GroupsManagerCommand {
    public void execute(CGroupsManagerSessionData sessionData) throws Exception {
        ChannelStaticData staticData = sessionData.staticData;
        Utility.logMessage("DEBUG", "DoneWithSelection::execute(): Start");
        String parentId = null;
        boolean hasParentId = this.hasParentId(staticData);
        Utility.logMessage("DEBUG", "DoneWithSelection::execute(): Parent ID is set: " + hasParentId);
        IGroupMember[] princResults = null;
        Document model = this.getXmlDoc(sessionData);
        Element rootElem = model.getDocumentElement();
        NodeList nGroupList = rootElem.getElementsByTagName("group");
        NodeList nEntityList = rootElem.getElementsByTagName("entity");
        Vector gmCollection = new Vector();
        Element parentElem = null;
        Utility.logMessage("DEBUG", "DoneWithSelection::execute(): Starting group process");
        this.addGroupMemberToCollection(gmCollection, nGroupList);
        Utility.logMessage("DEBUG", "DoneWithSelection::execute(): Starting entity process");
        this.addGroupMemberToCollection(gmCollection, nEntityList);
        if (gmCollection.size() < 1) {
            sessionData.feedback = sessionData.feedback + "\n No groups or people were selected! ";
            return;
        }
        if (hasParentId) {
            parentId = this.getParentId(staticData);
            Utility.logMessage("DEBUG", "DoneWithSelection::execute(): Parent ID is set to: " + parentId);
            parentElem = GroupsManagerXML.getElementByTagNameAndId(model, "group", parentId);
            if (parentElem == null) {
                Utility.logMessage("ERROR", "DoneWithSelection::execute: Error parent element not found");
                return;
            }
            this.addChildrenToGroup(gmCollection, sessionData, parentElem, model);
            this.clearSelected(sessionData);
            sessionData.mode = sessionData.returnToMode;
            sessionData.highlightedGroupID = parentId;
            sessionData.rootViewGroupID = null;
            GroupsManagerXML.refreshAllNodesRecursivelyIfRequired(sessionData.getUnrestrictedData(), parentElem);
            sessionData.staticData.remove("groupParentId");
        } else {
            princResults = gmCollection.toArray(new IGroupMember[0]);
            if (princResults.length > 0) {
                staticData.put("princResults", princResults);
                staticData.setParameter("groupManagerFinished", "true");
            }
        }
    }

    private void addGroupMemberToCollection(Vector gmCollection, NodeList nList) throws Exception {
        for (int i = 0; i < nList.getLength(); ++i) {
            Element elem = (Element)nList.item(i);
            if (!Utility.areEqual(elem.getAttribute("selected"), "true")) continue;
            boolean addit = true;
            Iterator gmItr = gmCollection.iterator();
            while (gmItr.hasNext()) {
                IGroupMember ggmm = (IGroupMember)gmItr.next();
                if (!ggmm.getKey().equals(elem.getAttribute("key")) || !ggmm.getType().equals(elem.getAttribute("type"))) continue;
                addit = false;
                break;
            }
            if (!addit) continue;
            IGroupMember gm = Utility.retrieveGroupMemberForKeyAndType(elem.getAttribute("key"), elem.getAttribute("type"));
            gmCollection.add(gm);
            Utility.logMessage("DEBUG", "DoneWithSelection::addGroupMemberToCollection(): - adding group member" + elem.getAttribute("key"));
        }
    }

    private void addChildrenToGroup(Vector gmCollection, CGroupsManagerSessionData sessionData, Element parentElem, Document model) throws Exception {
        ILockableEntityGroup parentGroup = null;
        IGroupMember childGm = null;
        parentGroup = sessionData.lockedGroup;
        Iterator gmItr = gmCollection.iterator();
        while (gmItr.hasNext()) {
            childGm = (IGroupMember)gmItr.next();
            Utility.logMessage("DEBUG", "DoneWithSelection::execute: About to add child");
            parentGroup.addMember(childGm);
            GroupsManagerXML.removePropertyElements(model, childGm, true);
            parentGroup.updateMembersAndRenewLock();
            Iterator parentNodes = GroupsManagerXML.getNodesByTagNameAndKey(model, "group", parentElem.getAttribute("key"));
            while (parentNodes.hasNext()) {
                Element parent = (Element)parentNodes.next();
                Element childElem = GroupsManagerXML.getGroupMemberXml(childGm, false, null, sessionData.getUnrestrictedData());
                parent.appendChild(childElem);
                parent.setAttribute("hasMembers", "true");
            }
        }
    }
}

