/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.commands;

import java.util.Iterator;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.channels.groupsmanager.CGroupsManagerSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.commands.GroupsManagerCommand;
import org.jasig.portal.groups.GroupsException;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoveMember
extends GroupsManagerCommand {
    public void execute(CGroupsManagerSessionData sessionData) throws Exception {
        ChannelRuntimeData runtimeData = sessionData.runtimeData;
        Utility.logMessage("DEBUG", "RemoveMember::execute(): Start");
        Document model = this.getXmlDoc(sessionData);
        String cmdIds = this.getCommandArg(runtimeData);
        ILockableEntityGroup parentGroup = null;
        IGroupMember childGm = null;
        String hasMbrs = "duh";
        Utility.logMessage("DEBUG", "RemoveMember::execute(): About to get parent and child keys");
        String parentID = Utility.parseStringDelimitedBy("parent.", cmdIds, "|");
        String childID = Utility.parseStringDelimitedBy("child.", cmdIds, "|");
        Utility.logMessage("DEBUG", "RemoveMember::execute(): Uid of parent element = " + parentID + " child element = " + childID);
        Element parentElem = GroupsManagerXML.getElementByTagNameAndId(model, "group", parentID);
        if (parentElem == null) {
            Utility.logMessage("ERROR", "RemoveMember::execute(): Unable to retrieve parent element!");
            return;
        }
        Utility.logMessage("DEBUG", "RemoveMember::execute(): About to get child element = " + childID);
        Element childElem = GroupsManagerXML.getElementById(model, childID);
        if (childElem == null) {
            Utility.logMessage("ERROR", "RemoveMember::execute(): Unable to retrieve Child element!");
            return;
        }
        childGm = GroupsManagerXML.retrieveGroupMemberForElementId(model, childID);
        parentGroup = sessionData.lockedGroup;
        this.removeChildFromGroup(parentGroup, childGm);
        hasMbrs = String.valueOf(((IEntityGroup)parentGroup).hasMembers());
        Utility.logMessage("DEBUG", "RemoveMember::execute(): Got the parent group ");
        Utility.logMessage("DEBUG", "RemoveMember::execute(): about to remove child elements");
        GroupsManagerXML.removePropertyElements(model, childGm, true);
        GroupsManagerXML.clearPropertiesCache(childGm);
        Iterator parentNodes = GroupsManagerXML.getNodesByTagNameAndKey(model, "group", parentElem.getAttribute("key"));
        while (parentNodes.hasNext()) {
            Node parentNode = (Node)parentNodes.next();
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!((Element)childNode).getAttribute("key").equals(childElem.getAttribute("key"))) continue;
                parentNode.removeChild(childNode);
                ((Element)parentNode).setAttribute("hasMembers", hasMbrs);
            }
        }
        Utility.logMessage("DEBUG", "RemoveMember::execute(): Completed");
    }

    private void removeChildFromGroup(Object parentGroup, IGroupMember childGm) throws Exception {
        Utility.logMessage("DEBUG", "RemoveMember::removeChildrenFromGroup(): about to remove child");
        if (parentGroup != null && childGm != null) {
            try {
                ((IEntityGroup)parentGroup).removeMember(childGm);
                ((ILockableEntityGroup)parentGroup).updateMembersAndRenewLock();
            }
            catch (GroupsException ge) {
                String aMsg = "Unable to remove child from parent/n" + ge;
                Utility.logMessage("ERROR", aMsg, ge);
            }
        } else {
            String suspect = parentGroup == null ? "Parent" : "Child";
            throw new Exception(suspect + " group member was not found");
        }
    }
}

