/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.groupsmanager.wrappers;

import org.jasig.portal.channels.groupsmanager.CGroupsManagerUnrestrictedSessionData;
import org.jasig.portal.channels.groupsmanager.GroupsManagerXML;
import org.jasig.portal.channels.groupsmanager.IGroupsManagerPermissions;
import org.jasig.portal.channels.groupsmanager.Utility;
import org.jasig.portal.channels.groupsmanager.wrappers.GroupMemberWrapper;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityWrapper
extends GroupMemberWrapper {
    public EntityWrapper() {
        this.ELEMENT_TAGNAME = "entity";
    }

    public Element getXml(IGroupMember gm, Element anElem, CGroupsManagerUnrestrictedSessionData sessionData) {
        Document aDoc = sessionData.model;
        Element rootElem = anElem != null ? anElem : GroupsManagerXML.createElement(this.ELEMENT_TAGNAME, aDoc, false);
        Utility.logMessage("DEBUG", "EntityWrapper.getXml(): START, Element: " + rootElem);
        try {
            IEntity ent = (IEntity)gm;
            rootElem.setAttribute("id", GroupsManagerXML.getNextUid());
            rootElem.setAttribute("key", gm.getKey());
            rootElem.setAttribute("type", gm.getLeafType().getName());
            rootElem.setAttribute("displayName", GroupsManagerXML.getEntityName(ent.getLeafType(), ent.getKey()));
            rootElem.setAttribute("selected", "false");
            IGroupsManagerPermissions gmp = sessionData.gmPermissions;
            IAuthorizationPrincipal ap = sessionData.authPrincipal;
            this.applyPermissions(rootElem, gm, gmp, ap);
        }
        catch (Exception e) {
            Utility.logMessage("ERROR", "EntityWrapper.getXml(): ERROR retrieving entity " + e, e);
        }
        return rootElem;
    }

    protected IGroupMember retrieveGroupMember(String aKey, String aType) {
        return GroupsManagerXML.retrieveEntity(aKey, aType);
    }
}

