/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channels.permissionsmanager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.jasig.portal.IPermissible;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.LogService;

public class RDBMPermissibleRegistry {
    private static RDBMPermissibleRegistry _instance;
    private HashMap owners = new HashMap();
    private static final String findPermissibles = "SELECT IPERMISSIBLE_CLASS FROM UPC_PERM_MGR";

    protected RDBMPermissibleRegistry() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        LogService.log(LogService.DEBUG, "PermissibleRegistryRDBM.init():: setting up registry");
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getConnection();
            st = conn.createStatement();
            ResultSet rs = st.executeQuery(findPermissibles);
            while (rs.next()) {
                String classname = rs.getString(1);
                try {
                    Class<?> newowner = Class.forName(classname);
                    this.owners.put(classname, newowner);
                }
                catch (Exception e) {
                    LogService.log(LogService.DEBUG, "PermissibleRegistryRDBM(): Could not instantiate IPermissible " + e);
                    this.unregister(classname);
                }
            }
            st.close();
        }
        catch (Exception e) {
            LogService.log(LogService.ERROR, e);
        }
        finally {
            this.releaseConnection(conn);
        }
        this.registerKnownPermissibles();
    }

    public static synchronized RDBMPermissibleRegistry instance() {
        if (_instance == null) {
            _instance = new RDBMPermissibleRegistry();
        }
        return _instance;
    }

    public static IPermissible[] getAllPermissible() {
        return RDBMPermissibleRegistry.instance().igetAllPermissible();
    }

    private IPermissible[] igetAllPermissible() {
        ArrayList<IPermissible> prms = new ArrayList<IPermissible>();
        Class[] pclasses = this.owners.values().toArray(new Class[this.owners.size()]);
        for (int i = 0; i < this.owners.size(); ++i) {
            try {
                IPermissible ip = (IPermissible)pclasses[i].newInstance();
                prms.add(ip);
                continue;
            }
            catch (Exception e) {
                LogService.log(LogService.DEBUG, "RDBMPermissibleRegistry.igetAllPermissible(): Unable to instantiate IPermissible " + e);
            }
        }
        return prms.toArray(new IPermissible[prms.size()]);
    }

    private void registerKnownPermissibles() {
        this.iregisterPermissible("org.jasig.portal.channels.permissionsmanager.PermissiblePublishChannels");
        this.iregisterPermissible("org.jasig.portal.channels.permissionsmanager.PermissibleSubscribeChannels");
        this.iregisterPermissible("org.jasig.portal.channels.groupsmanager.CGroupsManager");
    }

    public static void registerPermissible(String classname) {
        RDBMPermissibleRegistry.instance().iregisterPermissible(classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iregisterPermissible(String classname) {
        LogService.log(LogService.DEBUG, "PermissibleRegistryRDBM.registerpermissible():: processing " + classname);
        if (!this.owners.containsKey(classname)) {
            try {
                IPermissible ip = (IPermissible)Class.forName(classname).newInstance();
                Connection conn = null;
                Statement st = null;
                try {
                    conn = this.getConnection();
                    st = conn.createStatement();
                    st.executeUpdate("INSERT INTO UPC_PERM_MGR VALUES('" + classname + "')");
                    st.close();
                    this.owners.put(classname, Class.forName(classname));
                }
                catch (Exception e) {
                    LogService.log(LogService.ERROR, e);
                }
                finally {
                    this.releaseConnection(conn);
                }
            }
            catch (Throwable th) {
                LogService.log(LogService.DEBUG, "PermissibleRegistryRDBM.registerPermissible(): error while registering " + classname + " : " + th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(String permissibleClass) {
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getConnection();
            st = conn.createStatement();
            st.executeUpdate("DELETE FROM UPC_PERM_MGR WHERE IPERMISSIBLE_CLASS like '" + permissibleClass + "'");
            st.close();
            this.owners.remove(permissibleClass);
        }
        catch (Exception e) {
            LogService.log(LogService.DEBUG, e);
        }
        finally {
            this.releaseConnection(conn);
        }
    }

    protected Connection getConnection() {
        return RDBMServices.getConnection();
    }

    protected void releaseConnection(Connection conn) {
        RDBMServices.releaseConnection(conn);
    }
}

