/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.caching.CachedEntityInvalidation;
import org.jasig.portal.services.LogService;

public class RDBMCachedEntityInvalidationStore {
    private static RDBMCachedEntityInvalidationStore singleton;
    private static String ENTITY_INVALIDATION_TABLE;
    private static String ENTITY_TYPE_COLUMN;
    private static String ENTITY_KEY_COLUMN;
    private static String INVALIDATION_TIME_COLUMN;
    private static String ENTITY_CACHE_ID_COLUMN;
    private static String EQ;
    private static String NE;
    private static String GT;
    private static String LT;
    private static String QUOTE;
    private static String allTableColumns;
    private static String addSql;
    private static String updateSql;
    private static boolean timestampHasMillis;

    public RDBMCachedEntityInvalidationStore() throws CachingException {
        this.initialize();
    }

    public void add(CachedEntityInvalidation cachedEnt) throws CachingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            if (this.existsInStore(cachedEnt, conn)) {
                this.primUpdate(cachedEnt, conn);
            } else {
                this.primAdd(cachedEnt, conn);
            }
        }
        catch (SQLException sqle) {
            throw new CachingException("Problem adding " + cachedEnt + ": " + sqle.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    public void add(IBasicEntity entity, int cacheID) throws CachingException {
        CachedEntityInvalidation cachedEnt = this.newInstance(entity.getEntityIdentifier().getType(), entity.getEntityIdentifier().getKey(), new Date(), cacheID);
        this.add(cachedEnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws CachingException {
        Connection conn = null;
        Statement stmnt = null;
        try {
            String sql = "DELETE FROM " + ENTITY_INVALIDATION_TABLE;
            LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.deleteAll(): " + sql);
            conn = RDBMServices.getConnection();
            try {
                stmnt = conn.createStatement();
                int rc = stmnt.executeUpdate(sql);
                String msg = "Deleted " + rc + " rows.";
                LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.deleteAll(): " + msg);
            }
            finally {
                if (stmnt != null) {
                    stmnt.close();
                }
            }
        }
        catch (SQLException sqle) {
            try {
                throw new CachingException("Problem deleting locks: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                RDBMServices.releaseConnection(conn);
                throw throwable;
            }
        }
        RDBMServices.releaseConnection(conn);
    }

    public void deleteBefore(Date expiration) throws CachingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.primDeleteBefore(expiration, conn);
        }
        catch (SQLException sqle) {
            throw new CachingException("Problem deleting invalid entities: " + sqle.getMessage());
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private boolean existsInStore(CachedEntityInvalidation ent, Connection conn) throws CachingException {
        return this.select(ent.getType(), ent.getKey(), null, null, conn).length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedEntityInvalidation[] find(Class entityType, String entityKey) throws CachingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            CachedEntityInvalidation[] cachedEntityInvalidationArray = this.select(entityType, entityKey, null, null, conn);
            return cachedEntityInvalidationArray;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedEntityInvalidation[] findAfter(Date invalidation, Class entityType, String entityKey, Integer cacheID) throws CachingException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            CachedEntityInvalidation[] cachedEntityInvalidationArray = this.selectAfter(entityType, entityKey, invalidation, cacheID, conn);
            return cachedEntityInvalidationArray;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private static String getAddSql() {
        if (addSql == null) {
            addSql = "INSERT INTO " + ENTITY_INVALIDATION_TABLE + "(" + RDBMCachedEntityInvalidationStore.getAllTableColumns() + ") VALUES (?, ?, ?, ?)";
        }
        return addSql;
    }

    private static String getAllTableColumns() {
        if (allTableColumns == null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append(ENTITY_TYPE_COLUMN);
            buff.append(", ");
            buff.append(ENTITY_KEY_COLUMN);
            buff.append(", ");
            buff.append(INVALIDATION_TIME_COLUMN);
            buff.append(", ");
            buff.append(ENTITY_CACHE_ID_COLUMN);
            allTableColumns = buff.toString();
        }
        return allTableColumns;
    }

    private static String getDeleteInvalidationsSql() {
        return "DELETE FROM " + ENTITY_INVALIDATION_TABLE + " WHERE " + INVALIDATION_TIME_COLUMN + LT + "?";
    }

    private static String getSelectInvalidationsByTypeSql() {
        return RDBMCachedEntityInvalidationStore.getSelectSql() + " WHERE " + ENTITY_TYPE_COLUMN + EQ + "?" + " AND " + INVALIDATION_TIME_COLUMN + GT + "?";
    }

    private static String getSelectSql() {
        return "SELECT " + RDBMCachedEntityInvalidationStore.getAllTableColumns() + " FROM " + ENTITY_INVALIDATION_TABLE;
    }

    private static String getUpdateSql() {
        if (updateSql == null) {
            updateSql = "UPDATE " + ENTITY_INVALIDATION_TABLE + " SET " + INVALIDATION_TIME_COLUMN + EQ + "?," + ENTITY_CACHE_ID_COLUMN + EQ + "?" + " WHERE " + ENTITY_TYPE_COLUMN + EQ + "?" + " AND " + ENTITY_KEY_COLUMN + EQ + "?";
        }
        return updateSql;
    }

    private CachedEntityInvalidation instanceFromResultSet(ResultSet rs) throws SQLException, CachingException {
        Object entity = null;
        Integer entityTypeID = new Integer(rs.getInt(1));
        Class entityType = EntityTypes.getEntityType(entityTypeID);
        String key = rs.getString(2);
        Timestamp ts = rs.getTimestamp(3);
        Date dt = new Date(RDBMCachedEntityInvalidationStore.getTimestampMillis(ts));
        int cacheID = rs.getInt(4);
        return this.newInstance(entityType, key, dt, cacheID);
    }

    private CachedEntityInvalidation newInstance(Class type, String key, Date expiration, int cacheID) {
        return new CachedEntityInvalidation(type, key, expiration, cacheID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primAdd(CachedEntityInvalidation ent, Connection conn) throws SQLException, CachingException {
        Integer typeID = EntityTypes.getEntityTypeID(ent.getType());
        String key = ent.getKey();
        Timestamp ts = new Timestamp(ent.getInvalidationTime().getTime());
        int cacheID = ent.getCacheID();
        try {
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, RDBMCachedEntityInvalidationStore.getAddSql());
            try {
                ps.setInt(1, typeID);
                ps.setString(2, key);
                ps.setTimestamp(3, ts);
                ps.setInt(4, cacheID);
                LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.primAdd(): " + ps + " ( " + typeID + ", " + key + ", " + ts + " )");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem adding " + ent;
                    LogService.log(LogService.ERROR, errString);
                    throw new CachingException(errString);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primDeleteBefore(Date expiration, Connection conn) throws CachingException, SQLException {
        Timestamp ts = new Timestamp(expiration.getTime());
        try {
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, RDBMCachedEntityInvalidationStore.getDeleteInvalidationsSql());
            try {
                ps.setTimestamp(1, ts);
                LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.primDeleteBefore(): " + ps + " (" + ts + ")");
                int rc = ps.executeUpdate();
                LogService.log(LogService.DEBUG, "Rows deleted: " + rc);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedEntityInvalidation[] primSelect(String sql, Connection conn) throws CachingException {
        Statement stmnt = null;
        ResultSet rs = null;
        ArrayList<CachedEntityInvalidation> entities = new ArrayList<CachedEntityInvalidation>();
        LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.primSelect(): " + sql);
        try {
            stmnt = conn.createStatement();
            try {
                rs = stmnt.executeQuery(sql);
                try {
                    while (rs.next()) {
                        entities.add(this.instanceFromResultSet(rs));
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw new CachingException("Problem retrieving Invalid Entities " + sqle.getMessage());
        }
        return entities.toArray(new CachedEntityInvalidation[entities.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primUpdate(CachedEntityInvalidation ent, Connection conn) throws SQLException, CachingException {
        Integer typeID = EntityTypes.getEntityTypeID(ent.getType());
        String key = ent.getKey();
        Timestamp ts = new Timestamp(ent.getInvalidationTime().getTime());
        int cacheID = ent.getCacheID();
        try {
            RDBMServices.PreparedStatement ps = new RDBMServices.PreparedStatement(conn, RDBMCachedEntityInvalidationStore.getUpdateSql());
            try {
                ps.setTimestamp(1, ts);
                ps.setInt(2, cacheID);
                ps.setInt(3, typeID);
                ps.setString(4, key);
                LogService.log(LogService.DEBUG, "RDBMInvalidCacheableEntityStore.primUpdate(): " + ps + " ( " + typeID + ", " + key + ", " + ts + " )");
                int rc = ps.executeUpdate();
                if (rc != 1) {
                    String errString = "Problem updating " + ent;
                    LogService.log(LogService.ERROR, errString);
                    throw new CachingException(errString);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException sqle) {
            LogService.log(LogService.ERROR, sqle);
            throw sqle;
        }
    }

    private CachedEntityInvalidation[] select(Class entityType, String entityKey, Date invalidation, Integer cacheID, Connection conn) throws CachingException {
        StringBuffer sqlQuery = new StringBuffer(RDBMCachedEntityInvalidationStore.getSelectSql() + " WHERE 1 = 1");
        if (entityType != null) {
            Integer typeID = EntityTypes.getEntityTypeID(entityType);
            sqlQuery.append(" AND " + ENTITY_TYPE_COLUMN + EQ + typeID);
        }
        if (entityKey != null) {
            sqlQuery.append(" AND " + ENTITY_KEY_COLUMN + EQ + RDBMCachedEntityInvalidationStore.sqlQuote(entityKey));
        }
        if (invalidation != null) {
            Timestamp ts = new Timestamp(invalidation.getTime());
            sqlQuery.append(" AND " + INVALIDATION_TIME_COLUMN + EQ + RDBMCachedEntityInvalidationStore.printTimestamp(ts));
        }
        if (cacheID != null) {
            sqlQuery.append(" AND " + ENTITY_CACHE_ID_COLUMN + EQ + cacheID);
        }
        return this.primSelect(sqlQuery.toString(), conn);
    }

    private CachedEntityInvalidation[] selectAfter(Class entityType, String entityKey, Date invalidation, Integer cacheID, Connection conn) throws CachingException {
        StringBuffer sqlQuery = new StringBuffer(RDBMCachedEntityInvalidationStore.getSelectSql() + " WHERE 1 = 1");
        if (entityType != null) {
            Integer typeID = EntityTypes.getEntityTypeID(entityType);
            sqlQuery.append(" AND " + ENTITY_TYPE_COLUMN + EQ + typeID);
        }
        if (entityKey != null) {
            sqlQuery.append(" AND " + ENTITY_KEY_COLUMN + EQ + RDBMCachedEntityInvalidationStore.sqlQuote(entityKey));
        }
        if (invalidation != null) {
            Timestamp ts = new Timestamp(invalidation.getTime());
            sqlQuery.append(" AND " + INVALIDATION_TIME_COLUMN + GT + RDBMCachedEntityInvalidationStore.printTimestamp(ts));
        }
        if (cacheID != null) {
            sqlQuery.append(" AND " + ENTITY_CACHE_ID_COLUMN + NE + cacheID);
        }
        return this.primSelect(sqlQuery.toString(), conn);
    }

    public static synchronized RDBMCachedEntityInvalidationStore singleton() throws CachingException {
        if (singleton == null) {
            singleton = new RDBMCachedEntityInvalidationStore();
        }
        return singleton;
    }

    private static String sqlQuote(Object o) {
        return QUOTE + o + QUOTE;
    }

    private static long getTimestampMillis(Timestamp ts) {
        if (timestampHasMillis) {
            return ts.getTime();
        }
        return ts.getTime() + (long)(ts.getNanos() / 1000000);
    }

    private void initialize() throws CachingException {
        Date anHourAgo = new Date(System.currentTimeMillis() - 3600000L);
        this.deleteBefore(anHourAgo);
        Date testDate = new Date();
        Timestamp testTimestamp = new Timestamp(testDate.getTime());
        timestampHasMillis = testDate.getTime() == testTimestamp.getTime();
    }

    private static String printTimestamp(Timestamp ts) {
        return RDBMServices.sqlTimeStamp(RDBMCachedEntityInvalidationStore.getTimestampMillis(ts));
    }

    static {
        ENTITY_INVALIDATION_TABLE = "UP_ENTITY_CACHE_INVALIDATION";
        ENTITY_TYPE_COLUMN = "ENTITY_TYPE_ID";
        ENTITY_KEY_COLUMN = "ENTITY_KEY";
        INVALIDATION_TIME_COLUMN = "INVALIDATION_TIME";
        ENTITY_CACHE_ID_COLUMN = "ENTITY_CACHE_ID";
        EQ = " = ";
        NE = " != ";
        GT = " > ";
        LT = " < ";
        QUOTE = "'";
    }
}

