/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.EntityTypes;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.PropertiesManager;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.IEntityCache;
import org.jasig.portal.concurrency.IEntityCachingService;
import org.jasig.portal.concurrency.caching.ReferenceEntityCache;
import org.jasig.portal.concurrency.caching.ReferenceInvalidatingEntityCache;

public class ReferenceEntityCachingService
implements IEntityCachingService {
    private static IEntityCachingService singleton;
    private Map caches = new HashMap(10);
    boolean multiServer = false;
    int defaultMaxCacheSize = 1000;
    int defaultSweepIntervalMillis = 60000;
    int defaultMaxIdleTimeMillis = 1800000;
    int clockToleranceMillis = 5000;

    public ReferenceEntityCachingService() throws CachingException {
        this.initialize();
    }

    public void add(IBasicEntity ent) throws CachingException {
        this.getCache(ent.getEntityIdentifier().getType()).add(ent);
    }

    IEntityCache createCache(Class type) throws CachingException {
        int max = 0;
        int idle = 0;
        int interval = 0;
        String service = "org.jasig.portal.concurrency.IEntityCachingService";
        String sep = ".";
        try {
            max = PropertiesManager.getPropertyAsInt(service + sep + type.getName() + sep + "maxCacheSize");
        }
        catch (Exception e) {
            max = this.defaultMaxCacheSize;
        }
        try {
            idle = PropertiesManager.getPropertyAsInt(service + sep + type.getName() + sep + "MaxIdleTime");
            idle *= 1000;
        }
        catch (Exception e) {
            idle = this.defaultMaxIdleTimeMillis;
        }
        try {
            interval = PropertiesManager.getPropertyAsInt(service + sep + type.getName() + sep + "sweepInterval");
            interval *= 1000;
        }
        catch (Exception e) {
            interval = this.defaultSweepIntervalMillis;
        }
        return this.newCache(type, max, idle, interval);
    }

    private void createCaches() throws CachingException {
        Iterator types = EntityTypes.singleton().getAllEntityTypes();
        while (types.hasNext()) {
            Class type = (Class)types.next();
            IEntityCache cache = this.createCache(type);
            this.getCaches().put(type, cache);
        }
    }

    public IBasicEntity get(Class type, String key) throws CachingException {
        return this.getCache(type).get(key);
    }

    public IEntityCache getCache(Class type) throws CachingException {
        IEntityCache c = (IEntityCache)this.getCaches().get(type);
        if (c == null) {
            c = this.createCache(type);
            this.getCaches().put(type, c);
        }
        return c;
    }

    protected Map getCaches() {
        return this.caches;
    }

    private void initialize() throws CachingException {
        this.loadDefaultProperties();
    }

    private void loadDefaultProperties() {
        try {
            this.multiServer = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.concurrency.multiServer");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int defaultSweepIntervalSecs = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.IEntityCachingService.defaultSweepInterval");
            this.defaultSweepIntervalMillis = defaultSweepIntervalSecs * 1000;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.defaultMaxCacheSize = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.IEntityCachingService.defaultMaxCacheSize");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            int defaultMaxIdleTimeSecs = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.IEntityCachingService.defaultMaxIdleTime");
            this.defaultMaxIdleTimeMillis = defaultMaxIdleTimeSecs * 1000;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.multiServer) {
            try {
                int clockTolerance;
                this.clockToleranceMillis = clockTolerance = PropertiesManager.getPropertyAsInt("org.jasig.portal.concurrency.clockTolerance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public IEntityCache newCache(Class type, int maxSize, int maxIdleTime, int sweepInterval) throws CachingException {
        return this.multiServer ? new ReferenceInvalidatingEntityCache(type, maxSize, maxIdleTime, sweepInterval, this.clockToleranceMillis) : new ReferenceEntityCache(type, maxSize, maxIdleTime, sweepInterval);
    }

    public void remove(Class type, String key) throws CachingException {
        this.getCache(type).remove(key);
    }

    protected void setCaches(Map newCaches) {
        this.caches = newCaches;
    }

    public static synchronized IEntityCachingService singleton() throws CachingException {
        if (singleton == null) {
            singleton = new ReferenceEntityCachingService();
        }
        return singleton;
    }

    public void update(IBasicEntity ent) throws CachingException {
        this.getCache(ent.getEntityIdentifier().getType()).update(ent);
    }
}

