/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.concurrency.caching;

import java.util.Date;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IBasicEntity;
import org.jasig.portal.concurrency.CachingException;
import org.jasig.portal.concurrency.caching.CachedEntityInvalidation;
import org.jasig.portal.concurrency.caching.RDBMCachedEntityInvalidationStore;
import org.jasig.portal.concurrency.caching.ReferenceEntityCache;
import org.jasig.portal.services.LogService;
import org.jasig.portal.services.SequenceGenerator;

public class ReferenceInvalidatingEntityCache
extends ReferenceEntityCache {
    private static RDBMCachedEntityInvalidationStore invalidationStore;
    private long lastUpdateMillis = 0L;
    private long clockTolerance = 5000L;
    private int cacheID = -1;
    private static final String CACHE_ID_SEQUENCE = "UP_ENTITY_CACHE";

    public ReferenceInvalidatingEntityCache(Class type, int maxSize, int maxUnusedTime, int sweepInterval, int clock) throws CachingException {
        super(type, maxSize, maxUnusedTime, sweepInterval);
        this.clockTolerance = clock;
        this.initializeCacheID();
    }

    public ReferenceInvalidatingEntityCache(Class type, int maxSize, int maxUnusedTime, int sweepInterval) throws CachingException {
        super(type, maxSize, maxUnusedTime, sweepInterval);
    }

    public void add(IBasicEntity entity) throws CachingException {
        super.add(new CacheEntry(entity));
    }

    public void cleanupCache() {
        String msg = null;
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        this.debug("ENTERING " + this + " cleanupCache() ");
        if (!this.getCache().isEmpty()) {
            this.removeInvalidEntities();
            super.cleanupCache();
        }
        end = System.currentTimeMillis();
        msg = "LEAVING " + this + " cleanupCache(); total time: " + (end - start) + "ms";
        this.debug(msg);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public IBasicEntity get(String key) {
        CacheEntry entry = (CacheEntry)this.primGet(key);
        return entry != null ? entry.getEntity() : null;
    }

    private static synchronized RDBMCachedEntityInvalidationStore getInvalidationStore() throws CachingException {
        if (invalidationStore == null) {
            invalidationStore = new RDBMCachedEntityInvalidationStore();
        }
        return invalidationStore;
    }

    public void invalidate(IBasicEntity entity) throws CachingException {
        CachedEntityInvalidation cei = new CachedEntityInvalidation(entity.getEntityIdentifier(), new Date(), this.getCacheID());
        ReferenceInvalidatingEntityCache.getInvalidationStore().add(cei);
    }

    private IBasicEntity primGet(String key) {
        return super.get(key);
    }

    private void primRemove(String key) throws CachingException {
        super.remove(key);
    }

    public void remove(String key) throws CachingException {
        IBasicEntity ent = this.get(key);
        if (ent != null) {
            this.invalidate(ent);
            this.primRemove(key);
        }
    }

    public void removeInvalidEntities() {
        CachedEntityInvalidation[] invalidations = null;
        long nowMillis = System.currentTimeMillis();
        Date lastUpdate = new Date(this.lastUpdateMillis - this.clockTolerance);
        int removed = 0;
        this.debug("ReferenceInvalidatingEntityCache.removeInvalidEntries(): " + this.getEntityType() + " checking for cache invalidations added since: " + lastUpdate);
        try {
            Integer cID = new Integer(this.getCacheID());
            invalidations = ReferenceInvalidatingEntityCache.getInvalidationStore().findAfter(lastUpdate, this.getEntityType(), null, cID);
            this.debug("ReferenceInvalidatingEntityCache.removeInvalidEntries(): " + this.getEntityType() + " retrieved " + invalidations.length + " invalidations.");
            for (int i = 0; i < invalidations.length; ++i) {
                long invalidationTime;
                long entryCreationTime;
                String key = invalidations[i].getKey();
                CacheEntry entry = (CacheEntry)this.primGet(key);
                if (entry == null || (entryCreationTime = entry.getCreationTime().getTime()) >= (invalidationTime = invalidations[i].getInvalidationTime().getTime()) + this.clockTolerance) continue;
                this.primRemove(key);
                ++removed;
            }
            this.debug("ReferenceInvalidatingEntityCache.removeInvalidEntries(): " + this.getEntityType() + " removed " + removed + " cache entries.");
        }
        catch (Exception ex) {
            LogService.log(LogService.ERROR, "ReferenceInvalidatingEntityCache.removeInvalidEntries(): " + ex.getMessage());
        }
        this.lastUpdateMillis = nowMillis;
    }

    public String toString() {
        return "ReferenceInvalidatingEntityCache for " + this.getEntityType().getName();
    }

    public void update(IBasicEntity entity) throws CachingException {
        this.invalidate(entity);
        this.add(entity);
    }

    public int getCacheID() {
        return this.cacheID;
    }

    private void initializeCacheID() throws CachingException {
        try {
            this.cacheID = SequenceGenerator.instance().getNextInt(CACHE_ID_SEQUENCE);
        }
        catch (Exception ex) {
            LogService.log(LogService.ERROR, "ReferenceInvalidatingEntityCache.initializeCacheID(): " + ex.getMessage());
            throw new CachingException(ex.getMessage());
        }
    }

    class CacheEntry
    implements IBasicEntity {
        protected IBasicEntity ent;
        protected Date creationTime = new Date();

        protected CacheEntry(IBasicEntity entity) {
            this.ent = entity;
        }

        public EntityIdentifier getEntityIdentifier() {
            return this.ent.getEntityIdentifier();
        }

        public Class getType() {
            return this.getEntityIdentifier().getType();
        }

        public String getKey() {
            return this.getEntityIdentifier().getKey();
        }

        public IBasicEntity getEntity() {
            return this.ent;
        }

        public Date getCreationTime() {
            return this.creationTime;
        }
    }
}

