/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.groups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.services.LogService;

public class EntityTypes {
    private static EntityTypes singleton;
    private Map entityTypesByID;
    private Map entityIDsByType;
    private static String ENTITY_TYPE_TABLE;
    private static String TYPE_ID_COLUMN;
    private static String TYPE_NAME_COLUMN;
    private static String selectEntityTypesSql;
    public static int NULL_TYPE_ID;
    public static Class GROUP_ENTITY_TYPE;

    public EntityTypes() {
        this.initialize();
    }

    public Iterator getAllEntityTypeIDs() {
        return this.entityTypesByID.keySet().iterator();
    }

    public Iterator getAllEntityTypes() {
        return this.entityTypesByID.values().iterator();
    }

    public Integer getEntityIDFromType(Class type) {
        return (Integer)this.getEntityIDsByType().get(type);
    }

    private Map getEntityIDsByType() {
        if (this.entityIDsByType == null) {
            this.entityIDsByType = new HashMap(5);
        }
        return this.entityIDsByType;
    }

    public static Class getEntityType(Integer typeID) {
        return EntityTypes.singleton().getEntityTypeFromID(typeID);
    }

    public Class getEntityTypeFromID(Integer typeID) {
        return (Class)this.getEntityTypesByID().get(typeID);
    }

    public static Integer getEntityTypeID(Class type) {
        return EntityTypes.singleton().getEntityIDFromType(type);
    }

    private Map getEntityTypesByID() {
        if (this.entityTypesByID == null) {
            this.entityTypesByID = new HashMap(5);
        }
        return this.entityTypesByID;
    }

    private static String getSelectEntityTypesSql() {
        if (selectEntityTypesSql == null) {
            selectEntityTypesSql = "SELECT " + TYPE_ID_COLUMN + ", " + TYPE_NAME_COLUMN + " FROM " + ENTITY_TYPE_TABLE;
        }
        return selectEntityTypesSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Connection conn = null;
        Integer typeID = null;
        Class<?> entityType = null;
        try {
            GROUP_ENTITY_TYPE = Class.forName("org.jasig.portal.groups.IEntityGroup");
            conn = RDBMServices.getConnection();
            Statement stmnt = conn.createStatement();
            try {
                ResultSet rs = stmnt.executeQuery(EntityTypes.getSelectEntityTypesSql());
                try {
                    while (rs.next()) {
                        typeID = new Integer(rs.getInt(1));
                        entityType = Class.forName(rs.getString(2));
                        this.getEntityIDsByType().put(entityType, typeID);
                        this.getEntityTypesByID().put(typeID, entityType);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmnt.close();
            }
        }
        catch (Exception ex) {
            try {
                LogService.log(LogService.ERROR, ex);
            }
            catch (Throwable throwable) {
                RDBMServices.releaseConnection(conn);
                throw throwable;
            }
            RDBMServices.releaseConnection(conn);
        }
        RDBMServices.releaseConnection(conn);
    }

    public static synchronized EntityTypes singleton() {
        if (singleton == null) {
            singleton = new EntityTypes();
        }
        return singleton;
    }

    static {
        ENTITY_TYPE_TABLE = "UP_ENTITY_TYPE";
        TYPE_ID_COLUMN = "ENTITY_TYPE_ID";
        TYPE_NAME_COLUMN = "ENTITY_TYPE_NAME";
        NULL_TYPE_ID = -1;
        GROUP_ENTITY_TYPE = null;
    }
}

