/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n;

import java.util.Locale;
import org.apache.oro.text.perl.Perl5Util;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.PortalException;
import org.jasig.portal.ResourceMissingException;
import org.jasig.portal.StylesheetSet;
import org.jasig.portal.services.LogService;
import org.jasig.portal.utils.ResourceLoader;
import org.jasig.portal.utils.XSLT;

public class LocaleAwareXSLT
extends XSLT {
    protected Locale[] locales;
    private static Perl5Util perl5Util = new Perl5Util();

    public LocaleAwareXSLT(Object instance) {
        super(instance);
    }

    public LocaleAwareXSLT(Object instance, Locale[] locales) {
        this(instance);
        this.locales = locales;
    }

    public void setLocales(Locale[] locales) {
        this.locales = locales;
    }

    public void setXSL(String sslUri, String stylesheetTitle, BrowserInfo browserInfo) throws PortalException {
        StylesheetSet set = LocaleAwareXSLT.getStylesheetSet(ResourceLoader.getResourceAsURLString(this.caller.getClass(), sslUri));
        set.setMediaProps("/properties/media.properties");
        String xslUri = set.getStylesheetURI(stylesheetTitle, browserInfo);
        xslUri = LocaleAwareXSLT.getLocaleAwareXslUri(xslUri, this.locales, this.caller);
        this.setXSL(xslUri);
    }

    public void setXSL(String sslUri, BrowserInfo browserInfo) throws PortalException {
        this.setXSL(sslUri, null, browserInfo);
    }

    public static String getLocaleAwareXslUri(String xslUri, Locale[] locales, Object caller) {
        String localeAwareXslUri = xslUri;
        if (locales == null) {
            try {
                xslUri = ResourceLoader.getResourceAsURLString(caller.getClass(), xslUri);
                LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file found as " + xslUri);
            }
            catch (ResourceMissingException e) {
                LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file NOT found as " + xslUri);
            }
        } else {
            int i;
            for (i = 0; i < locales.length; ++i) {
                localeAwareXslUri = perl5Util.substitute("s/\\.xsl/_" + locales[i] + ".xsl" + "/g", xslUri);
                LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: locale aware xslUri=" + localeAwareXslUri);
                try {
                    xslUri = ResourceLoader.getResourceAsURLString(caller.getClass(), localeAwareXslUri);
                    LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file found as " + xslUri);
                    break;
                }
                catch (ResourceMissingException e) {
                    LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file NOT found as " + localeAwareXslUri);
                    LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: Fallbacking...");
                    continue;
                }
            }
            if (i == locales.length) {
                try {
                    xslUri = ResourceLoader.getResourceAsURLString(caller.getClass(), xslUri);
                    LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file found as " + xslUri);
                }
                catch (ResourceMissingException e) {
                    LogService.log(LogService.DEBUG, "LocaleAwareXSLT.getLocaleAwareXslUri: XSL file NOT found as " + xslUri);
                }
            }
        }
        return xslUri;
    }
}

