/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Vector;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.ALChannel;
import org.jasig.portal.layout.ALChannelDescription;
import org.jasig.portal.layout.ALFolder;
import org.jasig.portal.layout.ALFolderDescription;
import org.jasig.portal.layout.IALNodeDescription;
import org.jasig.portal.layout.IUserLayoutChannelDescription;
import org.jasig.portal.layout.IUserLayoutFolderDescription;
import org.jasig.portal.layout.IUserLayoutNodeDescription;
import org.jasig.portal.layout.restrictions.IUserLayoutRestriction;
import org.w3c.dom.Element;

public abstract class ALNode {
    protected String parentNodeId;
    protected String nextNodeId;
    protected String previousNodeId;
    protected IALNodeDescription nodeDescription;
    protected int priority = 0;

    public ALNode() {
    }

    public ALNode(IALNodeDescription nd) {
        this.nodeDescription = nd;
    }

    public String getId() {
        return this.nodeDescription.getId();
    }

    public String getFragmentId() {
        return this.nodeDescription.getFragmentId();
    }

    public String getFragmentNodeId() {
        return this.nodeDescription.getFragmentNodeId();
    }

    public abstract int getNodeType();

    public void setNodeDescription(IALNodeDescription nd) {
        this.nodeDescription = nd;
    }

    public IALNodeDescription getNodeDescription() {
        return this.nodeDescription;
    }

    public void setParentNodeId(String parentNodeId) {
        this.parentNodeId = parentNodeId;
    }

    public String getParentNodeId() {
        return this.parentNodeId;
    }

    public void setNextNodeId(String nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public String getNextNodeId() {
        return this.nextNodeId;
    }

    public void setPreviousNodeId(String previousNodeId) {
        this.previousNodeId = previousNodeId;
    }

    public String getPreviousNodeId() {
        return this.previousNodeId;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public IUserLayoutRestriction getRestriction(String restrictionName) {
        if (this.nodeDescription != null) {
            return this.nodeDescription.getRestriction(restrictionName);
        }
        return null;
    }

    public Vector getRestrictionsByPath(String restrictionPath) {
        if (this.nodeDescription != null) {
            return this.nodeDescription.getRestrictionsByPath(restrictionPath);
        }
        return new Vector();
    }

    protected void addNodeAttributes(Element node) {
        this.nodeDescription.addNodeAttributes(node);
        node.setAttribute("priority", this.priority + "");
    }

    public static IALNodeDescription createUserLayoutNodeDescription(Element xmlNode) throws PortalException {
        String nodeName = xmlNode.getNodeName();
        System.out.println("Node name: " + nodeName);
        if (nodeName.equals("channel")) {
            return new ALChannelDescription(xmlNode);
        }
        if (nodeName.equals("folder")) {
            return new ALFolderDescription(xmlNode);
        }
        throw new PortalException("Given XML element is neither folder nor channel");
    }

    public static ALNode createALNode(IUserLayoutNodeDescription nodeDescription) throws PortalException {
        if (nodeDescription instanceof IUserLayoutFolderDescription) {
            return new ALFolder(new ALFolderDescription((IUserLayoutFolderDescription)nodeDescription));
        }
        if (nodeDescription instanceof IUserLayoutChannelDescription) {
            return new ALChannel(new ALChannelDescription((IUserLayoutChannelDescription)nodeDescription));
        }
        throw new PortalException("ALNode::createALNode() : The node description supplied is neither a folder nor a channel! Can't make the ALNode");
    }
}

