/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.restrictions;

import java.util.StringTokenizer;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.ALNode;
import org.jasig.portal.layout.restrictions.UserLayoutRestriction;
import org.jasig.portal.utils.CommonUtils;

public class PriorityRestriction
extends UserLayoutRestriction {
    private int minPriority;
    private int maxPriority;

    public PriorityRestriction(String nodePath) {
        super(nodePath);
    }

    public PriorityRestriction() {
        super(LOCAL_RESTRICTION);
    }

    public int getMaxValue() {
        return this.maxPriority;
    }

    public int getMinValue() {
        return this.minPriority;
    }

    public int[] getRange() {
        return new int[]{this.minPriority, this.maxPriority};
    }

    public int getRestrictionType() {
        return 1 | super.getRestrictionType();
    }

    protected void parseRestrictionExpression() throws PortalException {
        try {
            String restrictionExp = this.getRestrictionExpression();
            if (restrictionExp.indexOf(45) > 0) {
                StringTokenizer st = new StringTokenizer(restrictionExp, "-");
                String min = st.nextToken();
                String max = st.nextToken();
                this.minPriority = CommonUtils.parseInt(min, 0);
                this.maxPriority = CommonUtils.parseInt(max, Integer.MAX_VALUE);
            } else {
                this.maxPriority = this.minPriority = CommonUtils.parseInt(restrictionExp, 0);
            }
        }
        catch (Exception e) {
            throw new PortalException(e.getMessage());
        }
    }

    public boolean checkRestriction(String propertyValue) throws PortalException {
        int priority = CommonUtils.parseInt(propertyValue, 0);
        return priority <= this.maxPriority && priority >= this.minPriority;
    }

    public boolean checkRestriction(ALNode node) throws PortalException {
        if (this.nodePath != null && !this.nodePath.equals(LOCAL_RESTRICTION)) {
            int[] range;
            PriorityRestriction restriction = (PriorityRestriction)node.getRestriction(PriorityRestriction.getRestrictionName(1, null));
            return restriction == null || this.minPriority <= (range = restriction.getRange())[1] && this.maxPriority >= range[0];
        }
        int priority = node.getPriority();
        return priority <= this.maxPriority && priority >= this.minPriority;
    }

    public void setRestriction(int minPriority, int maxPriority) {
        this.minPriority = minPriority;
        this.maxPriority = maxPriority;
        this.setRestrictionExpression(new String(minPriority + "-" + maxPriority));
    }
}

