/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.utils;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.UserProfile;
import org.jasig.portal.utils.CommonUtils;

public class ALMigrationUtil {
    private static final int ADD = 1;
    private static final int DELETE = 2;
    private static final int DEFAULT_SS_ID = 1;
    private static IUserLayoutStore ulsdb = null;
    private Properties props = new Properties();

    public ALMigrationUtil() throws Exception {
        if (ulsdb == null) {
            ulsdb = UserLayoutStoreFactory.getUserLayoutStoreImpl();
        }
        InputStream is = this.getClass().getResourceAsStream("/properties/al/al.properties");
        this.props.load(is);
    }

    public void registerStylesheet(String stylesheetURI, String stylesheetDescriptionURI, int stylesheetId, boolean isTheme, int command) {
        try {
            switch (command) {
                case 2: {
                    if (stylesheetId <= 1) break;
                    this.updateUserProfile(CommonUtils.parseInt(this.props.getProperty("defaultSystemStylesheetId"), 1));
                    if (isTheme) {
                        ulsdb.removeThemeStylesheetDescription(stylesheetId);
                        break;
                    }
                    ulsdb.removeStructureStylesheetDescription(stylesheetId);
                    break;
                }
                case 1: {
                    Integer id = null;
                    id = isTheme ? ulsdb.addThemeStylesheetDescription(stylesheetDescriptionURI, stylesheetURI) : ulsdb.addStructureStylesheetDescription(stylesheetDescriptionURI, stylesheetURI);
                    if (id == null) {
                        System.out.println("Save failed: stylesheet ID = null");
                        return;
                    }
                    stylesheetId = id;
                    System.out.println("Save successfull! The new " + (isTheme ? "theme" : "structure") + " stylesheet was assigned with Id=" + id);
                    this.updateUserProfile(stylesheetId);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("registerStylesheet: An error has been encountered:");
            e.printStackTrace();
        }
    }

    public void updateUserProfile(int stylesheetId) {
        try {
            System.out.println("Updating the system profile...");
            Hashtable profileList = ulsdb.getSystemProfileList();
            if (profileList != null) {
                Enumeration profiles = profileList.elements();
                while (profiles.hasMoreElements()) {
                    UserProfile profile = (UserProfile)profiles.nextElement();
                    profile.setStructureStylesheetId(stylesheetId);
                    profile.setThemeStylesheetId(stylesheetId);
                    ulsdb.updateSystemProfile(profile);
                }
            }
            System.out.println("The profile is succesfully updated");
        }
        catch (Exception e) {
            System.out.println("updateUserProfile: An error has been encountered:");
            e.printStackTrace();
        }
    }

    public int getSystemStylesheetId() {
        try {
            Enumeration profiles;
            Hashtable profileList = ulsdb.getSystemProfileList();
            if (profileList != null && (profiles = profileList.elements()).hasMoreElements()) {
                UserProfile profile = (UserProfile)profiles.nextElement();
                return profile.getStructureStylesheetId();
            }
        }
        catch (Exception e) {
            System.out.println("getSystemStylesheetId: An error has been encountered:");
            e.printStackTrace();
        }
        return -1;
    }

    public String getProperty(String name) {
        String value;
        if (this.props != null && (value = this.props.getProperty(name)) != null) {
            return value.trim();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: ALMigrationUtil -Daction=[add|delete]");
            return;
        }
        int command = "delete".equalsIgnoreCase(args[0]) ? 2 : 1;
        try {
            ALMigrationUtil al = new ALMigrationUtil();
            String themeURI = al.getProperty("themeStylesheetURI");
            String themeDescriptionURI = al.getProperty("themeStylesheetDescURI");
            String structureURI = al.getProperty("structureStylesheetURI");
            String structureDescriptionURI = al.getProperty("structureStylesheetDescURI");
            int stylesheetId = al.getSystemStylesheetId();
            al.registerStylesheet(structureURI, structureDescriptionURI, stylesheetId, false, command);
            al.registerStylesheet(themeURI, themeDescriptionURI, stylesheetId, true, command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

