/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jasig.portal.ChannelDefinition;
import org.jasig.portal.ChannelRegistryStoreFactory;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IChannelRegistryStore;
import org.jasig.portal.IUserLayoutStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.UserLayoutStoreFactory;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.layout.IAggregatedUserLayoutStore;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class PushFragmentLoader {
    static final String configXSL = "/properties/al/PushFragmentLoader.xsl";
    static /* synthetic */ Class class$org$jasig$portal$layout$utils$PushFragmentLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String alConfigFile = args[0];
        String outputDataFile = args[1];
        HashMap<String, String> rNames = new HashMap<String, String>();
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            if (con != null) {
                Statement stmt = con.createStatement();
                String query = "SELECT RESTRICTION_TYPE,RESTRICTION_NAME FROM UP_RESTRICTIONS";
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    rNames.put(rs.getString("RESTRICTION_NAME"), rs.getString("RESTRICTION_TYPE"));
                    System.out.println("DEBUG: restriction type mapping " + rs.getString("RESTRICTION_NAME") + " -> " + rs.getString("RESTRICTION_TYPE"));
                }
            } else {
                System.out.println("ERROR: unable to obtain database connection.");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: exception raised while reading restriction type mappings:");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (con != null) {
                RDBMServices.releaseConnection(con);
            }
        }
        SAXTransformerFactory saxTFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        System.out.println("DEBUG: reading XSLT from url=" + (class$org$jasig$portal$layout$utils$PushFragmentLoader == null ? (class$org$jasig$portal$layout$utils$PushFragmentLoader = PushFragmentLoader.class$("org.jasig.portal.layout.utils.PushFragmentLoader")) : class$org$jasig$portal$layout$utils$PushFragmentLoader).getResource(configXSL));
        XMLReader reader = XMLReaderFactory.createXMLReader();
        TransformerHandler thand = saxTFactory.newTransformerHandler(new StreamSource((class$org$jasig$portal$layout$utils$PushFragmentLoader == null ? (class$org$jasig$portal$layout$utils$PushFragmentLoader = PushFragmentLoader.class$("org.jasig.portal.layout.utils.PushFragmentLoader")) : class$org$jasig$portal$layout$utils$PushFragmentLoader).getResourceAsStream(configXSL)));
        ConfigFilter filter = new ConfigFilter(thand, rNames);
        reader.setContentHandler(filter);
        thand.setResult(new StreamResult(outputDataFile));
        try {
            reader.parse(new InputSource((class$org$jasig$portal$layout$utils$PushFragmentLoader == null ? (class$org$jasig$portal$layout$utils$PushFragmentLoader = PushFragmentLoader.class$("org.jasig.portal.layout.utils.PushFragmentLoader")) : class$org$jasig$portal$layout$utils$PushFragmentLoader).getResourceAsStream(alConfigFile)));
        }
        catch (Exception e) {
            throw new PortalException("The push fragment file \"" + alConfigFile + "\" could not be found!");
        }
        DbCleaner.fragmentNames = filter.getFragmentNames();
        DbCleaner.cleanTables();
        System.out.println("DEBUG: done");
        System.exit(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    static String getGroupKey(String groupName) throws Exception {
        EntityIdentifier[] mg = GroupService.searchForGroups(groupName, 1, Class.forName("org.jasig.portal.security.IPerson"));
        if (mg != null && mg.length > 0) {
            if (mg.length <= 1) {
                System.out.println("DEBUG: group \"" + groupName + "\", key=\"" + mg[0].getKey() + "\"");
                return mg[0].getKey();
            }
            System.out.println("ERROR: group name \"" + groupName + "\" matches several existing groups: [Key\tName\tDescription]");
            int i = 0;
            while (true) {
                if (i >= mg.length) {
                    System.out.println("Please modify config file to specify group key directly (i.e. <group key=\"keyValue\">...)");
                    System.exit(1);
                    return null;
                }
                IEntityGroup g = GroupService.findGroup(mg[i].getKey());
                System.out.print("\t\"" + g.getKey() + "\"\t" + g.getName() + "\"\t" + g.getDescription());
                ++i;
            }
        }
        System.out.println("ERROR: can not find user group with name \"" + groupName + "\" in the database !");
        EntityIdentifier[] mg2 = GroupService.searchForGroups(groupName, 4, Class.forName("org.jasig.portal.security.IPerson"));
        if (mg2 == null) throw new PortalException("ERROR: can not find user group with name \"" + groupName + "\" in the database !");
        if (mg2.length <= 0) throw new PortalException("ERROR: can not find user group with name \"" + groupName + "\" in the database !");
        System.out.print("Possible matches are: [");
        int i = 0;
        while (true) {
            if (i >= mg2.length) {
                System.out.println("]");
                throw new PortalException("ERROR: can not find user group with name \"" + groupName + "\" in the database !");
            }
            IEntityGroup g = GroupService.findGroup(mg2[i].getKey());
            System.out.print("\"" + g.getName() + "\" ");
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConfigFilter
    extends SAX2FilterImpl {
        Map rMap;
        boolean groupMode = false;
        AttributesImpl groupAtts;
        String groupLocalName;
        String groupUri;
        String groupData = null;
        private Vector fragmentNames;
        private static IAggregatedUserLayoutStore layoutStore = null;
        private static IChannelRegistryStore channelStore = null;

        public ConfigFilter(ContentHandler ch, Map rMap) throws PortalException {
            super(ch);
            this.rMap = rMap;
            this.fragmentNames = new Vector();
            if (layoutStore == null) {
                IUserLayoutStore layoutStoreImpl = UserLayoutStoreFactory.getUserLayoutStoreImpl();
                if (layoutStoreImpl == null || !(layoutStoreImpl instanceof IAggregatedUserLayoutStore)) {
                    throw new PortalException("The user layout store is NULL or must implement IAggregatedUserLayoutStore!");
                }
                layoutStore = (IAggregatedUserLayoutStore)layoutStoreImpl;
            }
            if (channelStore == null) {
                channelStore = ChannelRegistryStoreFactory.getChannelRegistryStoreImpl();
            }
        }

        public Vector getFragmentNames() {
            return this.fragmentNames;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.groupMode) {
                String ds = new String(ch, start, length);
                this.groupData = this.groupData == null ? ds : this.groupData + ds;
            } else {
                super.characters(ch, start, length);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl ai = new AttributesImpl(atts);
            if (qName.equals("fragment")) {
                String name = atts.getValue("name");
                if (!this.fragmentNames.contains(name)) {
                    this.fragmentNames.add(name);
                }
                try {
                    ai.addAttribute(uri, "id", "id", "CDATA", layoutStore.getNextFragmentId());
                }
                catch (PortalException pe) {
                    throw new SAXException(pe.getMessage());
                }
            }
            if (qName.equals("channel")) {
                String fname = atts.getValue("fname");
                try {
                    ChannelDefinition chanDef = channelStore.getChannelDefinition(fname);
                    ai.addAttribute(uri, "id", "id", "CDATA", chanDef.getId() + "");
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
            if (qName.equals("group")) {
                this.groupMode = true;
                this.groupUri = uri;
                this.groupLocalName = localName;
                this.groupAtts = new AttributesImpl(atts);
            } else if (qName.equals("restriction")) {
                if (ai.getIndex("type") != -1) {
                    if (!this.rMap.containsValue(ai.getValue("type"))) {
                        System.out.println("ERROR: specified restriction type \"" + ai.getValue("type") + "\" does not exist ! Either correct the type value, or consider using match by restriction name (i.e. <restriction name=\"priority\" ...)");
                        System.exit(1);
                    } else if (ai.getIndex("name") != -1 && this.rMap.containsKey(ai.getValue("name")) && !ai.getValue("type").equals((String)this.rMap.get(ai.getValue("name")))) {
                        System.out.println("ERROR: specified restriction type \"" + ai.getValue("type") + "\" does not match the specified name \"" + ai.getValue("name") + "\" in the database. name \"" + ai.getValue("name") + "\" matches restriction type \"" + (String)this.rMap.get(ai.getValue("name")) + "\"");
                        System.exit(1);
                    } else {
                        super.startElement(uri, localName, qName, ai);
                    }
                } else {
                    String restrName = ai.getValue("name");
                    String restrType = (String)this.rMap.get(restrName);
                    if (restrType != null) {
                        ai.addAttribute(uri, "type", "type", "CDATA", restrType);
                    } else {
                        System.out.println("ERROR: config file specifies a restriction name \"" + restrName + "\" which is not registered with the database!");
                        System.exit(1);
                    }
                    super.startElement(uri, localName, qName, ai);
                }
            } else {
                super.startElement(uri, localName, qName, ai);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.groupMode) {
                block17: {
                    if (qName.equals("group")) {
                        if (this.groupAtts.getIndex("key") == -1) {
                            if (this.groupData != null) {
                                String groupKey = null;
                                try {
                                    groupKey = PushFragmentLoader.getGroupKey(this.groupData);
                                }
                                catch (Exception e) {
                                    System.out.println("ERROR: encountered exception while trying to determine group key for a group name \"" + this.groupData + "\"");
                                    e.printStackTrace();
                                    System.exit(1);
                                }
                                this.groupAtts.addAttribute(this.groupUri, "key", "key", "CDATA", groupKey);
                                super.startElement(this.groupUri, this.groupLocalName, "group", this.groupAtts);
                                super.characters(this.groupData.toCharArray(), 0, this.groupData.length());
                                super.endElement(this.groupUri, this.groupLocalName, "group");
                            } else {
                                System.out.println("ERROR: one of the group elements is empty and no group key has been specified !");
                                System.exit(1);
                            }
                        } else {
                            try {
                                IEntityGroup g = GroupService.findGroup(this.groupAtts.getValue("key"));
                                if (g != null) {
                                    if (this.groupData != null) {
                                        if (g.getName().equals(this.groupData)) {
                                            System.out.println("DEBUG: group key=\"" + this.groupAtts.getValue("key") + "\" checked out with the name \"" + this.groupData + "\".");
                                            super.startElement(this.groupUri, this.groupLocalName, "group", this.groupAtts);
                                            if (this.groupData != null) {
                                                super.characters(this.groupData.toCharArray(), 0, this.groupData.length());
                                            }
                                            super.endElement(this.groupUri, this.groupLocalName, "group");
                                        } else {
                                            System.out.println("ERROR: group key \"" + this.groupAtts.getValue("key") + "\" belongs to a group with a name \"" + g.getName() + "\", where the name specified by the config file is \"" + this.groupData + "\". Please fix the config file.");
                                            System.exit(1);
                                        }
                                    }
                                    break block17;
                                }
                                System.out.println("ERROR: unable to find a group with a key \"" + this.groupAtts.getValue("key") + "\"! Either correct the key, or consider matching the group by name.");
                                System.exit(1);
                            }
                            catch (Exception e) {
                                System.out.println("ERROR: exception raised while trying to look up group by a key=\"" + this.groupAtts.getValue("key") + "\"!");
                                e.printStackTrace();
                                System.exit(1);
                            }
                        }
                    } else {
                        System.out.println("WARNING: <group/> contains other elements, which it shouldn't! Please check config validity.");
                    }
                }
                this.groupMode = false;
                this.groupData = null;
                this.groupAtts = null;
                this.groupUri = null;
                this.groupLocalName = null;
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }

    private static class DbCleaner {
        private static Vector fragmentNames;

        private DbCleaner() {
        }

        public static void cleanTables() {
            block16: {
                Connection con = RDBMServices.getConnection();
                if (fragmentNames != null) {
                    try {
                        PreparedStatement fragmentIdstmt = con.prepareStatement("SELECT FRAGMENT_ID FROM UP_OWNER_FRAGMENT WHERE FRAGMENT_NAME = ?");
                        Vector<String> fragmentIds = new Vector<String>();
                        for (int i = 0; i < fragmentNames.size(); ++i) {
                            fragmentIdstmt.setString(1, (String)fragmentNames.get(i));
                            ResultSet rs = fragmentIdstmt.executeQuery();
                            if (rs.next()) {
                                fragmentIds.add(rs.getString(1));
                            }
                            if (rs == null) continue;
                            rs.close();
                        }
                        if (fragmentIdstmt != null) {
                            fragmentIdstmt.close();
                        }
                        if (fragmentIds.size() <= 0) break block16;
                        System.out.println("DEBUG: cleaning tables...");
                        con.setAutoCommit(false);
                        PreparedStatement deleteLayoutStruct = con.prepareStatement("DELETE FROM UP_LAYOUT_STRUCT_AGGR WHERE FRAGMENT_ID = ?");
                        PreparedStatement deleteFragments = con.prepareStatement("DELETE FROM UP_FRAGMENTS WHERE FRAGMENT_ID = ?");
                        PreparedStatement deleteFragmentRestrictions = con.prepareStatement("DELETE FROM UP_FRAGMENT_RESTRICTIONS WHERE FRAGMENT_ID = ?");
                        PreparedStatement deleteFragmentParams = con.prepareStatement("DELETE FROM UP_FRAGMENT_PARAM WHERE FRAGMENT_ID = ?");
                        PreparedStatement deleteOwnerFragment = con.prepareStatement("DELETE FROM UP_OWNER_FRAGMENT WHERE FRAGMENT_ID = ?");
                        PreparedStatement deleteGroupFragment = con.prepareStatement("DELETE FROM UP_GROUP_FRAGMENT WHERE FRAGMENT_ID = ?");
                        try {
                            for (int i = 0; i < fragmentIds.size(); ++i) {
                                int fragmentId = Integer.parseInt(fragmentIds.get(i).toString());
                                deleteLayoutStruct.setInt(1, fragmentId);
                                deleteFragments.setInt(1, fragmentId);
                                deleteFragmentRestrictions.setInt(1, fragmentId);
                                deleteFragmentParams.setInt(1, fragmentId);
                                deleteOwnerFragment.setInt(1, fragmentId);
                                deleteGroupFragment.setInt(1, fragmentId);
                                deleteLayoutStruct.executeUpdate();
                                deleteFragments.executeUpdate();
                                deleteFragmentRestrictions.executeUpdate();
                                deleteFragmentParams.executeUpdate();
                                deleteOwnerFragment.executeUpdate();
                                deleteGroupFragment.executeUpdate();
                            }
                            con.commit();
                        }
                        catch (Exception sqle) {
                            con.rollback();
                            System.out.println("DEBUG: " + sqle.getMessage());
                            sqle.printStackTrace();
                        }
                        if (deleteLayoutStruct != null) {
                            deleteLayoutStruct.close();
                        }
                        if (deleteFragments != null) {
                            deleteFragments.close();
                        }
                        if (deleteFragmentRestrictions != null) {
                            deleteFragmentRestrictions.close();
                        }
                        if (deleteFragmentParams != null) {
                            deleteFragmentParams.close();
                        }
                        if (deleteOwnerFragment != null) {
                            deleteOwnerFragment.close();
                        }
                        if (deleteGroupFragment != null) {
                            deleteGroupFragment.close();
                        }
                        if (con != null) {
                            con.close();
                        }
                        System.out.println("DEBUG: cleaning done...");
                    }
                    catch (Exception e) {
                        System.out.println("DEBUG: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

