/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jasig.portal.RDBMServices;

public class md5passwd {
    private static final String SELECTSTMT = "SELECT COUNT(*) FROM UP_PERSON_DIR WHERE USER_NAME = ?";
    private static final String UPDATESTMT = "UPDATE UP_PERSON_DIR SET ENCRPTD_PSWD = ? WHERE USER_NAME = ?";
    private static final String INSERTSTMT = "INSERT INTO UP_PERSON_DIR (USER_NAME, ENCRPTD_PSWD) VALUES (?, ?)";

    public md5passwd(String user, boolean create, boolean lock) throws IOException, NoSuchAlgorithmException, SQLException {
        byte[] rnd = new byte[8];
        byte[] fin = new byte[24];
        Long date = new Long(new Date().getTime());
        SecureRandom r = new SecureRandom(date.toString().getBytes());
        MessageDigest md = MessageDigest.getInstance("MD5");
        RDBMServices rdbm = new RDBMServices();
        int cnt = 0;
        if (user == null || user.trim().length() <= 0) {
            System.out.println("You did not specify a valid user name.  Please try again.");
            System.exit(0);
        }
        Connection conn = RDBMServices.getConnection();
        PreparedStatement stmt = conn.prepareStatement(SELECTSTMT);
        stmt.setString(1, user);
        ResultSet rset = stmt.executeQuery();
        if (rset.next()) {
            cnt = rset.getInt(1);
        }
        rset.close();
        stmt.close();
        if (cnt < 1 && !create) {
            System.out.println("No such user: " + user);
            RDBMServices.releaseConnection(conn);
            return;
        }
        if (!lock) {
            r.nextBytes(rnd);
            md.update(rnd);
            System.out.print("Enter Password for " + user + ": ");
            System.out.flush();
            BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
            String spass = d.readLine();
            byte[] hash = md.digest(spass.getBytes());
            System.arraycopy(rnd, 0, fin, 0, 8);
            System.arraycopy(hash, 0, fin, 8, 16);
        } else {
            fin = "*LCK*".getBytes();
        }
        if (cnt < 1) {
            stmt = conn.prepareStatement(INSERTSTMT);
            stmt.setString(1, user);
            stmt.setString(2, "(MD5)" + md5passwd.encode(fin));
            stmt.executeUpdate();
        } else {
            stmt = conn.prepareStatement(UPDATESTMT);
            stmt.setString(1, "(MD5)" + md5passwd.encode(fin));
            stmt.setString(2, user);
            stmt.executeUpdate();
        }
        stmt.close();
        RDBMServices.releaseConnection(conn);
        System.out.println("Password Updated...");
    }

    public static void main(String[] args) throws IOException, NoSuchAlgorithmException, SQLException {
        if (args.length == 1 && args[0].charAt(0) != '-') {
            md5passwd me = new md5passwd(args[0], false, false);
        } else if (args.length == 2 && args[0].equals("-c") && args[1].charAt(0) != '-') {
            md5passwd me = new md5passwd(args[1], true, false);
        } else if (args.length == 2 && args[0].equals("-l") && args[1].charAt(0) != '-') {
            md5passwd me = new md5passwd(args[1], false, true);
        } else {
            System.err.println("Usage \"md5passwd [-c| -l] <user>\"");
            return;
        }
    }

    private static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(md5passwd.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    private static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = md5passwd.getChar(sixbit);
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    private static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }
}

