/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.security.provider;

import java.util.Vector;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IAuthorizationService;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionPolicy;

public class AuthorizationPrincipalImpl
implements IAuthorizationPrincipal {
    private String key;
    private Class type;
    private IAuthorizationService authorizationService;
    private String principalString;

    public AuthorizationPrincipalImpl(String newKey, Class newType) {
        this(newKey, newType, null);
    }

    public AuthorizationPrincipalImpl(String newKey, Class newType, IAuthorizationService authService) {
        this.key = newKey;
        this.type = newType;
        this.authorizationService = authService;
        this.initialize();
    }

    public boolean canPublish() throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalPublish(this);
    }

    public boolean canRender(int channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalRender(this, channelPublishId);
    }

    public boolean canSubscribe(int channelPublishId) throws AuthorizationException {
        return this.getAuthorizationService().canPrincipalSubscribe(this, channelPublishId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IAuthorizationPrincipal)) {
            return false;
        }
        IAuthorizationPrincipal otherAP = (IAuthorizationPrincipal)obj;
        return this.getKey().equals(otherAP.getKey()) && this.getType() == otherAP.getType();
    }

    public IPermission[] getAllPermissions() throws AuthorizationException {
        return this.getAllPermissions(null, null, null);
    }

    public IPermission[] getAllPermissions(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getAllPermissionsForPrincipal(this, owner, activity, target);
    }

    IAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public Vector getAuthorizedChannels() throws AuthorizationException {
        return this.getAuthorizationService().getAuthorizedChannels(this);
    }

    public String getKey() {
        return this.key;
    }

    public IPermission[] getPermissions() throws AuthorizationException {
        return this.getPermissions(null, null, null);
    }

    public IPermission[] getPermissions(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().getPermissionsForPrincipal(this, owner, activity, target);
    }

    public String getPrincipalString() {
        return this.principalString;
    }

    public Class getType() {
        return this.type;
    }

    public int hashCode() {
        return this.getKey().hashCode() + this.getType().hashCode();
    }

    public boolean hasPermission(String owner, String activity, String target) throws AuthorizationException {
        return this.getAuthorizationService().doesPrincipalHavePermission(this, owner, activity, target);
    }

    private void initialize() {
        this.principalString = this.getAuthorizationService().getPrincipalString(this);
    }

    void setAuthorizationService(IAuthorizationService newAuthorizationService) {
        this.authorizationService = newAuthorizationService;
    }

    public String toString() {
        return this.getPrincipalString();
    }

    public boolean hasPermission(String owner, String activity, String target, IPermissionPolicy policy) throws AuthorizationException {
        return this.getAuthorizationService().doesPrincipalHavePermission(this, owner, activity, target, policy);
    }
}

